.\" Automatically generated by Pod::Man version 1.15
.\" Thu Apr 25 09:34:52 2002
.\"
.\" Standard preamble:
.\" ======================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Ip \" List item
.br
.ie \\n(.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R

.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used
.\" to do unbreakable dashes and therefore won't be available.  \*(C` and
.\" \*(C' expand to `' in nroff, nothing in troff, for use with C<>
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` 
.    ds C' 
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr
.\" for titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and
.\" index entries marked with X<> in POD.  Of course, you'll have to process
.\" the output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it
.\" makes way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.bd B 3
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ======================================================================
.\"
.IX Title "sudo 8"
.TH sudo 8 "1.6.6" "April 25, 2002" "MAINTENANCE COMMANDS"
.UC
.SH "NAME"
sudo \- execute a command as another user
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\fBsudo\fR \fB\-V\fR | \fB\-h\fR | \fB\-l\fR | \fB\-L\fR | \fB\-v\fR | \fB\-k\fR | \fB\-K\fR | \fB\-s\fR |
[ \fB\-H\fR ] [\fB\-P\fR ] [\fB\-S\fR ] [ \fB\-b\fR ] | [ \fB\-p\fR \fIprompt\fR ]
[ \fB\-c\fR \fIclass\fR|\fI-\fR ] [ \fB\-a\fR \fIauth_type\fR ]
[ \fB\-u\fR \fIusername\fR|\fI#uid\fR ] \fIcommand\fR
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBsudo\fR allows a permitted user to execute a \fIcommand\fR as the
superuser or another user, as specified in the \fIsudoers\fR file.
The real and effective uid and gid are set to match those of the
target user as specified in the passwd file (the group vector is
also initialized when the target user is not root).  By default,
\&\fBsudo\fR requires that users authenticate themselves with a password
(\s-1NOTE:\s0 by default this is the user's password, not the root password).
Once a user has been authenticated, a timestamp is updated and the
user may then use sudo without a password for a short period of
time (\f(CW\*(C`5\*(C'\fR minutes unless overridden in \fIsudoers\fR).
.PP
\&\fBsudo\fR determines who is an authorized user by consulting the file
\&\fI/etc/sudoers\fR.  By giving \fBsudo\fR the \fB\-v\fR flag a user
can update the time stamp without running a \fIcommand.\fR The password
prompt itself will also time out if the user's password is not
entered within \f(CW\*(C`5\*(C'\fR minutes (unless overridden via
\&\fIsudoers\fR).
.PP
If a user who is not listed in the \fIsudoers\fR file tries to run a
command via \fBsudo\fR, mail is sent to the proper authorities, as
defined at configure time or the \fIsudoers\fR file (defaults to root).
Note that the mail will not be sent if an unauthorized user tries
to run sudo with the \fB\-l\fR or \fB\-v\fR flags.  This allows users to
determine for themselves whether or not they are allowed to use
\&\fBsudo\fR.
.PP
\&\fBsudo\fR can log both successful and unsuccessful attempts (as well
as errors) to \fIsyslog\fR\|(3), a log file, or both.  By default \fBsudo\fR
will log via \fIsyslog\fR\|(3) but this is changeable at configure time
or via the \fIsudoers\fR file.
.SH "OPTIONS"
.IX Header "OPTIONS"
\&\fBsudo\fR accepts the following command line options:
.Ip "\-V" 4
.IX Item "-V"
The \fB\-V\fR (\fIversion\fR) option causes \fBsudo\fR to print the
version number and exit.  If the invoking user is already root
the \fB\-V\fR option will print out a list of the defaults \fBsudo\fR
was compiled with as well as the machine's local network addresses.
.Ip "\-l" 4
.IX Item "-l"
The \fB\-l\fR (\fIlist\fR) option will list out the allowed (and
forbidden) commands for the user on the current host.
.Ip "\-L" 4
.IX Item "-L"
The \fB\-L\fR (\fIlist\fR defaults) option will list out the parameters
that may be set in a \fIDefaults\fR line along with a short description
for each.  This option is useful in conjunction with \fIgrep\fR\|(1).
.Ip "\-h" 4
.IX Item "-h"
The \fB\-h\fR (\fIhelp\fR) option causes \fBsudo\fR to print a usage message and exit.
.Ip "\-v" 4
.IX Item "-v"
If given the \fB\-v\fR (\fIvalidate\fR) option, \fBsudo\fR will update the
user's timestamp, prompting for the user's password if necessary.
This extends the \fBsudo\fR timeout for another \f(CW\*(C`5\*(C'\fR minutes
(or whatever the timeout is set to in \fIsudoers\fR) but does not run
a command.
.Ip "\-k" 4
.IX Item "-k"
The \fB\-k\fR (\fIkill\fR) option to \fBsudo\fR invalidates the user's timestamp
by setting the time on it to the epoch.  The next time \fBsudo\fR is
run a password will be required.  This option does not require a password
and was added to allow a user to revoke \fBsudo\fR permissions from a .logout
file.
.Ip "\-K" 4
.IX Item "-K"
The \fB\-K\fR (sure \fIkill\fR) option to \fBsudo\fR removes the user's timestamp
entirely.  Likewise, this option does not require a password.
.Ip "\-b" 4
.IX Item "-b"
The \fB\-b\fR (\fIbackground\fR) option tells \fBsudo\fR to run the given
command in the background.  Note that if you use the \fB\-b\fR
option you cannot use shell job control to manipulate the process.
.Ip "\-p" 4
.IX Item "-p"
The \fB\-p\fR (\fIprompt\fR) option allows you to override the default
password prompt and use a custom one.  If the password prompt
contains the \f(CW\*(C`%u\*(C'\fR escape, \f(CW\*(C`%u\*(C'\fR will be replaced with the user's
login name.  Similarly, \f(CW\*(C`%h\*(C'\fR will be replaced with the local
hostname.
.Ip "\-c" 4
.IX Item "-c"
The \fB\-c\fR (\fIclass\fR) option causes \fBsudo\fR to run the specified command
with resources limited by the specified login class.  The \fIclass\fR
argument can be either a class name as defined in /etc/login.conf,
or a single '\-' character.  Specifying a \fIclass\fR of \f(CW\*(C`\-\*(C'\fR indicates
that the command should be run restricted by the default login
capabilities for the user the command is run as.  If the \fIclass\fR
argument specifies an existing user class, the command must be run
as root, or the \fBsudo\fR command must be run from a shell that is already
root.  This option is only available on systems with \s-1BSD\s0 login classes
where \fBsudo\fR has been configured with the \-\-with-logincap option.
.Ip "\-a" 4
.IX Item "-a"
The \fB\-a\fR (\fIauthentication type\fR) option causes \fBsudo\fR to use the
specified authentication type when validating the user, as allowed
by /etc/login.conf.  The system administrator may specify a list
of sudo-specific authentication methods by adding an \*(L"auth-sudo\*(R"
entry in /etc/login.conf.  This option is only available on systems
that support \s-1BSD\s0 authentication where \fBsudo\fR has been configured
with the \-\-with-bsdauth option.
.Ip "\-u" 4
.IX Item "-u"
The \fB\-u\fR (\fIuser\fR) option causes \fBsudo\fR to run the specified command
as a user other than \fIroot\fR.  To specify a \fIuid\fR instead of a
\&\fIusername\fR, use \fI#uid\fR.
.Ip "\-s" 4
.IX Item "-s"
The \fB\-s\fR (\fIshell\fR) option runs the shell specified by the \fI\s-1SHELL\s0\fR
environment variable if it is set or the shell as specified
in \fIpasswd\fR\|(5).
.Ip "\-H" 4
.IX Item "-H"
The \fB\-H\fR (\fI\s-1HOME\s0\fR) option sets the \f(CW\*(C`HOME\*(C'\fR environment variable
to the homedir of the target user (root by default) as specified
in \fIpasswd\fR\|(5).  By default, \fBsudo\fR does not modify \f(CW\*(C`HOME\*(C'\fR.
.Ip "\-P" 4
.IX Item "-P"
The \fB\-P\fR (\fIpreserve group vector\fR) option causes \fBsudo\fR to preserve
the user's group vector unaltered.  By default, \fBsudo\fR will initialize
the group vector to the list of groups the target user is in.
The real and effective group IDs, however, are still set to match
the target user.
.Ip "\-S" 4
.IX Item "-S"
The \fB\-S\fR (\fIstdin\fR) option causes \fBsudo\fR to read the password from
standard input instead of the terminal device.
.Ip "\-\-" 4
The \fB\--\fR flag indicates that \fBsudo\fR should stop processing command
line arguments.  It is most useful in conjunction with the \fB\-s\fR flag.
.SH "RETURN VALUES"
.IX Header "RETURN VALUES"
Upon successful execution of a program, the return value from \fBsudo\fR
will simply be the return value of the program that was executed.
.PP
Otherwise, \fBsudo\fR quits with an exit value of 1 if there is a
configuration/permission problem or if \fBsudo\fR cannot execute the
given command.  In the latter case the error string is printed to
stderr.  If \fBsudo\fR cannot \fIstat\fR\|(2) one or more entries in the user's
\&\f(CW\*(C`PATH\*(C'\fR an error is printed on stderr.  (If the directory does not
exist or if it is not really a directory, the entry is ignored and
no error is printed.)  This should not happen under normal
circumstances.  The most common reason for \fIstat\fR\|(2) to return
\&\*(L"permission denied\*(R" is if you are running an automounter and one
of the directories in your \f(CW\*(C`PATH\*(C'\fR is on a machine that is currently
unreachable.
.SH "SECURITY NOTES"
.IX Header "SECURITY NOTES"
\&\fBsudo\fR tries to be safe when executing external commands.  Variables
that control how dynamic loading and binding is done can be used
to subvert the program that \fBsudo\fR runs.  To combat this the
\&\f(CW\*(C`LD_*\*(C'\fR, \f(CW\*(C`_RLD_*\*(C'\fR, \f(CW\*(C`SHLIB_PATH\*(C'\fR (\s-1HP-UX\s0 only), and \f(CW\*(C`LIBPATH\*(C'\fR (\s-1AIX\s0
only) environment variables are removed from the environment passed
on to all commands executed.  \fBsudo\fR will also remove the \f(CW\*(C`IFS\*(C'\fR,
\&\f(CW\*(C`ENV\*(C'\fR, \f(CW\*(C`BASH_ENV\*(C'\fR, \f(CW\*(C`KRB_CONF\*(C'\fR, \f(CW\*(C`KRBCONFDIR\*(C'\fR, \f(CW\*(C`KRBTKFILE\*(C'\fR,
\&\f(CW\*(C`KRB5_CONFIG\*(C'\fR, \f(CW\*(C`LOCALDOMAIN\*(C'\fR, \f(CW\*(C`RES_OPTIONS\*(C'\fR, \f(CW\*(C`HOSTALIASES\*(C'\fR,
\&\f(CW\*(C`NLSPATH\*(C'\fR, \f(CW\*(C`PATH_LOCALE\*(C'\fR, \f(CW\*(C`TERMINFO\*(C'\fR, \f(CW\*(C`TERMINFO_DIRS\*(C'\fR and
\&\f(CW\*(C`TERMPATH\*(C'\fR variables as they too can pose a threat.  If the
\&\f(CW\*(C`TERMCAP\*(C'\fR variable is set and is a pathname, it too is ignored.
Additionally, if the \f(CW\*(C`LC_*\*(C'\fR or \f(CW\*(C`LANGUAGE\*(C'\fR variables contain the
\&\f(CW\*(C`/\*(C'\fR or \f(CW\*(C`%\*(C'\fR characters, they are ignored.  If \fBsudo\fR has been
compiled with SecurID support, the \f(CW\*(C`VAR_ACE\*(C'\fR, \f(CW\*(C`USR_ACE\*(C'\fR and
\&\f(CW\*(C`DLC_ACE\*(C'\fR variables are cleared as well.  The list of environment
variables that \fBsudo\fR clears is contained in the output of
\&\f(CW\*(C`sudo \-V\*(C'\fR when run as root.
.PP
To prevent command spoofing, \fBsudo\fR checks \*(L".\*(R" and "" (both denoting
current directory) last when searching for a command in the user's
\&\s-1PATH\s0 (if one or both are in the \s-1PATH\s0).  Note, however, that the
actual \f(CW\*(C`PATH\*(C'\fR environment variable is \fInot\fR modified and is passed
unchanged to the program that \fBsudo\fR executes.
.PP
For security reasons, if your \s-1OS\s0 supports shared libraries and does
not disable user-defined library search paths for setuid programs
(most do), you should either use a linker option that disables this
behavior or link \fBsudo\fR statically.
.PP
\&\fBsudo\fR will check the ownership of its timestamp directory
(\fI/var/run/sudo\fR by default) and ignore the directory's contents if
it is not owned by root and only writable by root.  On systems that
allow non-root users to give away files via \fIchown\fR\|(2), if the timestamp
directory is located in a directory writable by anyone (e.g.: \fI/tmp\fR),
it is possible for a user to create the timestamp directory before
\&\fBsudo\fR is run.  However, because \fBsudo\fR checks the ownership and
mode of the directory and its contents, the only damage that can
be done is to \*(L"hide\*(R" files by putting them in the timestamp dir.
This is unlikely to happen since once the timestamp dir is owned
by root and inaccessible by any other user the user placing files
there would be unable to get them back out.  To get around this
issue you can use a directory that is not world-writable for the
timestamps (\fI/var/adm/sudo\fR for instance) or create \fI/var/run/sudo\fR
with the appropriate owner (root) and permissions (0700) in the
system startup files.
.PP
\&\fBsudo\fR will not honor timestamps set far in the future.
Timestamps with a date greater than current_time + 2 * \f(CW\*(C`TIMEOUT\*(C'\fR
will be ignored and sudo will log and complain.  This is done to
keep a user from creating his/her own timestamp with a bogus
date on systems that allow users to give away files.
.PP
Please note that \fBsudo\fR will only log the command it explicitly
runs.  If a user runs a command such as \f(CW\*(C`sudo su\*(C'\fR or \f(CW\*(C`sudo sh\*(C'\fR,
subsequent commands run from that shell will \fInot\fR be logged, nor
will \fBsudo\fR's access control affect them.  The same is true for
commands that offer shell escapes (including most editors).  Because
of this, care must be taken when giving users access to commands
via \fBsudo\fR to verify that the command does not inadvertantly give
the user an effective root shell.
.SH "EXAMPLES"
.IX Header "EXAMPLES"
Note: the following examples assume suitable \fIsudoers\fR\|(5) entries.
.PP
To get a file listing of an unreadable directory:
.PP
.Vb 1
\& % sudo ls /usr/local/protected
.Ve
To list the home directory of user yazza on a machine where the
filesystem holding ~yazza is not exported as root:
.PP
.Vb 1
\& % sudo -u yazza ls ~yazza
.Ve
To edit the \fIindex.html\fR file as user www:
.PP
.Vb 1
\& % sudo -u www vi ~www/htdocs/index.html
.Ve
To shutdown a machine:
.PP
.Vb 1
\& % sudo shutdown -r +15 "quick reboot"
.Ve
To make a usage listing of the directories in the /home
partition.  Note that this runs the commands in a sub-shell
to make the \f(CW\*(C`cd\*(C'\fR and file redirection work.
.PP
.Vb 1
\& % sudo sh -c "cd /home ; du -s * | sort -rn > USAGE"
.Ve
.SH "ENVIRONMENT"
.IX Header "ENVIRONMENT"
\&\fBsudo\fR utilizes the following environment variables:
.PP
.Vb 13
\& PATH                   Set to a sane value if SECURE_PATH is set
\& SHELL                  Used to determine shell to run with -s option
\& USER                   Set to the target user (root unless the -u option
\&                        is specified)
\& HOME                   In -s or -H mode (or if sudo was configured with
\&                        the --enable-shell-sets-home option), set to
\&                        homedir of the target user.
\& SUDO_PROMPT            Used as the default password prompt
\& SUDO_COMMAND           Set to the command run by sudo
\& SUDO_USER              Set to the login of the user who invoked sudo
\& SUDO_UID               Set to the uid of the user who invoked sudo
\& SUDO_GID               Set to the gid of the user who invoked sudo
\& SUDO_PS1               If set, PS1 will be set to its value
.Ve
.SH "FILES"
.IX Header "FILES"
.Vb 2
\& /etc/sudoers           List of who can run what
\& /var/run/sudo              Directory containing timestamps
.Ve
.SH "AUTHORS"
.IX Header "AUTHORS"
Many people have worked on \fBsudo\fR over the years; this
version consists of code written primarily by:
.PP
.Vb 2
\&        Todd Miller
\&        Chris Jepeway
.Ve
See the \s-1HISTORY\s0 file in the \fBsudo\fR distribution or visit
http://www.sudo.ws/sudo/history.html for a short history
of \fBsudo\fR.
.SH "BUGS"
.IX Header "BUGS"
If you feel you have found a bug in sudo, please submit a bug report
at http://www.sudo.ws/sudo/bugs/
.SH "DISCLAIMER"
.IX Header "DISCLAIMER"
\&\fBSudo\fR is provided ``\s-1AS\s0 \s-1IS\s0'' and any express or implied warranties,
including, but not limited to, the implied warranties of merchantability
and fitness for a particular purpose are disclaimed.
See the \s-1LICENSE\s0 file distributed with \fBsudo\fR for complete details.
.SH "CAVEATS"
.IX Header "CAVEATS"
There is no easy way to prevent a user from gaining a root shell if
that user has access to commands allowing shell escapes.
.PP
If users have sudo \f(CW\*(C`ALL\*(C'\fR there is nothing to prevent them from creating
their own program that gives them a root shell regardless of any '!'
elements in the user specification.
.PP
Running shell scripts via \fBsudo\fR can expose the same kernel bugs
that make setuid shell scripts unsafe on some operating systems
(if your \s-1OS\s0 supports the /dev/fd/ directory, setuid shell scripts
are generally safe).
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fIstat\fR\|(2), \fIlogin_cap\fR\|(3), \fIsudoers\fR\|(5), \fIpasswd\fR\|(5), \fIvisudo\fR\|(8), \fIgrep\fR\|(1), \fIsu\fR\|(1).
