.\" Automatically generated by Pod::Man version 1.15
.\" Thu Apr 25 09:34:54 2002
.\"
.\" Standard preamble:
.\" ======================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Ip \" List item
.br
.ie \\n(.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R

.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used
.\" to do unbreakable dashes and therefore won't be available.  \*(C` and
.\" \*(C' expand to `' in nroff, nothing in troff, for use with C<>
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` 
.    ds C' 
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr
.\" for titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and
.\" index entries marked with X<> in POD.  Of course, you'll have to process
.\" the output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it
.\" makes way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.bd B 3
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ======================================================================
.\"
.IX Title "sudoers 5"
.TH sudoers 5 "1.6.6" "April 25, 2002" "MAINTENANCE COMMANDS"
.UC
.SH "NAME"
sudoers \- list of which users may execute what
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
The \fIsudoers\fR file is composed of two types of entries:
aliases (basically variables) and user specifications
(which specify who may run what).  The grammar of \fIsudoers\fR
will be described below in Extended Backus-Naur Form (\s-1EBNF\s0).
Don't despair if you don't know what \s-1EBNF\s0 is; it is fairly
simple, and the definitions below are annotated.
.Sh "Quick guide to \s-1EBNF\s0"
.IX Subsection "Quick guide to EBNF"
\&\s-1EBNF\s0 is a concise and exact way of describing the grammar of a language.
Each \s-1EBNF\s0 definition is made up of \fIproduction rules\fR.  E.g.,
.PP
.Vb 1
\& symbol ::= definition | alternate1 | alternate2 ...
.Ve
Each \fIproduction rule\fR references others and thus makes up a
grammar for the language.  \s-1EBNF\s0 also contains the following
operators, which many readers will recognize from regular
expressions.  Do not, however, confuse them with \*(L"wildcard\*(R"
characters, which have different meanings.
.Ip "\f(CW\*(C`?\*(C'\fR" 8
.IX Item "?"
Means that the preceding symbol (or group of symbols) is optional.
That is, it may appear once or not at all.
.Ip "\f(CW\*(C`*\*(C'\fR" 8
.IX Item "*"
Means that the preceding symbol (or group of symbols) may appear
zero or more times.
.Ip "\f(CW\*(C`+\*(C'\fR" 8
.IX Item "+"
Means that the preceding symbol (or group of symbols) may appear
one or more times.
.PP
Parentheses may be used to group symbols together.  For clarity,
we will use single quotes ('') to designate what is a verbatim character
string (as opposed to a symbol name).
.Sh "Aliases"
.IX Subsection "Aliases"
There are four kinds of aliases: \f(CW\*(C`User_Alias\*(C'\fR, \f(CW\*(C`Runas_Alias\*(C'\fR,
\&\f(CW\*(C`Host_Alias\*(C'\fR and \f(CW\*(C`Cmnd_Alias\*(C'\fR.
.PP
.Vb 4
\& Alias ::= 'User_Alias'  User_Alias (':' User_Alias)* |
\&           'Runas_Alias' Runas_Alias (':' Runas_Alias)* |
\&           'Host_Alias'  Host_Alias (':' Host_Alias)* |
\&           'Cmnd_Alias'  Cmnd_Alias (':' Cmnd_Alias)*
.Ve
.Vb 1
\& User_Alias ::= NAME '=' User_List
.Ve
.Vb 1
\& Runas_Alias ::= NAME '=' Runas_List
.Ve
.Vb 1
\& Host_Alias ::= NAME '=' Host_List
.Ve
.Vb 1
\& Cmnd_Alias ::= NAME '=' Cmnd_List
.Ve
.Vb 1
\& NAME ::= [A-Z]([A-Z][0-9]_)*
.Ve
Each \fIalias\fR definition is of the form
.PP
.Vb 1
\& Alias_Type NAME = item1, item2, ...
.Ve
where \fIAlias_Type\fR is one of \f(CW\*(C`User_Alias\*(C'\fR, \f(CW\*(C`Runas_Alias\*(C'\fR, \f(CW\*(C`Host_Alias\*(C'\fR,
or \f(CW\*(C`Cmnd_Alias\*(C'\fR.  A \f(CW\*(C`NAME\*(C'\fR is a string of uppercase letters, numbers,
and the underscore characters ('_').  A \f(CW\*(C`NAME\*(C'\fR \fBmust\fR start with an
uppercase letter.  It is possible to put several alias definitions
of the same type on a single line, joined by a colon (':').  E.g.,
.PP
.Vb 1
\& Alias_Type NAME = item1, item2, item3 : NAME = item4, item5
.Ve
The definitions of what constitutes a valid \fIalias\fR member follow.
.PP
.Vb 2
\& User_List ::= User |
\&               User ',' User_List
.Ve
.Vb 4
\& User ::= '!'* username |
\&          '!'* '%'group |
\&          '!'* '+'netgroup |
\&          '!'* User_Alias
.Ve
A \f(CW\*(C`User_List\*(C'\fR is made up of one or more usernames, uids
(prefixed with '#'), System groups (prefixed with '%'),
netgroups (prefixed with '+') and other aliases.  Each list
item may be prefixed with one or more '!' operators.  An odd number
of '!' operators negate the value of the item; an even number
just cancel each other out.
.PP
.Vb 2
\& Runas_List ::= Runas_User |
\&                Runas_User ',' Runas_List
.Ve
.Vb 5
\& Runas_User ::= '!'* username |
\&                '!'* '#'uid |
\&                '!'* '%'group |
\&                '!'* +netgroup |
\&                '!'* Runas_Alias
.Ve
A \f(CW\*(C`Runas_List\*(C'\fR is similar to a \f(CW\*(C`User_List\*(C'\fR except that it can
also contain uids (prefixed with '#') and instead of \f(CW\*(C`User_Alias\*(C'\fRes
it can contain \f(CW\*(C`Runas_Alias\*(C'\fRes.
.PP
.Vb 2
\& Host_List ::= Host |
\&               Host ',' Host_List
.Ve
.Vb 5
\& Host ::= '!'* hostname |
\&          '!'* ip_addr |
\&          '!'* network(/netmask)? |
\&          '!'* '+'netgroup |
\&          '!'* Host_Alias
.Ve
A \f(CW\*(C`Host_List\*(C'\fR is made up of one or more hostnames, \s-1IP\s0 addresses,
network numbers, netgroups (prefixed with '+') and other aliases.
Again, the value of an item may be negated with the '!' operator.
If you do not specify a netmask with a network number, the netmask
of the host's ethernet \fIinterface\fR\|(s) will be used when matching.
The netmask may be specified either in dotted quad notation (e.g.
255.255.255.0) or \s-1CIDR\s0 notation (number of bits, e.g. 24).  A hostname
may include shell-style wildcards (see `Wildcards' section below),
but unless the \f(CW\*(C`hostname\*(C'\fR command on your machine returns the fully
qualified hostname, you'll need to use the \fIfqdn\fR option for wildcards
to be useful.
.PP
.Vb 2
\& Cmnd_List ::= Cmnd |
\&               Cmnd ',' Cmnd_List
.Ve
.Vb 3
\& commandname ::= filename |
\&                 filename args |
\&                 filename '""'
.Ve
.Vb 3
\& Cmnd ::= '!'* commandname |
\&          '!'* directory |
\&          '!'* Cmnd_Alias
.Ve
A \f(CW\*(C`Cmnd_List\*(C'\fR is a list of one or more commandnames, directories, and other
aliases.  A commandname is a fully qualified filename which may include
shell-style wildcards (see `Wildcards' section below).  A simple
filename allows the user to run the command with any arguments he/she
wishes.  However, you may also specify command line arguments (including
wildcards).  Alternately, you can specify \f(CW\*(C`""\*(C'\fR to indicate that the command
may only be run \fBwithout\fR command line arguments.  A directory is a
fully qualified pathname ending in a '/'.  When you specify a directory
in a \f(CW\*(C`Cmnd_List\*(C'\fR, the user will be able to run any file within that directory
(but not in any subdirectories therein).
.PP
If a \f(CW\*(C`Cmnd\*(C'\fR has associated command line arguments, then the arguments
in the \f(CW\*(C`Cmnd\*(C'\fR must match exactly those given by the user on the command line
(or match the wildcards if there are any).  Note that the following
characters must be escaped with a '\e' if they are used in command
arguments: ',', ':', '=', '\e'.
.Sh "Defaults"
.IX Subsection "Defaults"
Certain configuration options may be changed from their default
values at runtime via one or more \f(CW\*(C`Default_Entry\*(C'\fR lines.  These
may affect all users on any host, all users on a specific host,
or just a specific user.  When multiple entries match, they are
applied in order.  Where there are conflicting values, the last
value on a matching line takes effect.
.PP
.Vb 3
\& Default_Type ::= 'Defaults' ||
\&                  'Defaults' ':' User ||
\&                  'Defaults' '@' Host
.Ve
.Vb 1
\& Default_Entry ::= Default_Type Parameter_List
.Ve
.Vb 4
\& Parameter ::= Parameter '=' Value ||
\&               Parameter '+=' Value ||
\&               Parameter '-=' Value ||
\&               '!'* Parameter ||
.Ve
Parameters may be \fBflags\fR, \fBinteger\fR values, \fBstrings\fR, or \fBlists\fR.
Flags are implicitly boolean and can be turned off via the '!'
operator.  Some integer, string and list parameters may also be
used in a boolean context to disable them.  Values may be enclosed
in double quotes (\f(CW\*(C`"\*(C'\fR) when they contain multiple words.  Special
characters may be escaped with a backslash (\f(CW\*(C`\e\*(C'\fR).
.PP
Lists have two additional assignment operators, \f(CW\*(C`+=\*(C'\fR and \f(CW\*(C`\-=\*(C'\fR.
These operators are used to add to and delete from a list respectively.
It is not an error to use the \f(CW\*(C`\-=\*(C'\fR operator to remove an element
that does not exist in a list.
.PP
Note that since the \fIsudoers\fR file is parsed in order the best place
to put the Defaults section is after the Host, User, and Cmnd aliases
but before the user specifications.
.PP
\&\fBFlags\fR:
.Ip "long_otp_prompt" 12
.IX Item "long_otp_prompt"
When validating with a One Time Password scheme (\fBS/Key\fR or \fB\s-1OPIE\s0\fR),
a two-line prompt is used to make it easier to cut and paste the
challenge to a local window.  It's not as pretty as the default but
some people find it more convenient.  This flag is \fIoff\fR
by default.
.Ip "ignore_dot" 12
.IX Item "ignore_dot"
If set, \fBsudo\fR will ignore '.' or '' (current dir) in the \f(CW\*(C`PATH\*(C'\fR
environment variable; the \f(CW\*(C`PATH\*(C'\fR itself is not modified.  This
flag is \fIoff\fR by default.
.Ip "mail_always" 12
.IX Item "mail_always"
Send mail to the \fImailto\fR user every time a users runs \fBsudo\fR.
This flag is \fIoff\fR by default.
.Ip "mail_badpass" 12
.IX Item "mail_badpass"
Send mail to the \fImailto\fR user if the user running sudo does not
enter the correct password.  This flag is \fIoff\fR by default.
.Ip "mail_no_user" 12
.IX Item "mail_no_user"
If set, mail will be sent to the \fImailto\fR user if the invoking
user is not in the \fIsudoers\fR file.  This flag is \fIon\fR
by default.
.Ip "mail_no_host" 12
.IX Item "mail_no_host"
If set, mail will be sent to the \fImailto\fR user if the invoking
user exists in the \fIsudoers\fR file, but is not allowed to run
commands on the current host.  This flag is \fIoff\fR by default.
.Ip "mail_no_perms" 12
.IX Item "mail_no_perms"
If set, mail will be sent to the \fImailto\fR user if the invoking
user allowed to use \fBsudo\fR but the command they are trying is not
listed in their \fIsudoers\fR file entry.  This flag is \fIoff\fR
by default.
.Ip "tty_tickets" 12
.IX Item "tty_tickets"
If set, users must authenticate on a per-tty basis.  Normally,
\&\fBsudo\fR uses a directory in the ticket dir with the same name as
the user running it.  With this flag enabled, \fBsudo\fR will use a
file named for the tty the user is logged in on in that directory.
This flag is \fIoff\fR by default.
.Ip "lecture" 12
.IX Item "lecture"
If set, a user will receive a short lecture the first time he/she
runs \fBsudo\fR.  This flag is \fIon\fR by default.
.Ip "authenticate" 12
.IX Item "authenticate"
If set, users must authenticate themselves via a password (or other
means of authentication) before they may run commands.  This default
may be overridden via the \f(CW\*(C`PASSWD\*(C'\fR and \f(CW\*(C`NOPASSWD\*(C'\fR tags.
This flag is \fIon\fR by default.
.Ip "root_sudo" 12
.IX Item "root_sudo"
If set, root is allowed to run \fBsudo\fR too.  Disabling this prevents users
from \*(L"chaining\*(R" \fBsudo\fR commands to get a root shell by doing something
like \f(CW\*(C`"sudo sudo /bin/sh"\*(C'\fR.
This flag is \fIon\fR by default.
.Ip "log_host" 12
.IX Item "log_host"
If set, the hostname will be logged in the (non-syslog) \fBsudo\fR log file.
This flag is \fIoff\fR by default.
.Ip "log_year" 12
.IX Item "log_year"
If set, the four-digit year will be logged in the (non-syslog) \fBsudo\fR log file.
This flag is \fIoff\fR by default.
.Ip "shell_noargs" 12
.IX Item "shell_noargs"
If set and \fBsudo\fR is invoked with no arguments it acts as if the
\&\fB\-s\fR flag had been given.  That is, it runs a shell as root (the
shell is determined by the \f(CW\*(C`SHELL\*(C'\fR environment variable if it is
set, falling back on the shell listed in the invoking user's
/etc/passwd entry if not).  This flag is \fIoff\fR by default.
.Ip "set_home" 12
.IX Item "set_home"
If set and \fBsudo\fR is invoked with the \fB\-s\fR flag the \f(CW\*(C`HOME\*(C'\fR
environment variable will be set to the home directory of the target
user (which is root unless the \fB\-u\fR option is used).  This effectively
makes the \fB\-s\fR flag imply \fB\-H\fR.  This flag is \fIoff\fR by default.
.Ip "always_set_home" 12
.IX Item "always_set_home"
If set, \fBsudo\fR will set the \f(CW\*(C`HOME\*(C'\fR environment variable to the home
directory of the target user (which is root unless the \fB\-u\fR option is used).
This effectively means that the \fB\-H\fR flag is always implied.
This flag is \fIoff\fR by default.
.Ip "path_info" 12
.IX Item "path_info"
Normally, \fBsudo\fR will tell the user when a command could not be
found in their \f(CW\*(C`PATH\*(C'\fR environment variable.  Some sites may wish
to disable this as it could be used to gather information on the
location of executables that the normal user does not have access
to.  The disadvantage is that if the executable is simply not in
the user's \f(CW\*(C`PATH\*(C'\fR, \fBsudo\fR will tell the user that they are not
allowed to run it, which can be confusing.  This flag is \fIoff\fR by
default.
.Ip "preserve_groups" 12
.IX Item "preserve_groups"
By default \fBsudo\fR will initialize the group vector to the list of
groups the target user is in.  When \fIpreserve_groups\fR is set, the
user's existing group vector is left unaltered.  The real and
effective group IDs, however, are still set to match the target
user.  This flag is \fIoff\fR by default.
.Ip "fqdn" 12
.IX Item "fqdn"
Set this flag if you want to put fully qualified hostnames in the
\&\fIsudoers\fR file.  I.e.: instead of myhost you would use myhost.mydomain.edu.
You may still use the short form if you wish (and even mix the two).
Beware that turning on \fIfqdn\fR requires \fBsudo\fR to make \s-1DNS\s0 lookups
which may make \fBsudo\fR unusable if \s-1DNS\s0 stops working (for example
if the machine is not plugged into the network).  Also note that
you must use the host's official name as \s-1DNS\s0 knows it.  That is,
you may not use a host alias (\f(CW\*(C`CNAME\*(C'\fR entry) due to performance
issues and the fact that there is no way to get all aliases from
\&\s-1DNS\s0.  If your machine's hostname (as returned by the \f(CW\*(C`hostname\*(C'\fR
command) is already fully qualified you shouldn't need to set
\&\fIfqdn\fR.  This flag is \fIoff\fR by default.
.Ip "insults" 12
.IX Item "insults"
If set, \fBsudo\fR will insult users when they enter an incorrect
password.  This flag is \fIoff\fR by default.
.Ip "requiretty" 12
.IX Item "requiretty"
If set, \fBsudo\fR will only run when the user is logged in to a real
tty.  This will disallow things like \f(CW\*(C`"rsh somehost sudo ls"\*(C'\fR since
\&\fIrsh\fR\|(1) does not allocate a tty.  Because it is not possible to turn
of echo when there is no tty present, some sites may with to set
this flag to prevent a user from entering a visible password.  This
flag is \fIoff\fR by default.
.Ip "env_editor" 12
.IX Item "env_editor"
If set, \fBvisudo\fR will use the value of the \s-1EDITOR\s0 or \s-1VISUAL\s0
environment variables before falling back on the default editor list.
Note that this may create a security hole as it allows the user to
run any arbitrary command as root without logging.  A safer alternative
is to place a colon-separated list of editors in the \f(CW\*(C`editor\*(C'\fR
variable.  \fBvisudo\fR will then only use the \s-1EDITOR\s0 or \s-1VISUAL\s0 if
they match a value specified in \f(CW\*(C`editor\*(C'\fR.  This flag is \f(CW\*(C`off\*(C'\fR by
default.
.Ip "rootpw" 12
.IX Item "rootpw"
If set, \fBsudo\fR will prompt for the root password instead of the password
of the invoking user.  This flag is \fIoff\fR by default.
.Ip "runaspw" 12
.IX Item "runaspw"
If set, \fBsudo\fR will prompt for the password of the user defined by the
\&\fIrunas_default\fR option (defaults to \f(CW\*(C`root\*(C'\fR) instead of the password
of the invoking user.  This flag is \fIoff\fR by default.
.Ip "targetpw" 12
.IX Item "targetpw"
If set, \fBsudo\fR will prompt for the password of the user specified by
the \fB\-u\fR flag (defaults to \f(CW\*(C`root\*(C'\fR) instead of the password of the
invoking user.  This flag is \fIoff\fR by default.
.Ip "set_logname" 12
.IX Item "set_logname"
Normally, \fBsudo\fR will set the \f(CW\*(C`LOGNAME\*(C'\fR and \f(CW\*(C`USER\*(C'\fR environment variables
to the name of the target user (usually root unless the \fB\-u\fR flag is given).
However, since some programs (including the \s-1RCS\s0 revision control system)
use \f(CW\*(C`LOGNAME\*(C'\fR to determine the real identity of the user, it may be desirable
to change this behavior.  This can be done by negating the set_logname option.
.Ip "stay_setuid" 12
.IX Item "stay_setuid"
Normally, when \fBsudo\fR executes a command the real and effective
UIDs are set to the target user (root by default).  This option
changes that behavior such that the real \s-1UID\s0 is left as the invoking
user's \s-1UID\s0.  In other words, this makes \fBsudo\fR act as a setuid
wrapper.  This can be useful on systems that disable some potentially
dangerous functionality when a program is run setuid.  Note, however,
that this means that sudo will run with the real uid of the invoking
user which may allow that user to kill \fBsudo\fR before it can log a
failure, depending on how your \s-1OS\s0 defines the interaction between
signals and setuid processes.
.Ip "env_reset" 12
.IX Item "env_reset"
If set, \fBsudo\fR will reset the environment to only contain the
following variables: \f(CW\*(C`HOME\*(C'\fR, \f(CW\*(C`LOGNAME\*(C'\fR, \f(CW\*(C`PATH\*(C'\fR, \f(CW\*(C`SHELL\*(C'\fR, \f(CW\*(C`TERM\*(C'\fR,
and \f(CW\*(C`USER\*(C'\fR (in addition to the \f(CW\*(C`SUDO_*\*(C'\fR variables).
Of these, only \f(CW\*(C`TERM\*(C'\fR is copied unaltered from the old environment.
The other variables are set to default values (possibly modified
by the value of the \fIset_logname\fR option).  If \fBsudo\fR was compiled
with the \f(CW\*(C`SECURE_PATH\*(C'\fR option, its value will be used for the \f(CW\*(C`PATH\*(C'\fR
environment variable.
Other variables may be preserved with the \fIenv_keep\fR option.
.Ip "use_loginclass" 12
.IX Item "use_loginclass"
If set, \fBsudo\fR will apply the defaults specified for the target user's
login class if one exists.  Only available if \fBsudo\fR is configured with
the \-\-with-logincap option.  This flag is \fIoff\fR by default.
.PP
\&\fBIntegers\fR:
.Ip "passwd_tries" 12
.IX Item "passwd_tries"
The number of tries a user gets to enter his/her password before
\&\fBsudo\fR logs the failure and exits.  The default is \f(CW\*(C`3\*(C'\fR.
.PP
\&\fBIntegers that can be used in a boolean context\fR:
.Ip "loglinelen" 12
.IX Item "loglinelen"
Number of characters per line for the file log.  This value is used
to decide when to wrap lines for nicer log files.  This has no
effect on the syslog log file, only the file log.  The default is
\&\f(CW\*(C`80\*(C'\fR (use 0 or negate the option to disable word wrap).
.Ip "timestamp_timeout" 12
.IX Item "timestamp_timeout"
Number of minutes that can elapse before \fBsudo\fR will ask for a
passwd again.  The default is \f(CW\*(C`5\*(C'\fR.  Set this to \f(CW\*(C`0\*(C'\fR to always
prompt for a password.
If set to a value less than \f(CW\*(C`0\*(C'\fR the user's timestamp will never
expire.  This can be used to allow users to create or delete their
own timestamps via \f(CW\*(C`sudo \-v\*(C'\fR and \f(CW\*(C`sudo \-k\*(C'\fR respectively.
.Ip "passwd_timeout" 12
.IX Item "passwd_timeout"
Number of minutes before the \fBsudo\fR password prompt times out.
The default is \f(CW\*(C`5\*(C'\fR, set this to \f(CW\*(C`0\*(C'\fR for no password timeout.
.Ip "umask" 12
.IX Item "umask"
Umask to use when running the command.  Negate this option or set
it to 0777 to preserve the user's umask.  The default is \f(CW\*(C`0022\*(C'\fR.
.PP
\&\fBStrings\fR:
.Ip "mailsub" 12
.IX Item "mailsub"
Subject of the mail sent to the \fImailto\fR user. The escape \f(CW\*(C`%h\*(C'\fR
will expand to the hostname of the machine.
Default is \f(CW\*(C`*** SECURITY information for %h ***\*(C'\fR.
.Ip "badpass_message" 12
.IX Item "badpass_message"
Message that is displayed if a user enters an incorrect password.
The default is \f(CW\*(C`Sorry, try again.\*(C'\fR unless insults are enabled.
.Ip "timestampdir" 12
.IX Item "timestampdir"
The directory in which \fBsudo\fR stores its timestamp files.
The default is \fI/var/run/sudo\fR.
.Ip "passprompt" 12
.IX Item "passprompt"
The default prompt to use when asking for a password; can be overridden
via the \fB\-p\fR option or the \f(CW\*(C`SUDO_PROMPT\*(C'\fR environment variable. Supports
two escapes: \*(L"%u\*(R" expands to the user's login name and \*(L"%h\*(R" expands
to the local hostname.  The default value is \f(CW\*(C`Password:\*(C'\fR.
.Ip "runas_default" 12
.IX Item "runas_default"
The default user to run commands as if the \fB\-u\fR flag is not specified
on the command line.  This defaults to \f(CW\*(C`root\*(C'\fR.
.Ip "syslog_goodpri" 12
.IX Item "syslog_goodpri"
Syslog priority to use when user authenticates successfully.
Defaults to \f(CW\*(C`notice\*(C'\fR.
.Ip "syslog_badpri" 12
.IX Item "syslog_badpri"
Syslog priority to use when user authenticates unsuccessfully.
Defaults to \f(CW\*(C`alert\*(C'\fR.
.Ip "editor" 12
.IX Item "editor"
A colon (':') separated list of editors allowed to be used with
\&\fBvisudo\fR.  \fBvisudo\fR will choose the editor that matches the user's
\&\s-1USER\s0 environment variable if possible, or the first editor in the
list that exists and is executable.  The default is the path to vi
on your system.
.PP
\&\fBStrings that can be used in a boolean context\fR:
.Ip "logfile" 12
.IX Item "logfile"
Path to the \fBsudo\fR log file (not the syslog log file).  Setting a path
turns on logging to a file; negating this option turns it off.
.Ip "syslog" 12
.IX Item "syslog"
Syslog facility if syslog is being used for logging (negate to
disable syslog logging).  Defaults to \f(CW\*(C`local2\*(C'\fR.
.Ip "mailerpath" 12
.IX Item "mailerpath"
Path to mail program used to send warning mail.
Defaults to the path to sendmail found at configure time.
.Ip "mailerflags" 12
.IX Item "mailerflags"
Flags to use when invoking mailer. Defaults to \fB\-t\fR.
.Ip "mailto" 12
.IX Item "mailto"
Address to send warning and error mail to.  The address should
be enclosed in double quotes (\f(CW\*(C`"\*(C'\fR) to protect against sudo
interpreting the \f(CW\*(C`@\*(C'\fR sign.  Defaults to \f(CW\*(C`root\*(C'\fR.
.Ip "exempt_group" 12
.IX Item "exempt_group"
Users in this group are exempt from password and \s-1PATH\s0 requirements.
This is not set by default.
.Ip "verifypw" 12
.IX Item "verifypw"
This option controls when a password will be required when a user runs
\&\fBsudo\fR with the \fB\-v\fR flag.  It has the following possible values:
.RS 12
.Ip "all" 8
.IX Item "all"
All the user's \fIsudoers\fR entries for the current host must have
the \f(CW\*(C`NOPASSWD\*(C'\fR flag set to avoid entering a password.
.Ip "any" 8
.IX Item "any"
At least one of the user's \fIsudoers\fR entries for the current host
must have the \f(CW\*(C`NOPASSWD\*(C'\fR flag set to avoid entering a password.
.Ip "never" 8
.IX Item "never"
The user need never enter a password to use the \fB\-v\fR flag.
.Ip "always" 8
.IX Item "always"
The user must always enter a password to use the \fB\-v\fR flag.
.RE
.RS 12
.Sp
The default value is `all'.
.RE
.Ip "listpw" 12
.IX Item "listpw"
This option controls when a password will be required when a
user runs \fBsudo\fR with the \fB\-l\fR.  It has the following possible values:
.RS 12
.Ip "all" 8
.IX Item "all"
All the user's \fIsudoers\fR entries for the current host must have
the \f(CW\*(C`NOPASSWD\*(C'\fR flag set to avoid entering a password.
.Ip "any" 8
.IX Item "any"
At least one of the user's \fIsudoers\fR entries for the current host
must have the \f(CW\*(C`NOPASSWD\*(C'\fR flag set to avoid entering a password.
.Ip "never" 8
.IX Item "never"
The user need never enter a password to use the \fB\-l\fR flag.
.Ip "always" 8
.IX Item "always"
The user must always enter a password to use the \fB\-l\fR flag.
.RE
.RS 12
.Sp
The default value is `any'.
.RE
.PP
\&\fBLists that can be used in a boolean context\fR:
.Ip "env_check" 12
.IX Item "env_check"
Environment variables to be removed from the user's environment if
the variable's value contains \f(CW\*(C`%\*(C'\fR or \f(CW\*(C`/\*(C'\fR characters.  This can
be used to guard against printf-style format vulnerabilties in
poorly-written programs.  The argument may be a double-quoted,
space-separated list or a single value without double-quotes.  The
list can be replaced, added to, deleted from, or disabled by using
the \f(CW\*(C`=\*(C'\fR, \f(CW\*(C`+=\*(C'\fR, \f(CW\*(C`\-=\*(C'\fR, and \f(CW\*(C`!\*(C'\fR operators respectively.  The default
list of environment variable to check is printed when \fBsudo\fR is
run by root with the \fI\-V\fR option.
.Ip "env_delete" 12
.IX Item "env_delete"
Environment variables to be removed from the user's environment.
The argument may be a double-quoted, space-separated list or a
single value without double-quotes.  The list can be replaced, added
to, deleted from, or disabled by using the \f(CW\*(C`=\*(C'\fR, \f(CW\*(C`+=\*(C'\fR, \f(CW\*(C`\-=\*(C'\fR, and
\&\f(CW\*(C`!\*(C'\fR operators respectively.  The default list of environment
variable to remove is printed when \fBsudo\fR is run by root with the
\&\fI\-V\fR option.
.Ip "env_keep" 12
.IX Item "env_keep"
Environment variables to be preserved in the user's environment
when the \fIenv_reset\fR option is in effect.  This allows fine-grained
control over the environment \fBsudo\fR\-spawned processes will receive.
The argument may be a double-quoted, space-separated list or a
single value without double-quotes.  The list can be replaced, added
to, deleted from, or disabled by using the \f(CW\*(C`=\*(C'\fR, \f(CW\*(C`+=\*(C'\fR, \f(CW\*(C`\-=\*(C'\fR, and
\&\f(CW\*(C`!\*(C'\fR operators respectively.  This list has no default members.
.PP
When logging via \fIsyslog\fR\|(3), \fBsudo\fR accepts the following values for the syslog
facility (the value of the \fBsyslog\fR Parameter): \fBauthpriv\fR (if your \s-1OS\s0
supports it), \fBauth\fR, \fBdaemon\fR, \fBuser\fR, \fBlocal0\fR, \fBlocal1\fR, \fBlocal2\fR,
\&\fBlocal3\fR, \fBlocal4\fR, \fBlocal5\fR, \fBlocal6\fR, and \fBlocal7\fR.  The following
syslog priorities are supported: \fBalert\fR, \fBcrit\fR, \fBdebug\fR, \fBemerg\fR,
\&\fBerr\fR, \fBinfo\fR, \fBnotice\fR, and \fBwarning\fR.
.Sh "User Specification"
.IX Subsection "User Specification"
.Vb 2
\& User_Spec ::= User_list Host_List '=' Cmnd_Spec_List \e
\&               (':' User_Spec)*
.Ve
.Vb 2
\& Cmnd_Spec_List ::= Cmnd_Spec |
\&                    Cmnd_Spec ',' Cmnd_Spec_List
.Ve
.Vb 1
\& Cmnd_Spec ::= Runas_Spec? ('NOPASSWD:' | 'PASSWD:')? Cmnd
.Ve
.Vb 1
\& Runas_Spec ::= '(' Runas_List ')'
.Ve
A \fBuser specification\fR determines which commands a user may run
(and as what user) on specified hosts.  By default, commands are
run as \fBroot\fR, but this can be changed on a per-command basis.
.PP
Let's break that down into its constituent parts:
.Sh "Runas_Spec"
.IX Subsection "Runas_Spec"
A \f(CW\*(C`Runas_Spec\*(C'\fR is simply a \f(CW\*(C`Runas_List\*(C'\fR (as defined above)
enclosed in a set of parentheses.  If you do not specify a
\&\f(CW\*(C`Runas_Spec\*(C'\fR in the user specification, a default \f(CW\*(C`Runas_Spec\*(C'\fR
of \fBroot\fR will be used.  A \f(CW\*(C`Runas_Spec\*(C'\fR sets the default for
commands that follow it.  What this means is that for the entry:
.PP
.Vb 1
\& dgb    boulder = (operator) /bin/ls, /bin/kill, /usr/bin/who
.Ve
The user \fBdgb\fR may run \fI/bin/ls\fR, \fI/bin/kill\fR, and
\&\fI/usr/bin/lprm\fR \*(-- but only as \fBoperator\fR.  E.g.,
.PP
.Vb 1
\&    sudo -u operator /bin/ls.
.Ve
It is also possible to override a \f(CW\*(C`Runas_Spec\*(C'\fR later on in an
entry.  If we modify the entry like so:
.PP
.Vb 1
\& dgb    boulder = (operator) /bin/ls, (root) /bin/kill, /usr/bin/lprm
.Ve
Then user \fBdgb\fR is now allowed to run \fI/bin/ls\fR as \fBoperator\fR,
but  \fI/bin/kill\fR and \fI/usr/bin/lprm\fR as \fBroot\fR.
.Sh "\s-1NOPASSWD\s0 and \s-1PASSWD\s0"
.IX Subsection "NOPASSWD and PASSWD"
By default, \fBsudo\fR requires that a user authenticate him or herself
before running a command.  This behavior can be modified via the
\&\f(CW\*(C`NOPASSWD\*(C'\fR tag.  Like a \f(CW\*(C`Runas_Spec\*(C'\fR, the \f(CW\*(C`NOPASSWD\*(C'\fR tag sets
a default for the commands that follow it in the \f(CW\*(C`Cmnd_Spec_List\*(C'\fR.
Conversely, the \f(CW\*(C`PASSWD\*(C'\fR tag can be used to reverse things.
For example:
.PP
.Vb 1
\& ray    rushmore = NOPASSWD: /bin/kill, /bin/ls, /usr/bin/lprm
.Ve
would allow the user \fBray\fR to run \fI/bin/kill\fR, \fI/bin/ls\fR, and
\&\fI/usr/bin/lprm\fR as root on the machine rushmore as \fBroot\fR without
authenticating himself.  If we only want \fBray\fR to be able to
run \fI/bin/kill\fR without a password the entry would be:
.PP
.Vb 1
\& ray    rushmore = NOPASSWD: /bin/kill, PASSWD: /bin/ls, /usr/bin/lprm
.Ve
Note, however, that the \f(CW\*(C`PASSWD\*(C'\fR tag has no effect on users who are
in the group specified by the exempt_group option.
.PP
By default, if the \f(CW\*(C`NOPASSWD\*(C'\fR tag is applied to any of the entries
for a user on the current host, he or she will be able to run
\&\f(CW\*(C`sudo \-l\*(C'\fR without a password.  Additionally, a user may only run
\&\f(CW\*(C`sudo \-v\*(C'\fR without a password if the \f(CW\*(C`NOPASSWD\*(C'\fR tag is present
for all a user's entries that pertain to the current host.
This behavior may be overridden via the verifypw and listpw options.
.Sh "Wildcards (aka meta characters):"
.IX Subsection "Wildcards (aka meta characters):"
\&\fBsudo\fR allows shell-style \fIwildcards\fR to be used in pathnames
as well as command line arguments in the \fIsudoers\fR file.  Wildcard
matching is done via the \fB\s-1POSIX\s0\fR \f(CW\*(C`fnmatch(3)\*(C'\fR routine.  Note that
these are \fInot\fR regular expressions.
.Ip "\f(CW\*(C`*\*(C'\fR" 8
.IX Item "*"
Matches any set of zero or more characters.
.Ip "\f(CW\*(C`?\*(C'\fR" 8
.IX Item "?"
Matches any single character.
.Ip "\f(CW\*(C`[...]\*(C'\fR" 8
.IX Item "[...]"
Matches any character in the specified range.
.Ip "\f(CW\*(C`[!...]\*(C'\fR" 8
.IX Item "[!...]"
Matches any character \fBnot\fR in the specified range.
.Ip "\f(CW\*(C`\ex\*(C'\fR" 8
.IX Item "x"
For any character \*(L"x\*(R", evaluates to \*(L"x\*(R".  This is used to
escape special characters such as: \*(L"*\*(R", \*(L"?\*(R", \*(L"[\*(R", and \*(L"}\*(R".
.PP
Note that a forward slash ('/') will \fBnot\fR be matched by
wildcards used in the pathname.  When matching the command
line arguments, however, as slash \fBdoes\fR get matched by
wildcards.  This is to make a path like:
.PP
.Vb 1
\&    /usr/bin/*
.Ve
match \f(CW\*(C`/usr/bin/who\*(C'\fR but not \f(CW\*(C`/usr/bin/X11/xterm\*(C'\fR.
.Sh "Exceptions to wildcard rules:"
.IX Subsection "Exceptions to wildcard rules:"
The following exceptions apply to the above rules:
.if n .Ip "\f(CW""""""""\fR" 8
.el .Ip "\f(CW``''\fR" 8
.IX Item """""
If the empty string \f(CW\*(C`""\*(C'\fR is the only command line argument in the
\&\fIsudoers\fR entry it means that command is not allowed to be run
with \fBany\fR arguments.
.Sh "Other special characters and reserved words:"
.IX Subsection "Other special characters and reserved words:"
The pound sign ('#') is used to indicate a comment (unless it
occurs in the context of a user name and is followed by one or
more digits, in which case it is treated as a uid).  Both the
comment character and any text after it, up to the end of the line,
are ignored.
.PP
The reserved word \fB\s-1ALL\s0\fR is a built in \fIalias\fR that always causes
a match to succeed.  It can be used wherever one might otherwise
use a \f(CW\*(C`Cmnd_Alias\*(C'\fR, \f(CW\*(C`User_Alias\*(C'\fR, \f(CW\*(C`Runas_Alias\*(C'\fR, or \f(CW\*(C`Host_Alias\*(C'\fR.
You should not try to define your own \fIalias\fR called \fB\s-1ALL\s0\fR as the
built in alias will be used in preference to your own.  Please note
that using \fB\s-1ALL\s0\fR can be dangerous since in a command context, it
allows the user to run \fBany\fR command on the system.
.PP
An exclamation point ('!') can be used as a logical \fInot\fR operator
both in an \fIalias\fR and in front of a \f(CW\*(C`Cmnd\*(C'\fR.  This allows one to
exclude certain values.  Note, however, that using a \f(CW\*(C`!\*(C'\fR in
conjunction with the built in \f(CW\*(C`ALL\*(C'\fR alias to allow a user to
run \*(L"all but a few\*(R" commands rarely works as intended (see \s-1SECURITY\s0
\&\s-1NOTES\s0 below).
.PP
Long lines can be continued with a backslash ('\e') as the last
character on the line.
.PP
Whitespace between elements in a list as well as special syntactic
characters in a \fIUser Specification\fR ('=', ':', '(', ')') is optional.
.PP
The following characters must be escaped with a backslash ('\e') when
used as part of a word (e.g. a username or hostname):
\&'@', '!', '=', ':', ',', '(', ')', '\e'.
.SH "EXAMPLES"
.IX Header "EXAMPLES"
Below are example \fIsudoers\fR entries.  Admittedly, some of
these are a bit contrived.  First, we define our \fIaliases\fR:
.PP
.Vb 4
\& # User alias specification
\& User_Alias     FULLTIMERS = millert, mikef, dowdy
\& User_Alias     PARTTIMERS = bostley, jwfox, crawl
\& User_Alias     WEBMASTERS = will, wendy, wim
.Ve
.Vb 3
\& # Runas alias specification
\& Runas_Alias    OP = root, operator
\& Runas_Alias    DB = oracle, sybase
.Ve
.Vb 9
\& # Host alias specification
\& Host_Alias     SPARC = bigtime, eclipse, moet, anchor :\e
\&                SGI = grolsch, dandelion, black :\e
\&                ALPHA = widget, thalamus, foobar :\e
\&                HPPA = boa, nag, python
\& Host_Alias     CUNETS = 128.138.0.0/255.255.0.0
\& Host_Alias     CSNETS = 128.138.243.0, 128.138.204.0/24, 128.138.242.0
\& Host_Alias     SERVERS = master, mail, www, ns
\& Host_Alias     CDROM = orion, perseus, hercules
.Ve
.Vb 12
\& # Cmnd alias specification
\& Cmnd_Alias     DUMPS = /usr/bin/mt, /usr/sbin/dump, /usr/sbin/rdump,\e
\&                        /usr/sbin/restore, /usr/sbin/rrestore
\& Cmnd_Alias     KILL = /usr/bin/kill
\& Cmnd_Alias     PRINTING = /usr/sbin/lpc, /usr/bin/lprm
\& Cmnd_Alias     SHUTDOWN = /usr/sbin/shutdown
\& Cmnd_Alias     HALT = /usr/sbin/halt, /usr/sbin/fasthalt
\& Cmnd_Alias     REBOOT = /usr/sbin/reboot, /usr/sbin/fastboot
\& Cmnd_Alias     SHELLS = /usr/bin/sh, /usr/bin/csh, /usr/bin/ksh, \e
\&                         /usr/local/bin/tcsh, /usr/bin/rsh, \e
\&                         /usr/local/bin/zsh
\& Cmnd_Alias     SU = /usr/bin/su
.Ve
Here we override some of the compiled in default values.  We want
\&\fBsudo\fR to log via \fIsyslog\fR\|(3) using the \fIauth\fR facility in all cases.
We don't want to subject the full time staff to the \fBsudo\fR lecture,
and user \fBmillert\fR need not give a password.  In addition, on the
machines in the \fI\s-1SERVERS\s0\fR \f(CW\*(C`Host_Alias\*(C'\fR, we keep an additional
local log file and make sure we log the year in each log line since
the log entries will be kept around for several years.
.PP
.Vb 5
\& # Override built in defaults
\& Defaults               syslog=auth
\& Defaults:FULLTIMERS    !lecture
\& Defaults:millert       !authenticate
\& Defaults@SERVERS       log_year, logfile=/var/log/sudo.log
.Ve
The \fIUser specification\fR is the part that actually determines who may
run what.
.PP
.Vb 2
\& root           ALL = (ALL) ALL
\& %wheel         ALL = (ALL) ALL
.Ve
We let \fBroot\fR and any user in group \fBwheel\fR run any command on any
host as any user.
.PP
.Vb 1
\& FULLTIMERS     ALL = NOPASSWD: ALL
.Ve
Full time sysadmins (\fBmillert\fR, \fBmikef\fR, and \fBdowdy\fR) may run any
command on any host without authenticating themselves.
.PP
.Vb 1
\& PARTTIMERS     ALL = ALL
.Ve
Part time sysadmins (\fBbostley\fR, \fBjwfox\fR, and \fBcrawl\fR) may run any
command on any host but they must authenticate themselves first
(since the entry lacks the \f(CW\*(C`NOPASSWD\*(C'\fR tag).
.PP
.Vb 1
\& jack           CSNETS = ALL
.Ve
The user \fBjack\fR may run any command on the machines in the \fI\s-1CSNETS\s0\fR alias
(the networks \f(CW\*(C`128.138.243.0\*(C'\fR, \f(CW\*(C`128.138.204.0\*(C'\fR, and \f(CW\*(C`128.138.242.0\*(C'\fR).
Of those networks, only \f(CW\*(C`128.138.204.0\*(C'\fR has an explicit netmask (in
\&\s-1CIDR\s0 notation) indicating it is a class C network.  For the other
networks in \fI\s-1CSNETS\s0\fR, the local machine's netmask will be used
during matching.
.PP
.Vb 1
\& lisa           CUNETS = ALL
.Ve
The user \fBlisa\fR may run any command on any host in the \fI\s-1CUNETS\s0\fR alias
(the class B network \f(CW\*(C`128.138.0.0\*(C'\fR).
.PP
.Vb 2
\& operator       ALL = DUMPS, KILL, PRINTING, SHUTDOWN, HALT, REBOOT,\e
\&                /usr/oper/bin/
.Ve
The \fBoperator\fR user may run commands limited to simple maintenance.
Here, those are commands related to backups, killing processes, the
printing system, shutting down the system, and any commands in the
directory \fI/usr/oper/bin/\fR.
.PP
.Vb 1
\& joe            ALL = /usr/bin/su operator
.Ve
The user \fBjoe\fR may only \fIsu\fR\|(1) to operator.
.PP
.Vb 1
\& pete           HPPA = /usr/bin/passwd [A-z]*, !/usr/bin/passwd root
.Ve
The user \fBpete\fR is allowed to change anyone's password except for
root on the \fI\s-1HPPA\s0\fR machines.  Note that this assumes \fIpasswd\fR\|(1)
does not take multiple usernames on the command line.
.PP
.Vb 1
\& bob            SPARC = (OP) ALL : SGI = (OP) ALL
.Ve
The user \fBbob\fR may run anything on the \fI\s-1SPARC\s0\fR and \fI\s-1SGI\s0\fR machines
as any user listed in the \fI\s-1OP\s0\fR \f(CW\*(C`Runas_Alias\*(C'\fR (\fBroot\fR and \fBoperator\fR).
.PP
.Vb 1
\& jim            +biglab = ALL
.Ve
The user \fBjim\fR may run any command on machines in the \fIbiglab\fR netgroup.
\&\fBSudo\fR knows that \*(L"biglab\*(R" is a netgroup due to the '+' prefix.
.PP
.Vb 1
\& +secretaries   ALL = PRINTING, /usr/bin/adduser, /usr/bin/rmuser
.Ve
Users in the \fBsecretaries\fR netgroup need to help manage the printers
as well as add and remove users, so they are allowed to run those
commands on all machines.
.PP
.Vb 1
\& fred           ALL = (DB) NOPASSWD: ALL
.Ve
The user \fBfred\fR can run commands as any user in the \fI\s-1DB\s0\fR \f(CW\*(C`Runas_Alias\*(C'\fR
(\fBoracle\fR or \fBsybase\fR) without giving a password.
.PP
.Vb 1
\& john           ALPHA = /usr/bin/su [!-]*, !/usr/bin/su *root*
.Ve
On the \fI\s-1ALPHA\s0\fR machines, user \fBjohn\fR may su to anyone except root
but he is not allowed to give \fIsu\fR\|(1) any flags.
.PP
.Vb 1
\& jen            ALL, !SERVERS = ALL
.Ve
The user \fBjen\fR may run any command on any machine except for those
in the \fI\s-1SERVERS\s0\fR \f(CW\*(C`Host_Alias\*(C'\fR (master, mail, www and ns).
.PP
.Vb 1
\& jill           SERVERS = /usr/bin/, !SU, !SHELLS
.Ve
For any machine in the \fI\s-1SERVERS\s0\fR \f(CW\*(C`Host_Alias\*(C'\fR, \fBjill\fR may run
any commands in the directory /usr/bin/ except for those commands
belonging to the \fI\s-1SU\s0\fR and \fI\s-1SHELLS\s0\fR \f(CW\*(C`Cmnd_Aliases\*(C'\fR.
.PP
.Vb 1
\& steve          CSNETS = (operator) /usr/local/op_commands/
.Ve
The user \fBsteve\fR may run any command in the directory /usr/local/op_commands/
but only as user operator.
.PP
.Vb 1
\& matt           valkyrie = KILL
.Ve
On his personal workstation, valkyrie, \fBmatt\fR needs to be able to
kill hung processes.
.PP
.Vb 1
\& WEBMASTERS     www = (www) ALL, (root) /usr/bin/su www
.Ve
On the host www, any user in the \fI\s-1WEBMASTERS\s0\fR \f(CW\*(C`User_Alias\*(C'\fR (will,
wendy, and wim), may run any command as user www (which owns the
web pages) or simply \fIsu\fR\|(1) to www.
.PP
.Vb 2
\& ALL            CDROM = NOPASSWD: /sbin/umount /CDROM,\e
\&                /sbin/mount -o nosuid\e,nodev /dev/cd0a /CDROM
.Ve
Any user may mount or unmount a \s-1CD-ROM\s0 on the machines in the \s-1CDROM\s0
\&\f(CW\*(C`Host_Alias\*(C'\fR (orion, perseus, hercules) without entering a password.
This is a bit tedious for users to type, so it is a prime candidate
for encapsulating in a shell script.
.SH "SECURITY NOTES"
.IX Header "SECURITY NOTES"
It is generally not effective to \*(L"subtract\*(R" commands from \f(CW\*(C`ALL\*(C'\fR
using the '!' operator.  A user can trivially circumvent this
by copying the desired command to a different name and then
executing that.  For example:
.PP
.Vb 1
\&    bill        ALL = ALL, !SU, !SHELLS
.Ve
Doesn't really prevent \fBbill\fR from running the commands listed in
\&\fI\s-1SU\s0\fR or \fI\s-1SHELLS\s0\fR since he can simply copy those commands to a
different name, or use a shell escape from an editor or other
program.  Therefore, these kind of restrictions should be considered
advisory at best (and reinforced by policy).
.SH "CAVEATS"
.IX Header "CAVEATS"
The \fIsudoers\fR file should \fBalways\fR be edited by the \fBvisudo\fR
command which locks the file and does grammatical checking. It is
imperative that \fIsudoers\fR be free of syntax errors since \fBsudo\fR
will not run with a syntactically incorrect \fIsudoers\fR file.
.PP
When using netgroups of machines (as opposed to users), if you
store fully qualified hostnames in the netgroup (as is usually the
case), you either need to have the machine's hostname be fully qualified
as returned by the \f(CW\*(C`hostname\*(C'\fR command or use the \fIfqdn\fR option in
\&\fIsudoers\fR.
.SH "FILES"
.IX Header "FILES"
.Vb 3
\& /etc/sudoers           List of who can run what
\& /etc/group             Local groups file
\& /etc/netgroup          List of network groups
.Ve
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fIrsh\fR\|(1), \fIsudo\fR\|(8), \fIvisudo\fR\|(8), \fIsu\fR\|(1), \fIfnmatch\fR\|(3).
