/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2009 Akira Ujio
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.5 2003/12/24 07:24:40 honda Exp $
 */

/*
 *	åȰ¸ޥ⥸塼Linuxѡ
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#ifndef _MACRO_ONLY
#include <pthread.h>
#endif /* _MACRO_ONLY */
/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	SIGALRM

/*
 *
 *
 */
#define TIMER_CLOCK             1
#define TO_CLOCK(nume, deno)    (TIMER_CLOCK * (nume) / (deno))



#ifndef _MACRO_ONLY
/*
 *  ͤɽη
 */
typedef UW	CLOCK;

extern void timer_polling(void);

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
	/*
	 *	threadthreadSIGALARMȯԤ
	 */
	pthread_t t;
	struct sched_param priority;
	priority.sched_priority = 50;
	pthread_attr_t attr;
	pthread_attr_init(&attr);
	pthread_attr_setschedparam(&attr, &priority);
	pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	pthread_create(&t, &attr, (void *)timer_polling, NULL);
	pthread_attr_destroy(&attr);
}


/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
hw_timer_terminate()
{

}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */


