package com.snail.msglet;

import java.util.Collection;
import java.util.LinkedList;


/**
 * Msgletの処理結果.
 *
 * @author kagyuu
  */
public class Response {
  /**
   * 受信者の一覧(デフォルト値は送信者のみ).
   */
  private Collection<User> receivers;

  /**
   * 送信するメッセージ(デフォルト値は"").
   */
  private String msg = "";

  /**
   * 送信するときに封書形式で送るか(デフォルト値はRequestの形式).
   */
  private boolean lock;

  /**
   * Creates a new Response object.
   *
   * @param pReceiver 受信者
   * @param pLock 封書形式で送るかどうかのフラグ
   */
  public Response(final User pReceiver, final boolean pLock) {
    this.receivers = new LinkedList<User>();
    receivers.add(pReceiver);
    this.lock = pLock;
  }

  /**
   * get lock.
   * @return lock
   */
  public final boolean isLock() {
    return lock;
  }

  /**
   * set lock.
   * @param lock lock
   */
  public final void setLock(final boolean lock) {
    this.lock = lock;
  }

  /**
   * get msg.
   * @return msg
   */
  public final String getMsg() {
    return msg;
  }

  /**
   * set msg.
   * @param msg msg
   */
  public final void setMsg(final String msg) {
    this.msg = msg;
  }

  /**
   * get receivers.
   * @return receivers
   */
  public final Collection<User> getReceivers() {
    return receivers;
  }

  /**
   * set receivers.
   * @param receivers receivers
   */
  public final void setReceivers(final Collection<User> receivers) {
    this.receivers = receivers;
  }
}
