<?php

/* gpbNE[eBeB֐Q */

/*==========================================================================*
 * scandir_r -- ċAIɃfBNg֐                          *
 * Xgt@CƃfBNgɕĕԂBꂻ̃Xg͒PȔz *
 *==========================================================================*/
function scandir_r($dir)
{
	$dir = realpath($dir);
	$list = array('files' => array(), 'dirs' => array());
	$files = (phpversion() >= '5.0.0b3') ? scandir($dir) : alt_scandir($dir);
	foreach ($files as $filename) {
		if ($filename == '.' || $filename == '..') {
			continue;
		}
		$filename = $dir . DIRECTORY_SEPARATOR . $filename;
		if (is_dir($filename)) {
			$child = scandir_r($filename);
			if ($child) {
				$list['dirs'] = array_merge($list['dirs'], $child['dirs']);
				$list['files'] = array_merge($list['files'], $child['files']);
			}
			$list['dirs'][] = $filename;
		} else {
			$list['files'][] = $filename;
		}
	}
	return $list;
}


/*============================================================*
 * alt_scandir -- PHP5ŎĂscandir()̑        *
 * http://jp.php.net/manual/ja/function.scandir.phpRsy *
 *============================================================*/
function alt_scandir($dir)
{
	$files = array();
	$dh = opendir($dir);
	while (false !== ($filename = readdir($dh))) {
		$files[] = $filename;
	}
	closedir($dh);
	return $files;
}


/*===============================================================*
 * garbageCollection -- ЂƂ̃KxRB               *
 * $targetDirŏIXV$lifeTimebȏソt@C폜 *
 *===============================================================*/
function garbageCollection($targetDir, $lifeTime, $prefix='', $suffix='', $recursive=false)
{
	$result = array('successed' => array(), 'failed' => array(), 'skipped' => array());
	$expire = time() - $lifeTime;
	//t@CXg擾
	if ($recursive) {
		$list = scandir_r($targetDir);
		$files =& $list['files'];
	} else {
		$list = (phpversion() >= '5.0.0b3') ? scandir($targetDir) : alt_scandir($targetDir);
		$files = array();
		$targetDir = realpath($targetDir) . DIRECTORY_SEPARATOR;
		foreach ($list as $filename) {
			if ($filename == '.' || $filename == '..') { continue; }
			$files[] = $targetDir . $filename;
		}
	}
	//p^[ݒi$prefix$suffixɃXbV܂܂Ȃ悤Ɂj
	if ($prefix || $suffix) {
		$prefix = (is_array($prefix)) ? implode('|', array_map('preg_quote', $prefix)) : preg_quote($prefix);
		$suffix = (is_array($suffix)) ? implode('|', array_map('preg_quote', $suffix)) : preg_quote($suffix);
		$pattern = '/^' . $prefix . '.+' . $suffix . '$/';
	} else {
		$pattern = '';
	}
	//KxRJn
	foreach ($files as $filename) {
		if ($pattern && !preg_match($pattern, basename($filename))) {
			//$result['skipped'][] = $filename;
			continue;
		}
		if (filemtime($filename) < $expire) {
			if (@unlink($filename)) {
				$result['successed'][] = $filename;
			} else {
				$result['failed'][] = $filename;
			}
		}
	}
	return $result;
}


/*===========================================================*
 * Info_Dump -- ze[uɕϊ֐           *
 * Q˂setting.txtp[Xzp̏򂠂 *
 * ʂɃ_vȂVar_Dump::r_display()ĝ *
 *===========================================================*/
function Info_Dump($info, $indent=0)
{
	$table = '<table border="0" cellspacing="1" cellpadding="0">' . "\n";
	$n = count($info);
	foreach ($info as $key => $value) {
		if (!is_object($value) && !is_resource($value)) {
			for ($i = 0; $i < $indent; $i++) { $table .= "\t"; }
			if ($n == 1 && $key === 0) {
				$table .= '<tr><td class="tdcont">';
			/*} elseif (preg_match('/^\w+$/', $key)) {
				$table .= '<tr class="setting"><td class="tdleft"><b>' . $key . '</b></td><td class="tdcont">';*/
			} else {
				$table .= '<tr><td class="tdleft"><b>' . $key . '</b></td><td class="tdcont">';
			}
			if (is_array($value)) {
				$table .= Info_Dump($value, $indent+1); //z̏ꍇ͍ċAĂяoœWJ
			} elseif ($value === true) {
				$table .= '<i>TRUE</i>';
			} elseif ($value === false) {
				$table .= '<i>FALSE</i>';
			} elseif (is_null($value)) {
				$table .= '<i>NULL</i>';
			} elseif (is_scalar($value)) {
				if ($value === '') { //O:󕶎B0܂߂Ȃ悤Ɍ^lĔr
					$table .= '<i>(no value)</i>';
				} elseif ($key == 'O擾<br>Xbh') { //O폜p
					$table .= $value;
				} elseif ($key == '[J[') { //[J[p
					$table .= '<table border="0" cellspacing="1" cellpadding="0" class="child">';
					$table .= "\n\t\t<tr><td id=\"rule\">{$value}</tr></td>\n\t</table>";
				} elseif (preg_match('/^(https?|ftp):\/\/[\w\/\.\+\-\?=~@#%&:;]+$/i', $value)) { //N
					$table .= "<a href=\"{$value}\" target=\"_blank\">{$value}</a>";
				} elseif ($key == 'wiF' || substr($key, -6) == '_COLOR') { //J[Tv
					$table .= "<span class=\"colorset\" style=\"color:{$value};\"></span>i{$value}j";
				} else {
					$table .= htmlspecialchars($value);
				}
			}
			$table .= '</td></tr>' . "\n";
		}
	}
	for ($i = 1; $i < $indent; $i++) { $table .= "\t"; }
	$table .= '</table>';
	$table = str_replace('<td class="tdcont"><table border="0" cellspacing="1" cellpadding="0">',
		'<td class="tdcont"><table border="0" cellspacing="1" cellpadding="0" class="child">', $table);

	return $table;
}


/**
 * ėpċANX
 */
class Recursive
{
	var $_handler;
	var $_limit;
	var $_checked;

	//RXgN^
	function Recursive($handler=null, $limit=5)
	{
		$this->setHandler($handler);
		$this->setLimit($limit);
	}

	//map\bḧ֐E\bhݒ
	function setHandler($handler=null)
	{
		$this->_handler = $handler;
		$this->_checked = false;
	}

	//őċA񐔂ݒ
	function setLimit($limit)
	{
		$this->_limit = $limit;
	}

	//ċAIɏ
	function map($value, $count=0)
	{
		//ċA񐔂̃`FbN
		if ($count > $this->_limit) {
			return $value;
		}
		//LȊ֐̓\bh`FbN
		/*if (!$this->_checked) {
			if (is_string($this->_handler)) {
				if (function_exists($this->_handler)) {
					$this->_checked = true;
				} else {
					trigger_error("expack-Recursive:: Function {$this->_handler} is not exists.", E_USER_ERROR);
				}
			} elseif (is_array($this->_handler) && is_object($this->_handler[0]) && is_string($this->_handler[1])) {
				if (method_exists($this->_handler[0], $this->_handler[1])) {
					$this->_checked = true;
				} else {
					trigger_error("expack-Recursive:: Function {$this->_handler} is not exists.", E_USER_ERROR);
				}
			} else {
				trigger_error("expack-Recursive:: Invalid handler was given.", E_USER_ERROR);
			}
		}*/
		//ċAIɏ
		if (is_object($value)) {
			$properties = get_object_vars($value);
			if (count($properties) == 0) { return $value; }
			foreach ($properties as $p => $v) {
				$value->$p = $this->map($v, $count+1);
			}
			return $value;
		} elseif (is_array($value)) {
			if (count($value) == 0) { return $value; }
			foreach ($value as $k => $v) {
				$value[$k] = $this->map($v, $count+1);
			}
			return $value;
		} else {
			if (is_array($this->_handler)) {
				$object =& $this->_handler[0];
				$method = $this->_handler[1];
				return $object->$method($value);
			} else {
				$function = $this->_handler;
				return $function($value);
			}
		}
	}
}


?>