<?php
// p2 - 摜LbVꗗ - ֐Cu

// imgcache.inc Ƃ iv.inc ̓NXƂĐ݌vȂB

require_once 'expack.inc';
require_once 'imgcache.inc';

/**
 * t@C񂩂URI𒊏o֐
 * array_map()̃R[obN֐Ƃėp
 */
function onlyURI($line) 
{
	$data = explode("\t", trim($line));
	return $data[0];
}


/**
 * t@C𕪊֐
 * array_walk()̃R[obN֐Ƃėp
 * ʂ肩̕@AŃ\[gp̔z
 * array_multisort΂񑬂B
 */
function splitList(&$line, $key) 
{
	global $_key;
	$data = explode("\t", trim($line));
	if ($data[1]) {
		$_key['name'][$key] = basename($data[0]);
		$_key['size'][$key] = intval($data[1]);
		$_key['time'][$key] = intval($data[2]);
	} else {
		$_key['name'][$key] = basename($data[0]);
		$_key['size'][$key] = getCacheSize($data[0]);
		$_key['time'][$key] = getCacheTime($data[0]);
	}
	$line = $data[0];
}


/**
 * LbVꂽԂ𒲂ׂ֐
 */
function getCacheTime($uri)
{
	global $ic_cachedir;
	$arr = parse_url($uri);
	$path = $arr['host'] . $arr['path'];
	if (P2_SAFE_MODE) {
		$path = $ic_cachedir . '/' . rawurlencode($path);
	} else {
		$path = $ic_cachedir . '/' . $path;
	}
	if (file_exists($path)) {
		return filemtime($path);
	} else {
		return 0;
	}
}


/**
 * t@CTCY𒲂ׂ֐
 */
function getCacheSize($uri)
{
	global $ic_cachedir;
	$arr = parse_url($uri);
	$path = $arr['host'] . $arr['path'];
	if (P2_SAFE_MODE) {
		$path = $ic_cachedir . '/' . rawurlencode($path);
	} else {
		$path = $ic_cachedir . '/' . $path;
	}
	if (file_exists($path)) {
		return filesize($path);
	} else {
		return 0;
	}
}


/**
 * t@CTCY̕\L𐮂֐
 */
function formatFileSize($size)
{
	if ($size >= 1048576) {
		$size = round($size/1048576, 1) . 'MB';
	} elseif ($size >= 1024) {
		$size = round($size/1024, 1) . 'KB';
	} else {
		$size .= 'Bytes';
	}
	return $size;
}


/**
 * zXgPʂŃt@C폜ۂ̌p^[ݒ肷֐
 */
function getHostPattern($files)
{
	global $target_hosts;
	$hosts = array();
	$pattern = '<^[[:alpha:]]+://(?:';
	foreach ($files as $target_file) {
		$_url = parse_url($target_file);
		$host = $_url['host'];
		if (!in_array($host, $target_hosts)) {
			$target_hosts[] = $host;
			$pattern .= preg_quote($host);
			$pattern .= '|';
		}
	}
	$pattern = substr($pattern, 0, -1) . ')/>';
	return $pattern;
}


/**
 * fBNgPʂŃt@C폜ۂ̌p^[ݒ肷֐
 */
function getDirectoryPattern($files)
{
	global $target_hosts;
	$dirs = array_map('dirname', $files);
	$dirs = array_unique($dirs);
	$pattern = '<^[[:alpha:]]+://(?:';
	foreach ($dirs as $target_dir) {
		$target_dir = preg_replace('<^[[:alpha:]]+://>', '', $target_dir);
		$target_hosts[] = $target_dir;
		$pattern .= preg_quote($target_dir);
		$pattern .= '|';
	}
	$pattern = substr($pattern, 0, -1) . ')/>';
	return $pattern;
}


/**
 * t@CPʂŃt@C폜ۂ̌p^[ݒ肷֐
 */
function getFilePattern($files)
{
	$files = array_map('preg_quote', $files);
	$pattern = '<^(?:' . implode('|', $files) . ')(?:\s|$)>';
	return $pattern;
}


?>