<?php
/**
 * ホテル設定
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Hotel extends ADMIN_Controller {

    function Hotel()
    {
        parent::ADMIN_Controller();
    }
    
    public function index()
    {
        // breadcrumb [admin] -> [hotel]
        
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->load->library('phpsession');
        
        $this->form_validation->set_rules('hotel_name', 'ホテル名', 'required|trim');
        $this->form_validation->set_rules('email', 'メールアドレス', 'required|trim|valid_emails');
        $this->form_validation->set_rules('url', 'URL', '');
        $this->form_validation->set_rules('res_prev_days', '予約可能日(日前)', 'integer|required|trim');
        $this->form_validation->set_rules('res_term', '予約可能期間(ヶ月)', 'integer|required|trim');
        $this->form_validation->set_rules('tentative_reservation', '仮予約', '');
        $this->form_validation->set_rules('cin_hour', 'チェックイン時刻1', 'trim|xss_clean');
        $this->form_validation->set_rules('cin_hour2', 'チェックイン時刻2', 'trim|xss_clean');
        $this->form_validation->set_rules('cout_hour', 'チェックアウト時刻', 'trim|xss_clean');
        $this->form_validation->set_rules('phone', '電話番号', 'trim');
        $this->form_validation->set_rules('postcode', '郵便番号', 'trim');
        $this->form_validation->set_rules('prefecture', '都道府県', 'trim');
        $this->form_validation->set_rules('city', '市区町村', 'trim');
        $this->form_validation->set_rules('street', '番地', 'trim');
        
        $hotelid = 1;
        
        if (!$this->input->post('submit'))
        {
            $this->db->where('hotelid', $hotelid);
            $query = $this->db->get('hotel', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $data['hotel_name'] = $row['hotel_name'];
                $data['email'] = $row['email'];
                $data['url'] = $row['url'];
                $data['res_prev_days'] = $row['res_prev_days'];
                $data['res_term'] = $row['res_term'];
                if ($row['tentative_reservation'] == 1)
                {
                    $data['tentative_reservation'] = 1;
                }
                else
                {
                    $data['tentative_reservation'] = 0;
                }
                $data['cin_hour'] = substr($row['cin_hour'], 0, 5);
                $data['cin_hour2'] = substr($row['cin_hour2'], 0, 5);
                $data['cout_hour'] = substr($row['cout_hour'], 0, 5);
                $data['phone'] = $row['phone'];
                $data['postcode'] = $row['postcode'];
                $data['prefecture'] = $row['prefecture'];
                $data['city'] = $row['city'];
                $data['street'] = $row['street'];
                $this->load->vars($data);
            }
            else
            {
                $data['res_prev_days'] = 0;
                $data['res_term'] = 6;
                $data['tentative_reservation'] = 1;
                $data['cin_hour'] = '15:00';
                $data['cin_hour2'] = '23:00';
                $data['cout_hour'] = '10:00';
            }
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('admin/hotel/index');
        }
        else
        {
            $data = array(
                           'hotel_name' => set_value('hotel_name'),
                           'email' => set_value('email'),
                           'url' => set_value('url'),
                           'res_prev_days' => set_value('res_prev_days'),
                           'res_term' => set_value('res_term'),
                           'tentative_reservation' => intval(set_value('tentative_reservation')),
                           'cin_hour' => set_value('cin_hour'),
                           'cin_hour2' => set_value('cin_hour2'),
                           'cout_hour' => set_value('cout_hour'),
                           'phone' => set_value('phone'),
                           'postcode' => set_value('postcode'),
                           'prefecture' => set_value('prefecture'),
                           'city' => set_value('city'),
                           'street' => set_value('street')
                        );
                        
            $this->db->where('hotelid', $hotelid);
            $query = $this->db->get('hotel', 1);
            if ($query->num_rows() > 0)
            {
                $this->db->where('hotelid', $hotelid);
                $this->db->update('hotel', $data);
            }
            else
            {
                $data = array(
                               'hotelid' => $hotelid,
                               'hotel_name' => set_value('hotel_name'),
                               'email' => set_value('email'),
                               'url' => set_value('url'),
                               'res_prev_days' => set_value('res_prev_days'),
                               'res_term' => set_value('res_term'),
                               'tentative_reservation' => set_value('tentative_reservation'),
                               'cin_hour' => set_value('cin_hour'),
                               'cin_hour2' => set_value('cin_hour2'),
                               'cout_hour' => set_value('cout_hour'),
                               'phone' => set_value('phone'),
                               'postcode' => set_value('postcode'),
                               'prefecture' => set_value('prefecture'),
                               'city' => set_value('city'),
                               'street' => set_value('street')
                            );
                $this->db->insert('hotel', $data);
            }
            $this->load->view('admin/hotel/index');
        }
    }
    
    public function email()
    {
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->load->library('phpsession');
        
        // breadcrumb [admin] -> [email]
        $this->load->view('admin/hotel/email');
    }
}
