<?php
/**
 * 予約モデル
 */
// Qdmailのエラー(E_DEPRECATED)がでるので...
error_reporting(E_ALL & ~E_DEPRECATED);
include(dirname(__FILE__) . "/../libraries/qdmail.php");

class Res_model extends Model {
    
    var $lockdir = "./private/ci-hotel.lock";     // ロック用ディレクトリ
    
    // 予約エラーコード
    const ERR_ROOM_GUEST_MIN = -1;  // 部屋あたりの人数が下限より小
    const ERR_ROOM_GUEST_MAX = -2;  // 部屋あたりの人数が上限より大
    const ERR_PLAN_GUEST_MIN = -3;  // 
    const ERR_PLAN_GUEST_MAX = -4;  // 
    const ERR_VACANT_PLAN = -5;
    const ERR_VACANT_ROOM = -6;
    const ERR_HOLIDAY = -7;         // 休館日を含む
    const ERR_PLAN_PERIOD = -8;     // プラン提供期間外
    const ERR_ROOMTYPE_PERIOD = -9; // 部屋タイプ提供期間外
    const ERR_PARAM = -99;          // パラメータエラー
    
    // 予約モード
    const RESMODE_CHECK = 1;        // チェックのみ
    const RESMODE_TENTATIVE = 2;    // 仮予約
    const RESMODE_REGULAR = 3;      // 本予約
    
    /**
     * 予約エラーコードから文字列を返す
     */
    function getErrorString($i)
    {
        $ret = '';
        switch ($i)
        {
            case Res_model::ERR_ROOM_GUEST_MIN:
                $ret = "１部屋の人数が部屋タイプの受容人数の下限より少ないです。";
                break;
            case Res_model::ERR_ROOM_GUEST_MAX:
                $ret = "１部屋の人数が部屋タイプの受容人数の上限より多いです。";
                break;
            case Res_model::ERR_PLAN_GUEST_MIN:
                $ret = "人数がプランの最小人数より少ないです。";
                break;
            case Res_model::ERR_PLAN_GUEST_MAX:
                $ret = "人数がプランの最大人数より多いです。";
                break;
            case Res_model::ERR_VACANT_PLAN:
                $ret = "プランの空き人数がありません。";
                break;
            case Res_model::ERR_VACANT_ROOM:
                $ret = "空き部屋がありません。";
                break;
            case Res_model::ERR_HOLIDAY:
                $ret = "休館日が含まれています。";
                break;
            case Res_model::ERR_PLAN_PERIOD:
                $ret = "プラン提供期間外です。";
                break;
            case Res_model::ERR_ROOMTYPE_PERIOD:
                $ret = "部屋タイプ提供期間外です。";
                break;
            case Res_model::ERR_PARAM:
                $ret = "パラメータエラー";
                break;
        }
        return $ret;
    }
    
    function Res_model()
    {
        parent::Model();
    }
    
    public function lock()
    {
        $i = 0;
        while (!mkdir($this->lockdir))
        {
            usleep(100000);             // 0.1秒待つ
            if ($i++ > 100)
            {
                break;
            }
        }
        if ($i > 100)
        {
            log_message('error', 'lock ERROR');
        }
        else
        {
            log_message('info', 'locked');
        }
    }
    
    public function unlock()
    {
        rmdir($this->lockdir);
        log_message('info', 'unlocked');
    }
    
    
    /**
     * 予約を実行する
     *
     * セッションの予約データを参照する。
     * @return 0:正常,整数:予約id,負数:エラー
     */    public function doRes($resmode, $hotel_model)
    {
        $this->load->library('phpsession');
        
        $planid = $this->phpsession->get('planid');
        $cin = $this->phpsession->get('cin');
        $cout = $this->phpsession->get('cout');
        $room_num = $this->phpsession->get('room_num');
        $basic_num = $this->phpsession->get('basic_num');
        $child1_num = $this->phpsession->get('child1_num');
        $child2_num = $this->phpsession->get('child2_num');
        $child3_num = $this->phpsession->get('child3_num');
        $child4_num = $this->phpsession->get('child4_num');
        $cinhour = $this->phpsession->get('cinhour');
        if ($cinhour == null || $cinhour == '')
        {
            $cinhour = '00:00:00';
        }
        $memo = $this->phpsession->get('memo');
        
        $resid = 0;
        
        $this->db->where('planid', $planid);
        $query = $this->db->get('plans', 1);
        if ($query->num_rows() <= 0)
        {
            return  Res_model::ERR_PARAM;
        }
        $plan = $query->row_array();
        
        $this->db->where('roomtypeid', $plan['roomtypeid']);
        $query = $this->db->get('roomtypes', 1);
        if ($query->num_rows() <= 0)
        {
            return  Res_model::ERR_PARAM;
        }
        $roomtype = $query->row_array();
        
        // 一部屋あたりの人数
        $n = $plan['basic_count']  * $basic_num
           + $plan['child1_count'] * $child1_num
           + $plan['child2_count'] * $child2_num
           + $plan['child3_count'] * $child3_num
           + $plan['child4_count'] * $child4_num;
        
        // 予約プラン人数
        $vplan = $n * $room_num;
        
        // 予約空き部屋数
        $vroom = $room_num;
        
        // トランザクション開始
        $this->db->trans_start();
        
        $day_price = 0;
        try
        {
            $this->lock();
            
            // プラン提供期間内であるかをチェックする
            $int_start_date = intval(substr($plan['start_date'], 0, 4) . substr($plan['start_date'], 5, 2) . substr($plan['start_date'], 8, 2));
            $int_end_date = intval(substr($plan['end_date'], 0, 4) . substr($plan['end_date'], 5, 2) . substr($plan['end_date'], 8, 2));
            $int_cin = intval(substr($cin, 0, 4) . substr($cin, 5, 2) . substr($cin, 8, 2));
            $int_cout = intval(substr($cout, 0, 4) . substr($cout, 5, 2) . substr($cout, 8, 2));
            if ($int_cin < $int_start_date || $int_cout > $int_end_date)
            {
                throw new Exception('',  Res_model::ERR_PLAN_PERIOD);
            }
            
            // 部屋タイプ提供期間内であるかをチェックする
            $int_start_date = intval(substr($roomtype['start_date'], 0, 4) . substr($roomtype['start_date'], 5, 2) . substr($roomtype['start_date'], 8, 2));
            $int_end_date = intval(substr($roomtype['end_date'], 0, 4) . substr($roomtype['end_date'], 5, 2) . substr($roomtype['end_date'], 8, 2));
            if ($int_cin < $int_start_date || $int_cout > $int_end_date)
            {
                throw new Exception('',  Res_model::ERR_ROOMTYPE_PERIOD);
            }
            
            // 人数が部屋の許容人数以内であることをチェックする
            if ($n < $roomtype['guest_min'])
            {
                throw new Exception('',  Res_model::ERR_ROOM_GUEST_MIN);
            }
            else if ($n > $roomtype['guest_max'])
            {
                throw new Exception('',  Res_model::ERR_ROOM_GUEST_MAX);
            }
            
            // プラン人数がプランの許容最小値から最大値の範囲内である
            // ことをチェックする。
            if ($vplan < $plan['guest_min'])
            {
                throw new Exception('',  Res_model::ERR_PLAN_GUEST_MIN);
            }
            else if ($vplan > $plan['guest_max'])
            {
                throw new Exception('',  Res_model::ERR_PLAN_GUEST_MAX);
            }
            
            $tmp_y = substr($cin, 0, 4);
            $tmp_m = substr($cin, 5, 2);
            $tmp_d = substr($cin, 8, 2);
            for ($i = 0;;$i++) {
                $tmp_date = date('Y-m-d', mktime(0, 0, 0, $tmp_m, $tmp_d + $i, $tmp_y));
                if ($tmp_date >= $cout)
                {
                    break;
                }
                
                // 日程をチェックする（休館日でないか）
                $this->db->where('value', 'Z');
                $this->db->where('day', $tmp_date);
                $query = $this->db->get('daytype', 1);
                if ($query->num_rows() > 0)
                {
                    throw new Exception('',  Res_model::ERR_HOLIDAY);
                }
                
                // プラン人数空きをチェックし、空きがあれば空き数を更新する。
                $this->db->where('planid', $planid);
                $this->db->where('day', $tmp_date);
                $query = $this->db->get('vacantplans', 1);
                
                $record_flag = false;   // DB:vacantplansにデータがあるか？
                $vp_num = 0;
                if ($query->num_rows() > 0)
                {
                    $record_flag = true;
                    $row = $query->row_array();
                    $vp_num = $row['vp_num'];
                    $vp_vacant = $row['vp_num'] - $row['vp_inuse'];
                }
                else
                {
                    $vp_num = $plan['default_num'];
                    $vp_vacant = $plan['default_num'];
                }
                
                if ($vp_vacant >= $vplan)
                {
                    if ($resmode == Res_model::RESMODE_TENTATIVE || $resmode == Res_model::RESMODE_REGULAR)
                    {
                        if ($record_flag == true)
                        {
                            $this->db->where('planid', $planid);
                            $this->db->where('day', $tmp_date);
                            $data = array('vp_inuse' => $row['vp_inuse'] + $vplan);
                            $this->db->update('vacantplans', $data);
                        }
                        else
                        {
                            $data = array(
                                'planid' => $planid,
                                'day' => $tmp_date,
                                'vp_inuse' => $vplan,
                                'vp_num' => $vp_num);
                            $this->db->insert('vacantplans', $data);
                        }
                    }
                }
                else
                {
                    throw new Exception('', Res_model::ERR_VACANT_PLAN);
                }
                
                // 部屋数の空きをチェックをし、空きがあれば空き数を更新する。
                $this->db->where('roomtypeid', $roomtype['roomtypeid']);
                $this->db->where('day', $tmp_date);
                $query = $this->db->get('vacantrooms', 1);
                $record_flag = false;   // DB:vacantplansにデータがあるか？
                $vr_num = 0;
                
                if ($query->num_rows() > 0)
                {
                    $record_flag = true;
                    $row = $query->row_array();
                    $vr_num = $row['vr_num'];
                    $vr_vacant = $row['vr_num'] - $row['vr_inuse'];
                }
                else
                {
                    $vr_num = $roomtype['default_num'];
                    $vr_vacant = $roomtype['default_num'];
                }
                
                if ($vr_vacant >= $vroom)
                {
                    if ($resmode == Res_model::RESMODE_TENTATIVE || $resmode == Res_model::RESMODE_REGULAR)
                    {
                        if ($record_flag == true)
                        {
                            $this->db->where('roomtypeid', $roomtype['roomtypeid']);
                            $this->db->where('day', $tmp_date);
                            $data = array('vr_inuse' => $row['vr_inuse'] + $vroom);
                            $this->db->update('vacantrooms', $data);
                        }
                        else
                        {
                            $data = array(
                                'roomtypeid' => $roomtype['roomtypeid'],
                                'day' => $tmp_date,
                                'vr_inuse' => $vroom,
                                'vr_num' => $vr_num);
                            $this->db->insert('vacantrooms', $data);
                        }
                    }
                }
                else
                {
                    log_message('info', 'Res::ERR_VACANT_ROOM');
                    throw new Exception('', Res::ERR_VACANT_ROOM);
                }
                
                // 1日分の料金計算
                $day_price += $this->getDayPrice($planid, $tmp_date, $room_num,
                    $basic_num, $child1_num, $child2_num, $child3_num, $child4_num);
            }
            
            // 総料金をセットする
            $this->phpsession->save('total_price', $day_price);
            
            if ($resmode == Res_model::RESMODE_TENTATIVE || $resmode == Res_model::RESMODE_REGULAR)
            {
                $status = 1;
                if ($resmode == Res_model::RESMODE_REGULAR)
                {
                    $status = 2;
                }
                
                $userid = 0;
                $user = $this->phpsession->get('user');
                if ($userid != null)
                {
                    $userid = $user['userid'];
                }
                
                $rescode = uniqid();
                $data = array(
                               'rescode' => $rescode,
                               'cin' => $cin,
                               'cinhour' => $cinhour,
                               'cout' => $cout,
                               'userid' => $userid,
                               'planid' => $planid,
                               'roomtypeid' => $roomtype['roomtypeid'],
                               'plan_num' => $vplan,
                               'room_num' => $vroom,
                               'basic_num' => $basic_num,
                               'child1_num' => $child1_num,
                               'child2_num' => $child2_num,
                               'child3_num' => $child3_num,
                               'child4_num' => $child4_num,
                               'status' => $status,
                               'total_price' => $day_price,
                               'created' => date("Y-m-d H:i:s"),
                               'memo' => $memo
                            );
                $this->db->insert('reservation', $data);
                $resid = $this->db->insert_id();
                log_message('info', 'reservation insert ok');
                
                $data2 = array(
                                'resid' => $resid,
                                'userid' => $userid,
                                'email' => $this->phpsession->get('email'),
                                'name' => $this->phpsession->get('name'),
                                'name_kana' => $this->phpsession->get('name_kana'),
                                'postcode' => $this->phpsession->get('postcode'),
                                'prefecture' => $this->phpsession->get('prefecture'),
                                'city' => $this->phpsession->get('city'),
                                'street' => $this->phpsession->get('street'),
                                'phone' => $this->phpsession->get('phone')
                            );
                $this->db->insert('resuser', $data2);
                log_message('info', 'resuser insert ok');
                
                /**
                 * 完了画面に表示する情報はセッションに保存する。
                 * resid, rescode
                 */
                $this->phpsession->save('resid', $resid);
                $this->phpsession->save('rescode', $rescode);
            }
            
            // トランザクション終了
            $this->db->trans_complete();
            log_message('info', 'trans_complete');
            
            $this->unlock();
            
            if ($resmode == Res_model::RESMODE_TENTATIVE)
            {
                // ユーザ宛仮予約Eメール送信
                $num = $basic_num + $child1_num + $child2_num + $child3_num + $child4_num;
                if ($userid == 0)
                {
                    $cancel_url = site_url('cancel');
                }
                else
                {
                    $cancel_url = site_url('my/index');
                }
                
                $mail_subject = $hotel_model->hotel_name . ": 仮予約メール";
                $mail_body = 
                    $data2['name'] . " 様\n" . 
                    "この度は、" . $hotel_model->hotel_name . "をご予約いただき、ありがとうございます。\n" . 
                    "以下のご予約を承りました。\n" .
                    "後ほど、本予約メールをお送りいたします。\n" .
                    "(場合によってキャンセルしていただくことがあります。\n" .
                    "その際にはキャンセルのメールをお送りします。ご了承ください。)\n" .
                    "ご予約内容\n" .
                    "---------------------\n" .
                    "予約コード: " . $data['rescode'] . "\n" .
                    "予約受付日: " . $data['created'] . "\n" .
                    "チェックイン日: " . $data['cin'] . "\n" .
                    "チェックアウト日: " . $data['cout'] . "\n" .
                    "プラン名: " . $plan['plan_name'] . "\n" .
                    "部屋タイプ; " . $roomtype['roomtype_name'] . "\n" .
                    "人数(1部屋あたり): " . $num . "人" . "\n" .
                    "部屋数: " . $data['room_num'] . "部屋" . "\n" .
                    "料金: " . number_format($data['total_price']) . "円" . "\n" .
                    "申込者氏名: " . $data2['name'] . "\n" .
                    "---------------------\n" .
                    "ご予約の確認、キャンセルはこちらから\n" .
                    $cancel_url . "\n";
                log_message('info', $mail_body);
                
                qd_send_mail(
                    'text', 
                    $this->phpsession->get('email'),
                    $mail_subject,
                    $mail_body,
                    $hotel_model->email);
                
                // 管理者宛仮予約Eメール送信
                // 件名,本文はユーザ宛と同じ。宛先だけ違う。
                qd_send_mail(
                    'text', 
                    $hotel_model->email,
                    $mail_subject,
                    $mail_body,
                    $hotel_model->email);
            }
            else if ($resmode == Res_model::RESMODE_REGULAR)
            {
                // ユーザ宛仮予約Eメール送信
                $num = $basic_num + $child1_num + $child2_num + $child3_num + $child4_num;
                if ($userid == 0)
                {
                    $cancel_url = site_url('cancel');
                }
                else
                {
                    $cancel_url = site_url('my/index');
                }
                
                $mail_subject = $hotel_model->hotel_name . ": 予約確認メール";
                $mail_body = 
                    $data2['name'] . " 様\n" . 
                    "この度は、" . $hotel_model->hotel_name . "をご予約いただき、ありがとうございます。\n" . 
                    "以下のご予約を承りました。\n" .
                    "ご予約内容\n" .
                    "---------------------\n" .
                    "予約コード: " . $data['rescode'] . "\n" .
                    "予約受付日: " . $data['created'] . "\n" .
                    "チェックイン日: " . $data['cin'] . "\n" .
                    "チェックアウト日: " . $data['cout'] . "\n" .
                    "プラン名: " . $plan['plan_name'] . "\n" .
                    "部屋タイプ; " . $roomtype['roomtype_name'] . "\n" .
                    "人数(1部屋あたり): " . $num . "人" . "\n" .
                    "部屋数: " . $data['room_num'] . "部屋" . "\n" .
                    "料金: " . number_format($data['total_price']) . "円" . "\n" .
                    "申込者氏名: " . $data2['name'] . "\n" .
                    "---------------------\n" .
                    "ご予約の確認、キャンセルはこちらから\n" .
                    $cancel_url . "\n";
                log_message('info', $mail_body);
                
                qd_send_mail(
                    'text', 
                    $this->phpsession->get('email'),
                    $mail_subject,
                    $mail_body,
                    $hotel_model->email);
                
                // 管理者宛仮予約Eメール送信
                // 件名,本文はユーザ宛と同じ。宛先だけ違う。
                qd_send_mail(
                    'text', 
                    $hotel_model->email,
                    $mail_subject,
                    $mail_body,
                    $hotel_model->email);
            }
            
            return $resid;
        }
        catch (Exception $e)
        {
            $this->db->trans_rollback();
            
            $this->unlock();
            log_message('info', 'doRes ' . $e->getCode());
            return $e->getCode();
        }
    }
    
    /**
     * 仮予約->本予約
     */
    public function confirmRes($resid, $hotel_model)
    {
        $this->db->where('resid', $resid);
        $this->db->where('status >', 0);
        $query = $this->db->get('reservation', 1);
        if ($query->num_rows() <= 0)
        {
            return;
        }
        $data = $query->row_array();
        
        $this->db->where('resid', $resid);
        $this->db->update('reservation', array('status' => 2));
        
        $this->db->where('resid', $resid);
        $query = $this->db->get('resuser', 1);
        if ($query->num_rows() <= 0)
        {
            return;
        }
        $data2 = $query->row_array();
        
        $planid = $data['planid'];
        $roomtypeid = $data['roomtypeid'];
        $this->db->where('planid', $planid);
        $query = $this->db->get('plans', 1);
        if ($query->num_rows() <= 0)
        {
            return - 2;
        }
        $plan = $query->row_array();
        
        $this->db->where('roomtypeid', $roomtypeid);
        $query = $this->db->get('roomtypes', 1);
        if ($query->num_rows() <= 0)
        {
            return -3;
        }
        $roomtype = $query->row_array();
        
        // Eメール送信
        
        $num = $data['basic_num']
             + $data['child1_num']
             + $data['child2_num']
             + $data['child3_num']
             + $data['child4_num'];
        
        if ($data['userid'] == 0)
        {
            $cancel_url = site_url('cancel');
        }
        else
        {
            $cancel_url = site_url('my/index');
        }
        
        $mail_subject = $hotel_model->hotel_name . ": 本予約メール";
        $mail_body = 
            $data2['name'] . " 様\n" . 
            "この度は、" . $hotel_model->hotel_name . "をご予約いただき、ありがとうございます。\n" . 
            "以下のご予約を承りました。\n" .
            "お越しをお待ちいたしております。\n" .
            "ご予約内容\n" .
            "---------------------\n" .
            "予約コード: " . $data['rescode'] . "\n" .
            "予約受付日: " . $data['created'] . "\n" .
            "チェックイン日: " . $data['cin'] . "\n" .
            "チェックアウト日: " . $data['cout'] . "\n" .
            "プラン名: " . $plan['plan_name'] . "\n" .
            "部屋タイプ; " . $roomtype['roomtype_name'] . "\n" .
            "人数(1部屋あたり): " . $num . "人" . "\n" .
            "部屋数: " . $data['room_num'] . "部屋" . "\n" .
            "料金: " . number_format($data['total_price']) . "円" . "\n" .
            "申込者氏名: " . $data2['name'] . "\n" .
            "---------------------\n" .
            "\n" .
            "ご予約の確認、キャンセルはこちらから\n" .
            $cancel_url . "\n";
        
        log_message('info', $mail_subject);
        log_message('info', $mail_body);
        
        /**
         * 本予約メールはユーザにのみ送信する。
         * 管理者は自身で本処理に変更していてわかっているので、
         * 送信しなくて良い。
         */
        qd_send_mail(
            'text', 
            $data2['email'],
            $mail_subject,
            $mail_body,
            $hotel_model->email);
    }
    
    /**
     * 予約キャンセル
     * @param int $resid 予約Id
     * @param int $mode  1:ユーザによるキャンセル
                         2:管理者によるキャンセル(本予約不可)
                         3:本予約取消
     */
    public function cancel($resid, $mode, $hotel_model)
    {
        $this->db->where('resid', $resid);
        $this->db->where('status >', 0);
        $query = $this->db->get('reservation', 1);
        if ($query->num_rows() <= 0)
        {
            return -1;
        }
        $data = $query->row_array();

        $row = $query->row_array();
        $rescode = $row['rescode'];
        $planid = $row['planid'];
        $roomtypeid = $row['roomtypeid'];
        $cin = $row['cin'];
        $cout = $row['cout'];
        $room_num = $row['room_num'];
        $plan_num = $row['plan_num'];
        
        $this->db->where('planid', $planid);
        $query = $this->db->get('plans', 1);
        if ($query->num_rows() <= 0)
        {
            return - 2;
        }
        $plan = $query->row_array();
        
        $this->db->where('roomtypeid', $roomtypeid);
        $query = $this->db->get('roomtypes', 1);
        if ($query->num_rows() <= 0)
        {
            return -3;
        }
        $roomtype = $query->row_array();
        
        $this->db->trans_start();
        try
        {
            $this->lock();
            
            // 空きを元に戻す
            $tmp_y = substr($cin, 0, 4);
            $tmp_m = substr($cin, 5, 2);
            $tmp_d = substr($cin, 8, 2);
            for ($i = 0;;$i++)
            {
                $tmp_date = date('Y-m-d', mktime(0, 0, 0, $tmp_m, $tmp_d + $i, $tmp_y));
                if ($tmp_date >= $cout) {
                    break;
                }
                
                $this->db->where('planid', $planid);
                $this->db->where('day', $tmp_date);
                $query = $this->db->get('vacantplans', 1);
                if ($query->num_rows() > 0)
                {
                    $row = $query->row_array();
                    $vp_inuse = $row['vp_inuse'];
                    $this->db->where('planid', $planid);
                    $this->db->where('day', $tmp_date);
                    $a = array('vp_inuse' => $vp_inuse - $plan_num);
                    $this->db->update('vacantplans', $a);
                }
                else
                {
                }
                
                $this->db->where('roomtypeid', $roomtypeid);
                $this->db->where('day', $tmp_date);
                $query = $this->db->get('vacantrooms', 1);
                if ($query->num_rows() > 0)
                {
                    $row = $query->row_array();
                    $vr_inuse = $row['vr_inuse'];
                    $this->db->where('roomtypeid', $roomtypeid);
                    $this->db->where('day', $tmp_date);
                    $a = array('vr_inuse' => $vr_inuse - $room_num);
                    $this->db->update('vacantrooms', $a);
                }
                else
                {
                }
            }
            
            /**
             * reservationのstatusを0にする。
             * resuserは変更せずに残しておく。
             */
            $this->db->where('resid', $resid);
            $a = array('status' => 0);
            $this->db->update('reservation', $a);
            
        }
        catch (Exception $ex)
        {
            $this->db->trans_rollback();
            $this->unlock();
            return -10;
        }
        
        $this->db->trans_complete();
        $this->unlock();
        
        $this->db->where('resid', $resid);
        $query = $this->db->get('reservation', 1);
        if ($query->num_rows() <= 0)
        {
            return -11;
        }
        $data = $query->row_array();
        
        $this->db->where('resid', $resid);
        $query = $this->db->get('resuser', 1);
        if ($query->num_rows() <= 0)
        {
            return -12;
        }
        $data2 = $query->row_array();
        
        // Eメール送信
        
        $num = $data['basic_num']
             + $data['child1_num']
             + $data['child2_num']
             + $data['child3_num']
             + $data['child4_num'];
        
        $mail_subject = $hotel_model->hotel_name . ": 予約キャンセルメール";
        $mail_body = 
            $data['name'] . " 様\n" . 
            "この度は、" . $hotel_model->hotel_name . "をご利用いただき、ありがとうございます。\n" . 
            "以下のご予約のキャンセルを承りました。\n" .
            "またのご利用をお待ちしております。\n" .
            "ご予約内容\n" .
            "---------------------\n" .
            "予約コード: " . $data['rescode'] . "\n" .
            "予約受付日: " . $data['created'] . "\n" .
            "チェックイン日: " . $data['cin'] . "\n" .
            "チェックアウト日: " . $data['cout'] . "\n" .
            "プラン名: " . $plan['plan_name'] . "\n" .
            "部屋タイプ; " . $roomtype['roomtype_name'] . "\n" .
            "人数(1部屋あたり): " . $num . "人" . "\n" .
            "部屋数: " . $data['room_num'] . "部屋" . "\n" .
            "料金: " . number_format($data['total_price']) . "円" . "\n" .
            "申込者氏名: " . $data2['name'] . "\n" .
            "---------------------\n" .
            
        log_message('info', $mail_subject);
        log_message('info', $mail_body);
        
        /**
         * キャンセルメールの送信
         */
        qd_send_mail(
            'text', 
            $data2['email'],
            $mail_subject,
            $mail_body,
            $hotel_model->email);
        qd_send_mail(
            'text',
            $hotel_model->email,
            $mail_subject,
            $mail_body,
            $hotel_model->email);
    }
    
    /**
     * 一日分の料金を返す
     */
    public function getDayPrice(
        $planid, $day, $room_num,
        $basic_num, $child1_num, $child2_num, $child3_num, $child4_num)
    {
        $tmp = 0;
        
        // $dayのdayTypeを得る
        $dayType = 'A';
        $this->db->where('day', $day);
        $query = $this->db->get('daytype', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $dayType = $row['value'];
        }
        
        // Planid,dayTypeのユーザ別料金を得る
        $this->db->where('planid', $planid);
        $query = $this->db->get('planprice', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
        }
        else
        {
            log_message('error', __LINE__ . 'doRes planprice error');
            die();
        }
        
        if ($dayType == 'A')
        {
            $tmp = $basic_num  * $row['a_basic_price']
                 + $child1_num * $row['a_child1_price']
                 + $child2_num * $row['a_child2_price']
                 + $child3_num * $row['a_child3_price']
                 + $child4_num * $row['a_child4_price'];
        }
        else if ($dayType == 'B')
        {
            $tmp = $basic_num  * $row['b_basic_price']
                 + $child1_num * $row['b_child1_price']
                 + $child2_num * $row['b_child2_price']
                 + $child3_num * $row['b_child3_price']
                 + $child4_num * $row['b_child4_price'];
        }
        else if ($dayType == 'C')
        {
            $tmp = $basic_num  * $row['c_basic_price']
                 + $child1_num * $row['c_child1_price']
                 + $child2_num * $row['c_child2_price']
                 + $child3_num * $row['c_child3_price']
                 + $child4_num * $row['c_child4_price'];
        }
        else if ($dayType == 'D')
        {
            $tmp = $basic_num  * $row['d_basic_price']
                 + $child1_num * $row['d_child1_price']
                 + $child2_num * $row['d_child2_price']
                 + $child3_num * $row['d_child3_price']
                 + $child4_num * $row['d_child4_price'];
        }
        else
        {
            log_message('error', __LINE__ . 'daytype error');
        }
        return $tmp * $room_num;
    }
}
