﻿
namespace IrrlichtNetSwig
{
    public partial class IrrlichtDevice
    {
        private System.Windows.Forms.Control _cont;
        public void BindEventRecieveControl(System.Windows.Forms.Control cont)
        {
            if (_cont != null)
            {
                _cont.MouseMove -= new System.Windows.Forms.MouseEventHandler(button_MouseMove);
                _cont.MouseWheel -= new System.Windows.Forms.MouseEventHandler(button_MouseWheel);
                _cont.MouseUp -= new System.Windows.Forms.MouseEventHandler(button_MouseUp);
                _cont.MouseDown -= new System.Windows.Forms.MouseEventHandler(button_MouseDown);
                _cont.KeyUp -= new System.Windows.Forms.KeyEventHandler(button_KeyUp);
                _cont.KeyDown -= new System.Windows.Forms.KeyEventHandler(button_KeyDown);
            }
            _cont = cont;
            _cont.MouseMove += new System.Windows.Forms.MouseEventHandler(button_MouseMove);
            _cont.MouseWheel += new System.Windows.Forms.MouseEventHandler(button_MouseWheel);
            _cont.MouseUp += new System.Windows.Forms.MouseEventHandler(button_MouseUp);
            _cont.MouseDown += new System.Windows.Forms.MouseEventHandler(button_MouseDown);
            _cont.KeyUp  += new System.Windows.Forms.KeyEventHandler(button_KeyUp);
            _cont.KeyDown += new System.Windows.Forms.KeyEventHandler(button_KeyDown);
        }

        void SetMouseInputEvent(EMOUSE_INPUT_EVENT mouseEvent, int x, int y, float wheel)
        {
            SEvent ev = new SEvent();
	        ev.EventType = EEVENT_TYPE.EET_MOUSE_INPUT_EVENT;
	        ev.MouseInput.Event = mouseEvent;
	        ev.MouseInput.X = x;	//client position
	        ev.MouseInput.Y = y; //client position
	        ev.MouseInput.Wheel = wheel;
	        postEventFromUser(ev);
        }

        void SetKeyInputEvent(char chara, EKEY_CODE key, bool pressedDown, bool shift, bool control)
        {
            SEvent ev = new SEvent();
	        ev.EventType = EEVENT_TYPE.EET_KEY_INPUT_EVENT;
	        ev.KeyInput.Char = chara;
	        ev.KeyInput.Key = key;
	        ev.KeyInput.PressedDown = pressedDown;
	        ev.KeyInput.Shift = shift;
	        ev.KeyInput.Control = control;
	        postEventFromUser(ev);
        }

        void button_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            SetMouseInputEvent( EMOUSE_INPUT_EVENT.EMIE_MOUSE_MOVED, e.X, e.Y, 0);
        }

        void button_MouseWheel(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            SetMouseInputEvent( EMOUSE_INPUT_EVENT.EMIE_MOUSE_WHEEL, e.X, e.Y, e.Delta);
        }

        void button_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            EMOUSE_INPUT_EVENT mouseEvent = EMOUSE_INPUT_EVENT.EMIE_MOUSE_MOVED;
            if (e.Button == System.Windows.Forms.MouseButtons.Left)
            {
                mouseEvent = EMOUSE_INPUT_EVENT.EMIE_LMOUSE_LEFT_UP;
            }
            else if (e.Button == System.Windows.Forms.MouseButtons.Middle)
            {
                mouseEvent = EMOUSE_INPUT_EVENT.EMIE_MMOUSE_LEFT_UP;
            }
            else if (e.Button == System.Windows.Forms.MouseButtons.Right)
            {
                mouseEvent = EMOUSE_INPUT_EVENT.EMIE_RMOUSE_LEFT_UP;
            }
            SetMouseInputEvent( mouseEvent, e.X, e.Y, 0);
        }

        void button_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            EMOUSE_INPUT_EVENT mouseEvent = EMOUSE_INPUT_EVENT.EMIE_MOUSE_MOVED;
            if (e.Button == System.Windows.Forms.MouseButtons.Left)
            {
                mouseEvent = EMOUSE_INPUT_EVENT.EMIE_LMOUSE_PRESSED_DOWN;
            }
            else if (e.Button == System.Windows.Forms.MouseButtons.Middle)
            {
                mouseEvent = EMOUSE_INPUT_EVENT.EMIE_MMOUSE_PRESSED_DOWN;
            }
            else if (e.Button == System.Windows.Forms.MouseButtons.Right)
            {
                mouseEvent = EMOUSE_INPUT_EVENT.EMIE_RMOUSE_PRESSED_DOWN;
            }
            SetMouseInputEvent( mouseEvent, e.X, e.Y, 0);
        }

        void button_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
        {
            char keyChar = IrrlichtNet.ToAsciiFromKeyCode((uint) e.KeyData);
            SetKeyInputEvent(keyChar, (EKEY_CODE)e.KeyData, false, e.Shift, e.Control);
        }

        void button_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
        {
            char keyChar = IrrlichtNet.ToAsciiFromKeyCode((uint)e.KeyData);
            SetKeyInputEvent(keyChar, (EKEY_CODE)e.KeyData, true, e.Shift, e.Control);
        }

    }
}
