namespace IrrlichtNetSwig
{
    public partial class arrayMeshBuffer
    {
        public IMeshBuffer this[uint index]
        {
            get
            {
                if (index < 0 || size() < index)
                {
                    throw new System.IndexOutOfRangeException();
                }
                return getValue(index);
            }
            set
            {
                if (index < 0 || size() < index)
                {
                    throw new System.IndexOutOfRangeException();
                }
                setValue(index, value);
            }
        }
        public void set_pointer(IMeshBuffer[] pointer)
        {
            set_pointer((arrayMeshBuffer)pointer, (uint)pointer.Length);
        }
        public static implicit operator arrayMeshBuffer(IMeshBuffer[] other)
        {
            var arr = new arrayMeshBuffer((uint)other.Length);
            for (uint i = 0; i < other.Length; i++)
            {
                arr.push_back(other[i]);
            }
            return arr;
        }
        public IMeshBuffer[] ToArray()
        {
            var arr = new IMeshBuffer[size()];
            for (uint i = 0; i < size(); i++)
            {
                arr[i] = this.getValue(i);
            }
            return arr;
        }
    }
}