#ifndef ISCENE_NODE_FOR_INHERITANCE
#define ISCENE_NODE_FOR_INHERITANCE

#include "ISceneNode.h"

class ISceneNode_ForInheritance : public irr::scene::ISceneNode
{
public:
	ISceneNode_ForInheritance(ISceneNode* parent, ISceneManager* mgr, s32 id=-1,
			const core::vector3df& position = core::vector3df(0,0,0),
			const core::vector3df& rotation = core::vector3df(0,0,0),
			const core::vector3df& scale = core::vector3df(1.0f, 1.0f, 1.0f))
		: irr::scene::ISceneNode(parent, mgr, id, position, rotation, scale)
	{
	}
	virtual void OnRegisterSceneNode()
	{
		ISceneNode::OnRegisterSceneNode();
	}
	virtual void OnAnimate(u32 timeMs)
	{
		ISceneNode::OnAnimate(timeMs);
	}
	virtual void render() = 0;
	virtual const c8* getName() const
	{
		return ISceneNode::getName();
	}
	virtual void setName(const c8* name)
	{
		ISceneNode::setName(name);
	}
	virtual void setName(const core::stringc& name)
	{
		ISceneNode::setName(name);
	}
	virtual const core::aabbox3d<f32>& getBoundingBox() const=0;
	virtual const core::aabbox3d<f32> getTransformedBoundingBox() const
	{
		return ISceneNode::getTransformedBoundingBox();
	}
	virtual const core::matrix4& getAbsoluteTransformation() const
	{
		return ISceneNode::getAbsoluteTransformation();
	}
	virtual core::matrix4 getRelativeTransformation() const
	{
		return ISceneNode::getRelativeTransformation();
	}
	virtual bool isVisible() const
	{
		return ISceneNode::isVisible();
	}
	virtual void setVisible(bool isVisible)
	{
		ISceneNode::setVisible(isVisible);
	}
	virtual s32 getID() const
	{
		return ISceneNode::getID();
	}
	virtual void setID(s32 id)
	{
		ISceneNode::setID(id);
	}
	virtual void addChild(ISceneNode* child)
	{
		ISceneNode::addChild(child);
	}
	virtual bool removeChild(ISceneNode* child)
	{
		return ISceneNode::removeChild(child);
	}
	virtual void removeAll()
	{
		ISceneNode::removeAll();
	}
	virtual void remove()
	{
		ISceneNode::remove();
	}
	virtual void addAnimator(ISceneNodeAnimator* animator)
	{
		ISceneNode::addAnimator(animator);
	}
	virtual void removeAnimator(ISceneNodeAnimator* animator)
	{
		ISceneNode::removeAnimator(animator);
	}
	virtual void removeAnimators()
	{
		ISceneNode::removeAnimators();
	}
	virtual video::SMaterial& getMaterial(u32 num)
	{
		return ISceneNode::getMaterial(num);
	}
	virtual u32 getMaterialCount() const
	{
		return ISceneNode::getMaterialCount();
	}
	virtual const core::vector3df& getScale() const
	{
		return ISceneNode::getScale();
	}
	virtual void setScale(const core::vector3df& scale)
	{
		ISceneNode::setScale(scale);
	}
	virtual const core::vector3df& getRotation() const
	{
		return ISceneNode::getRotation();
	}
	virtual void setRotation(const core::vector3df& rotation)
	{
		ISceneNode::setRotation(rotation);
	}
	virtual const core::vector3df& getPosition() const
	{
		return ISceneNode::getPosition();
	}
	virtual void setPosition(const core::vector3df& newpos)
	{
		ISceneNode::setPosition(newpos);
	}
	virtual core::vector3df getAbsolutePosition() const
	{
		return ISceneNode::getAbsolutePosition();
	}
	virtual void setDebugDataVisible(s32 state)
	{
		ISceneNode::setDebugDataVisible(state);
	}
	virtual void setParent(ISceneNode* newParent)
	{
		ISceneNode::setParent(newParent);
	}
	virtual ITriangleSelector* getTriangleSelector() const
	{
		return ISceneNode::getTriangleSelector();
	}
	virtual void setTriangleSelector(ITriangleSelector* selector)
	{
		ISceneNode::setTriangleSelector(selector);
	}
	virtual void updateAbsolutePosition()
	{
		ISceneNode::updateAbsolutePosition();
	}
	virtual ESCENE_NODE_TYPE getType() const
	{
		return ISceneNode::getType();
	}
	virtual void serializeAttributes(io::IAttributes* outobj, io::SAttributeReadWriteOptions* options=0) const
	{
		ISceneNode::serializeAttributes(outobj, options);
	}
	virtual void deserializeAttributes(io::IAttributes* inobj, io::SAttributeReadWriteOptions* options=0)
	{
		ISceneNode::deserializeAttributes(inobj, options);
	}
	virtual ISceneNode* clone(ISceneNode* newParent=0, ISceneManager* newManager=0)
	{
		return ISceneNode::clone(newParent, newManager);
	}

};
#endif
