namespace IrrlichtNetSwig
{
    public partial class arrayMesh
    {
        public IMesh this[uint index]
        {
            get
            {
                if (index < 0 || size() < index)
                {
                    throw new System.IndexOutOfRangeException();
                }
                return getValue(index);
            }
            set
            {
                if (index < 0 || size() < index)
                {
                    throw new System.IndexOutOfRangeException();
                }
                setValue(index, value);
            }
        }
        public void set_pointer(IMesh[] pointer)
        {
            set_pointer((arrayMesh)pointer, (uint)pointer.Length);
        }
        public static implicit operator arrayMesh(IMesh[] other)
        {
            var arr = new arrayMesh((uint)other.Length);
            for (uint i = 0; i < other.Length; i++)
            {
                arr.push_back(other[i]);
            }
            return arr;
        }
        public IMesh[] ToArray()
        {
            var arr = new IMesh[size()];
            for (uint i = 0; i < size(); i++)
            {
                arr[i] = this.getValue(i);
            }
            return arr;
        }
    }
}