﻿using System;
using System.Collections.Generic;
using System.Text;
using IrrlichtNetSwig;

namespace FormWindow
{
    class Program
    {
        static void Main(string[] args)
        {
            /*
            So now that we have some window, we can create an Irrlicht device
            inside of it. We use Irrlicht createEx() function for this. We only
            need the handle (HWND) to that window, set it as windowsID parameter
            and start up the engine as usual. That's it.
            */
            // create irrlicht device in the button window
            Form1 form = new Form1();


            SIrrlichtCreationParameters param = new SIrrlichtCreationParameters();
            //param.WindowId = reinterpret_cast<void*>(hIrrlichtWindow); // hColorButton
            param.DriverType = E_DRIVER_TYPE.EDT_OPENGL;
            param.ButtonHandle = (int)form.GetButtonHandle();

            IrrlichtDevice device = IrrlichtNet.createDeviceEx(param);

            // setup a simple 3d scene

            ISceneManager smgr = device.getSceneManager();
            IVideoDriver driver = device.getVideoDriver();

            ICameraSceneNode cam = smgr.addCameraSceneNode();
            cam.setTarget(new vector3df(0, 0, 0));

            ISceneNodeAnimator anim =
                smgr.createFlyCircleAnimator(new vector3df(0, 15, 0), 30.0f);
            cam.addAnimator(anim);
            anim.drop();

            ISceneNode cube = smgr.addCubeSceneNode(20);

            cube.setMaterialTexture(0, driver.getTexture("../../media/wall.bmp"));
            cube.setMaterialTexture(1, driver.getTexture("../../media/water.jpg"));
            cube.setMaterialFlag(E_MATERIAL_FLAG.EMF_LIGHTING, false);
            cube.setMaterialType(E_MATERIAL_TYPE.EMT_REFLECTION_2_LAYER);

            smgr.addSkyBoxSceneNode(
                driver.getTexture("../../media/irrlicht2_up.jpg"),
                driver.getTexture("../../media/irrlicht2_dn.jpg"),
                driver.getTexture("../../media/irrlicht2_lf.jpg"),
                driver.getTexture("../../media/irrlicht2_rt.jpg"),
                driver.getTexture("../../media/irrlicht2_ft.jpg"),
                driver.getTexture("../../media/irrlicht2_bk.jpg"));

            // show and execute dialog
            form.Show();

            // do message queue

            /*
            Now the only thing missing is the drawing loop using
            IrrlichtDevice::run(). We do this as usual. But instead of this, there
            is another possibility: You can also simply use your own message loop
            using GetMessage, DispatchMessage and whatever. Calling
            Device.run() will cause Irrlicht to dispatch messages internally too.
            You need not call Device.run() if you want to do your own message
            dispatching loop, but Irrlicht will not be able to fetch user input
            then and you have to do it on your own using the window messages,
            DirectInput, or whatever.
            */
            int lastFPS = 0;
            while (device.run() && form.IsDisposed==false)
            {
                driver.beginScene(true, true, new SColor());
                smgr.drawAll();
                driver.endScene();

                int fps = driver.getFPS();
                if (lastFPS != fps)
                {
                    string str = "Irrlicht Engine - Render to Texture and Specular Highlights example";
                    str += " FPS:";
                    str += fps;

                    //device.setWindowCaption(str);
                    form.Text = str;
                    lastFPS = fps;
                }
            }

            /*
            The alternative, own message dispatching loop without Device.run()
            would look like this:
            */

            /*MSG msg;
            while (true)
            {
                if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
                {
                    TranslateMessage(&msg);
                    DispatchMessage(&msg);

                    if (msg.message == WM_QUIT)
                        break;
                }

                // advance virtual time
                device.getTimer().tick();

                // draw engine picture
                driver.beginScene(true, true, 0);
                smgr.drawAll();
                driver.endScene();
            }*/

            device.closeDevice();
            //device.drop();

            return;
        }
    }
}
