#ifndef IREAD_FILE_FOR_INHERITANCE_H
#define IREAD_FILE_FOR_INHERITANCE_H

#include "IReadFile.h"

namespace irr
{
namespace io
{

	//! Interface providing read acess to a file.
	class IReadFile_ForInheritance : public IReadFile
	{
	public:
		s32 read(void* buffer, u32 sizeToRead)
		{
			irr::core::array<unsigned char> arr;
			arr.set_pointer((unsigned char*)buffer, sizeToRead);
			return read(&arr, sizeToRead);
		}
		
		virtual s32 read(irr::core::array<unsigned char>* buffer, u32 sizeToRead) = 0;

		virtual bool seek(long finalPos, bool relativeMovement = false) = 0;

		virtual long getSize() const = 0;

		virtual long getPos() const = 0;

		virtual const c8* getFileName() const = 0;
	};
}
}

#endif  //IREAD_FILE_FOR_INHERITANCE_H