// 
// DefineCustomArray(arrayCTest(z^), CTest(C++^), CTest(C#^));
// CustomArray(CTest* TestArray, arrayCTest(z^), CTest(C++^), CTest(C#^);



%ignore CCustomArray::CCustomArray(T* pointer);
template <class T>
class CCustomArray
{
	T* m_pointer;
	bool m_isOwnMemory;
public:
	CCustomArray(T* pointer){m_pointer = pointer;m_isOwnMemory=false;}
	CCustomArray(int elementCount){m_pointer = new T[elementCount];m_isOwnMemory=true;}
	~CCustomArray()
	{
		if(m_isOwnMemory){delete[] m_pointer;m_isOwnMemory=false;}
	}
	T* getItem(int index){return &m_pointer[index];}
	void setItem(int index, T* data){m_pointer[index] = *data;}
};
%{
template <class T>
class CCustomArray
{
	T* m_pointer;
	bool m_isOwnMemory;
public:
	CCustomArray(T* pointer){m_pointer = pointer;m_isOwnMemory=false;}
	CCustomArray(int elementCount){m_pointer = new T[elementCount];m_isOwnMemory=true;}
	~CCustomArray()
	{
		if(m_isOwnMemory){delete[] m_pointer;m_isOwnMemory=false;}
	}
	T* getItem(int index){return &m_pointer[index];}
	void setItem(int index, T* data){m_pointer[index] = *data;}
};
%}


%define CustomArray(type, arrayName, itemType, itemCsType)

%typemap(out) type "$result = new CCustomArray<itemType>($1);";
%typemap(ctype)  type "void*";
%typemap(imtype) type "IntPtr"
%typemap(cstype) type "arrayName"
%typemap(csvarout, excode=SWIGEXCODE2) type %{
    get {
        IntPtr ret = $imcall;$excode
        return new arrayName(ret, true);
    }
%}
%typemap(csvarin, excode=SWIGEXCODE2) type %{
    set {
		IntPtr AAA = itemCsType.getCPtr(value[0]).Handle;
		$imcall;$excode
    }
%}

%typemap(csin) type "AAA"
%enddef

%define DefineCustomArray(arrayName, itemType, itemCsType)
%typemap(cscode) CCustomArray<itemType>
%{
	public itemCsType this[int index]
	{
		get{return getItem(index);}
		set{setItem(index, value);}
	}
%}


%template(arrayName) CCustomArray<itemType>;
%enddef

