﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace AddFilesToCSProj
{
    class Program
    {
        static void Main(string[] args)
        {
            if (args.Length < 2)
            {
                Console.Error.WriteLine("Error: Excepted 2 args.");
                Console.Error.WriteLine("Usage: AddFilesToCSProj.exe <csproj file> <C# files directory> [<C# files directory> ..]");
                Environment.Exit(1);
            }

            var csprojFile = args[0];
            csprojFile = System.IO.Path.GetFullPath(csprojFile);

            var dirs = new string[args.Length - 1];
            Array.Copy(args, 1, dirs, 0, dirs.Length);

            if (System.IO.File.Exists(csprojFile) == false)
            {
                Console.Error.WriteLine("Error: File {0} is not found.", csprojFile);
                Environment.Exit(1);
            }
            foreach (var dir in dirs)
            {
                if (System.IO.Directory.Exists(dir) == false)
                {
                    Console.Error.WriteLine("Error: Directory {0} is not found.", dir);
                    Environment.Exit(1);
                }
            }

            
            //csprojファイルのディレクトリ
            var csprojDir = System.IO.Path.GetDirectoryName(csprojFile);
            csprojDir += "\\";

            //csファイルを相対パスでリストに
            var csFiles = new List<string>();
            foreach (var dir in dirs)
            {
                var files = System.IO.Directory.GetFiles(dir, "*.cs", System.IO.SearchOption.TopDirectoryOnly);
                foreach (var file in files)
                {
                    var csFileFelativePath = GetRelativePath(System.IO.Path.GetFullPath(file), csprojDir);
                    csFiles.Add(csFileFelativePath);
                }
            }

            var xDoc = new XmlDocument();
            XmlNamespaceManager nsmgr1 = new XmlNamespaceManager(xDoc.NameTable);
            nsmgr1.AddNamespace("smpl", "http://schemas.microsoft.com/developer/msbuild/2003");
            
            xDoc.Load(csprojFile);
            XmlNode tempNode = xDoc.SelectSingleNode("/smpl:Project/smpl:ItemGroup/smpl:Compile", nsmgr1);
            XmlNode filesRootNode = tempNode.ParentNode;

            //古いリンクファイルを削除
            XmlNodeList linkNodes = filesRootNode.SelectNodes("smpl:Compile/smpl:Link", nsmgr1);
            foreach (XmlNode linkNode in linkNodes)
            {
                filesRootNode.RemoveChild(linkNode.ParentNode);
            }

            //新たなリンクファイルを追加
            foreach (var file in csFiles)
            {
                XmlNode newNode = GetCompileNode(file, xDoc, filesRootNode.NamespaceURI);
                filesRootNode.AppendChild(newNode);
            }

            xDoc.Save(csprojFile);
        }

        private static XmlNode GetCompileNode(string file, XmlDocument xDoc, string namespaceURI)
        {
            XmlElement compileElement = xDoc.CreateElement("Compile", namespaceURI);
            XmlElement linkElement = xDoc.CreateElement("Link", namespaceURI);
            XmlAttribute includeAttribute = xDoc.CreateAttribute("Include");
            compileElement.Attributes.Append(includeAttribute);
            compileElement.AppendChild(linkElement);

            includeAttribute.Value = file;
            linkElement.InnerText = "generated\\" + System.IO.Path.GetFileName(file);

            return compileElement;
        }

        private static string GetRelativePath(string csFilePath, string csprojDir)
        {
            if (csprojDir.EndsWith("\\") == false) { csprojDir += "\\"; }

            Uri u1 = new Uri(csprojDir);
            Uri u2 = new Uri(u1, csFilePath);
            string relativePath = u1.MakeRelativeUri(u2).ToString();
            //URLデコードして、'/'を'\'に変更する
            relativePath = System.Web.HttpUtility.UrlDecode(relativePath).Replace('/', '\\');
            return relativePath;
        }
    }
}
