﻿using System;
using System.Collections.Generic;
using System.Text;

namespace CreatePropertyCS
{
    class PropInfoCollection : List<PropInfo>
    {
        internal PropInfoCollection DeepCopy()
        {
            PropInfoCollection collection = new PropInfoCollection();
            foreach (var item in this)
            {
                collection.Add(item.DeepCopy());
            }
            return collection;
        }

        internal PropInfoCollection Marge(PropInfoCollection propInfoCollection)
        {
            var list = DeepCopy();
            foreach (var prop in propInfoCollection)
            {
                PropInfo propInfo = list.Search(prop.Name);
                if (propInfo != null)
                {
                    list.Remove(propInfo);
                    propInfo = propInfo.Marge(prop);
                    list.Add(propInfo);
                }
                else
                {
                    list.Add(prop.DeepCopy());
                }
            }
            return list;
        }

        private PropInfo Search(string name)
        {
            return this.Find(delegate(PropInfo info) { return info.Name == name; });
        }
    }
}
