//
// Inclusion of standard header file
//
#include <algorithm>

//
// Inclusion of local header file
//
#include "fatal_error.hpp"
#include "islibfunc.hpp"

namespace islib
  {
    //
    // Definition of constructor
    //
    fatal_error::fatal_error
      (
        char const *message_
      )
      throw
        (
        )
      :
      message ( message_ )
      {
        class local
          {
          public:
            local
              (
                char const *message__
              )
              {
                assert_ ( message__, "islib::fatal_error::fatal_error: `message__' has failed." );
              }

            ~local
              (
              )
              throw
                (
                )
              {
              }
          }
        a_local ( message_ );
      }

    //
    // Definition of constructor
    //
    fatal_error::fatal_error
      (
        this_type const &the_other
      )
      throw
        (
        )
      :
      message ( the_other.message )
      {
      }

    //
    // Definition of destructor
    //
    fatal_error::~fatal_error
      (
      )
      throw
        (
        )
      {
      }

    //
    // Definition of operator
    //
    fatal_error::this_type &
    fatal_error::operator =
      (
        this_type const &right_value
      )
      throw
        (
        )
      {
        this_type temporary ( right_value );

        this->swap ( temporary );

        return *this;
      }

    //
    // Definition of method
    //
    char const *
    fatal_error::what
      (
      )
      const
      throw
        (
        )
      {
        char const *message_ = 0;

        class local
          {
          public:
            local
              (
                char const * const &message___
              ):
              message__ ( message___ )
              {
              }

            ~local
              (
              )
              throw
                (
                )
              {
                assert_ ( this->message__, "islib::fatal_error::what: `this->message' has failed." );
              }

          private:
            char const * const &message__;
          }
        a_local ( message );

        message_ = this->message;

        return message_;
      }

    //
    // Definition of method
    //
    void
    fatal_error::swap
      (
        this_type &the_other
      )
      throw
        (
        )
      {
        std::swap ( this->message, the_other.message );
      }
  }

//
// End of file
//
