//
// Inclusion of standard header file
//
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <string>

//
// Inclusion of local header file
//
#include "islibfunc.hpp"
#include "program.hpp"

namespace islib
  {
    //
    // Declaration of static function
    //
    static void print_message_implement ( bool, std::string const & );

    //
    // Definition of function
    //
    std::string
    get_try_help_message
      (
        std::string const &program_name
      )
      {
        class local
          {
          public:
            local
              (
                std::string const &program_name_
              )
              {
                islib::throw_if ( std::invalid_argument ( "islib::get_try_help_message: program_name_.empty ()" ), program_name_.empty () );
              }
        
            ~local
              (
              )
              throw
                (
                )
              {
              }
          }
        local_ ( program_name );

        std::stringstream try_help_message_stream;

        try_help_message_stream << "Try `" << program_name << " --help' for more information.";

        return try_help_message_stream.str ();
      }

    //
    // Definition of function
    //
    void
    print_message
      (
        std::string const &message
      )
      {
        class local
          {
          public:
            local
              (
                std::string const &message_
              )
              {
                islib::throw_if ( std::invalid_argument ( "islib::print_message: message_.empty ()" ), message_.empty () );
              }
        
            ~local
              (
              )
              throw
                (
                )
              {
              }
          }
        local_ ( message );

        print_message_implement ( false, message );
      }

    //
    // Definition of function
    //
    void
    print_error_message
      (
        std::string const &error_message
      )
      {
        class local
          {
          public:
            local
              (
                std::string const &error_message_
              )
              {
                islib::throw_if ( std::invalid_argument ( "islib::print_error_message: error_message_.empty ()" ), error_message_.empty () );
              }
        
            ~local
              (
              )
              throw
                (
                )
              {
              }
          }
        local_ ( error_message );

        print_message_implement ( true, error_message );
      }

    //
    // Definition of static function
    //
    void
    print_message_implement
      (
        bool const error_flag,
        std::string const &message
      )
      {
        class local
          {
          public:
            local
              (
                std::string const &message_
              )
              {
                islib::throw_if ( std::invalid_argument ( "islib::print_message_implement: message_.empty ()" ), message_.empty () );
              }
        
            ~local
              (
              )
              throw
                (
                )
              {
              }
          }
        local_ ( message );

        std::stringstream message_stream;

        message_stream << message << "\n";

        ( error_flag? std::cerr: std::cout ) << message_stream.str();

        ( error_flag? std::cerr: std::cout ).flush();
      }
  }

//
// End of file
//
