//
// Inclusion of standard header file
//
#include <string>

//
// Inclusion of local header file
//
#include "trim.hpp"

namespace islib
  {
    //
    // Definition of function
    //
    std::string
    trim
      (
        std::string const &string,
        std::string const &characters_to_avoid
      )
      {
        std::size_t const index_of_beginning_of_trimmed_string = string.find_first_not_of ( characters_to_avoid );
        std::size_t const index_of_end_of_trimmed_string = string.find_last_not_of ( characters_to_avoid );

        return std::string ( string, index_of_beginning_of_trimmed_string, index_of_end_of_trimmed_string - index_of_beginning_of_trimmed_string + 1 );
      }
  }

//
// End of file
//
