//
// Inclusion of standard header file
//
#include <fstream>
#include <stdexcept>

//
// Inclusion of system header file
//
#include <sys/stat.h>
#include <sys/types.h>

//
// Inclusion of library header file
//
#include <boost/filesystem/fstream.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/path.hpp>

//
// Inclusion of local header file
//
#include "binary_compare.hpp"
#include "islibfunc.hpp"

namespace islib
  {
    //
    // Definition of function
    //
    // Return value: 0:   file path 1 and file path 2 equal to each other.
    //               < 0: file path 1 is less than file path 2.
    //               > 0: file path 1 is greater than file path 2.
    //
    int
    binary_compare
      (
        boost::filesystem::path const &file_path_1,
        boost::filesystem::path const &file_path_2
      )
      {
        class local
          {
          public:
            local
              (
                boost::filesystem::path const &file_path_1_,
                boost::filesystem::path const &file_path_2_
              )
              {
                throw_if ( std::invalid_argument ( "islib::binary_compare: file_path_1_.empty ()" ), file_path_1_.empty () );
                throw_if ( std::invalid_argument ( "islib::binary_compare: file_path_2_.empty ()" ), file_path_2_.empty () );
                throw_if ( std::invalid_argument ( "islib::binary_compare: !boost::filesystem::is_regular ( file_path_1_ )" ), !boost::filesystem::is_regular ( file_path_1_ ) );
                throw_if ( std::invalid_argument ( "islib::binary_compare: !boost::filesystem::is_regular ( file_path_2_ )" ), !boost::filesystem::is_regular ( file_path_2_ ) );
              }

            ~local
              ()
              throw
                ()
              {
              }
          }
        a_local ( file_path_1, file_path_2 );

        if ( file_path_1 == file_path_2 )
          return 0;

        struct stat file_status_1;
        struct stat file_status_2;

        islib::stat_ ( file_path_1, &file_status_1 );
        islib::stat_ ( file_path_2, &file_status_2 );

        if ( file_status_1.st_dev == file_status_2.st_dev && file_status_1.st_ino == file_status_2.st_ino )
          return 0;

        if ( file_status_1.st_size != file_status_2.st_size )
          return static_cast < int > ( file_status_1.st_size ) - static_cast < int > ( file_status_2.st_size );

        boost::filesystem::ifstream file_stream_1 ( file_path_1 );
        boost::filesystem::ifstream file_stream_2 ( file_path_2 );
        off_t number_of_read_bytes = 0;

        while ( true )
          {
            if ( number_of_read_bytes == file_status_1.st_size )
              break;

            throw_if ( std::runtime_error ( "islib::binary_compare: !file_stream_1 || !file_stream_2" ), !file_stream_1 || !file_stream_2 );

            char character_1;
            char character_2;

            file_stream_1.get ( character_1 );
            file_stream_2.get ( character_2 );

            if ( character_1 != character_2 )
              return static_cast < int > ( static_cast < unsigned int > ( character_1 ) ) - static_cast < int > ( static_cast < unsigned int > ( character_2 ) );

            ++number_of_read_bytes;
          }

        return 0;
      }
  }

//
// End of file
//
