#ifndef DEFINES_ISLIB_FATAL_ERROR_HPP

#define DEFINES_ISLIB_FATAL_ERROR_HPP

namespace islib
  {
    //
    // Definition of class
    //
    class fatal_error
      {
      public:
        //
        // Definition of type
        //
        typedef fatal_error this_type;

        //
        // Declaration of constructor
        //
        explicit fatal_error ( char const * ) throw ();
        fatal_error ( this_type const & ) throw ();

        //
        // Declaration of destructor
        //
        virtual ~fatal_error () throw ();

        //
        // Declaration of operator
        //
        this_type &operator = ( this_type const & ) throw ();

        //
        // Declaration of method
        //
        virtual char const *what () const throw ();
        virtual void swap ( this_type & ) throw ();

      private:
        //
        // Declaration of data member
        //
        char const *message;
      };
  }

#endif // DEFINES_ISLIB_FATAL_ERROR_HPP

//
// End of file
//
