#ifndef DEFINES_ISLIB_ISLIBFUNC_HPP

#define DEFINES_ISLIB_ISLIBFUNC_HPP

//
// Inclusion of standard header file
//
#include <cassert>
#include <cstddef>
#include <ctime>
#include <iostream>
#include <stdexcept>
#include <string>
#include <utility>

//
// Inclusion of system header file
//
#include <sys/stat.h>
#include <sys/types.h>
#include <signal.h>
#include <utime.h>

//
// Inclusion of library header file
//
#include <boost/filesystem/path.hpp>

namespace islib
  {
    //
    // Declaration of function
    //
    void link_ ( boost::filesystem::path const &, boost::filesystem::path const & );
    void localtime_r_ ( std::time_t const *, struct std::tm * );
    void mkdir_ ( boost::filesystem::path const &, mode_t );
    void raise_ ( int );
    void raise_fatal ( int );
    void sigaction_ ( int, struct sigaction const *, struct sigaction * );
    void sigaction_fatal ( int, struct sigaction const *, struct sigaction * );
    void sigfillset_ ( sigset_t * );
    void sigfillset_fatal ( sigset_t * );
    void sigprocmask_ ( int, sigset_t const *, sigset_t * );
    void sigprocmask_fatal ( int, sigset_t const *, sigset_t * );
    std::time_t time ();
    void stat_ ( boost::filesystem::path const &, struct stat * );
    void unlink_ ( boost::filesystem::path const & );
    void utime_ ( boost::filesystem::path const &, struct utimbuf const * );
    void write_ ( int, void const *, std::size_t );
    void write_assert ( int, void const *, std::size_t );

    //
    // Declaration of template function
    //
    template < typename Value_Type, typename Permissible_Error_Type > bool equals_to ( Value_Type const &, Value_Type const &, Permissible_Error_Type const & );
    template < typename Value_Type, typename Permissible_Error_Type > bool does_not_equal_to ( Value_Type const &, Value_Type const &, Permissible_Error_Type const & );
    template < typename Value_Type, typename Permissible_Error_Type > bool is_less_than ( Value_Type const &, Value_Type const &, Permissible_Error_Type const & );
    template < typename Value_Type, typename Permissible_Error_Type > bool is_greater_than ( Value_Type const &, Value_Type const &, Permissible_Error_Type const & );
    template < typename Value_Type, typename Permissible_Error_Type > bool is_less_than_or_equals_to ( Value_Type const &, Value_Type const &, Permissible_Error_Type const & );
    template < typename Value_Type, typename Permissible_Error_Type > bool is_greater_than_or_equals_to ( Value_Type const &, Value_Type const &, Permissible_Error_Type const & );

    //
    // Definition of inline function
    //
    inline
    void
    assert_
      (
        bool const expression,
        std::string const &cause
      )
      {

#ifndef NDEBUG

        if ( !expression )
          std::cerr << cause << std::endl;

#endif // NDEBUG

        assert ( expression );
      }

    //
    // Definition of template function
    //
    template
      <
        typename Exception_Type
      >
    void
    throw_
      (
        Exception_Type const &exception
      )
      {

#ifndef DO_NOT_USE_THROW_

        throw exception;

#else // DO_NOT_USE_THROW_

        assert_ ( false, exception.what () );

#endif // DO_NOT_USE_THROW_

      }

    //
    // Definition of template function
    //
    template
      <
        typename Exception_Type
      >
    void
    throw_if
      (
        Exception_Type const &exception,
        bool const predicate
      )
      {

#ifndef DO_NOT_USE_THROW_IF

        if ( predicate )
          throw exception;

#else // DO_NOT_USE_THROW_IF
        
        if ( predicate )
          assert_ ( false, exception.what () );

#endif // DO_NOT_USE_THROW_IF

      }

    //
    // Definition of template function
    //
    template
      <
        typename Container_Type,
        typename Value_Type
      >
    void
    insert
      (
        Container_Type &container,
        Value_Type const &value
      )
      {
        std::pair < typename Container_Type::iterator, bool > const insert_return_value = container.insert ( value );

        throw_if ( std::logic_error ( "islib::insert: !insert_return_value.second" ), !insert_return_value.second );
      }
  }

#endif // DEFINES_ISLIB_ISLIBFUNC_HPP

//
// End of file
//
