//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_internal.hpp
 * @brief		iris unit test ` t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_internal_HPP_A5BD9FBB_B57A_4c1d_B205_0ADB7798DBF9_
#define INCG_IRIS_iutest_internal_HPP_A5BD9FBB_B57A_4c1d_B205_0ADB7798DBF9_

//======================================================================
// include
#include "iutest_internal_defs.h"
#include "iutest_result_reporter.hpp"

//======================================================================
// define
/**
 * @internal
 * @brief	eXg쐬}N
*/
#define IUTEST_TEST_CLASS_NAME_(testcase_, testname_)	iu_##testcase_##_##testname_##_Test

/**
 * @internal
 * @brief	eXgNX`}N
*/
#define IUTEST_TEST_(testcase_, testname_, parent_class_, type_id_)							\
	class IUTEST_TEST_CLASS_NAME_(testcase_, testname_) : public parent_class_ {			\
		public:	IUTEST_TEST_CLASS_NAME_(testcase_, testname_)(void) {}						\
		protected: virtual void Body(void);													\
	};																						\
	iutest::detail::TestInstance<IUTEST_TEST_CLASS_NAME_(testcase_, testname_)>				\
	s_##testcase_##_##testname_( #testcase_, #testname_										\
		, type_id_, parent_class_::SetUpTestCase, parent_class_::TearDownTestCase);			\
	void IUTEST_TEST_CLASS_NAME_(testcase_, testname_)::Body(void)

/**
 * @internal
 * @brief	ASSERTION bZ[W
*/
#define IUTEST_MESSAGE_AT(file_, line_, msg_, result_type_)	iutest::AssertionHelper(file_, line_, msg_, result_type_) = iutest::AssertionHelper::Fixed()
#define IUTEST_MESSAGE(msg_, result_type_)					IUTEST_MESSAGE_AT(__FILE__, __LINE__, msg_, result_type_)

/**
 * @internal
 * @brief	ASSERT bZ[W
*/
#define IUTEST_ASSERT_FAILURE(msg)					IUTEST_ASSERT_FAILURE_AT(msg, __FILE__, __LINE__)

#define IUTEST_ASSERT_FAILURE_AT(msg, file, line)	return IUTEST_MESSAGE_AT(file, line, msg, iutest::TestPartResult::kFatalFailure)

/**
 * @internal
 * @brief	EXPECT bZ[W
*/
#define IUTEST_EXPECT_FAILURE(msg)					IUTEST_EXPECT_FAILURE_AT(msg, __FILE__, __LINE__)

#define IUTEST_EXPECT_FAILURE_AT(msg, file, line)	IUTEST_MESSAGE_AT(file, line, msg, iutest::TestPartResult::kNotFatalFailure)

/**
 * @internal
 * @brief	INFORM bZ[W
*/
#define IUTEST_INFORM_FAILURE(msg)					IUTEST_INFORM_FAILURE_AT(msg, __FILE__, __LINE__)

#define IUTEST_INFORM_FAILURE_AT(msg, file, line)	IUTEST_MESSAGE_AT(file, line, msg, iutest::TestPartResult::kWarning)


#ifndef IUTEST_MAKE_ASSERTIONRESULT_
#  define IUTEST_MAKE_ASSERTIONRESULT_(ar)	ar
#endif

/**
 * @internal
 * @biref	r؃}N
*/
#if IUTEST_HAS_RVALUE_REFS
#define IUTEST_TEST_ASSERT_(expression, on_failure)	\
	IUTEST_AMBIGUOUS_ELSE_BLOCKER_					\
	if( const iutest::AssertionResult&& iutest_ar = IUTEST_MAKE_ASSERTIONRESULT_(expression) )	\
		;											\
	else											\
		on_failure(iutest_ar.message())
#else
#define IUTEST_TEST_ASSERT_(expression, on_failure)	\
	IUTEST_AMBIGUOUS_ELSE_BLOCKER_					\
	if( const iutest::AssertionResult iutest_ar = IUTEST_MAKE_ASSERTIONRESULT_(expression) )	\
		;											\
	else											\
		on_failure(iutest_ar.message())
#endif

#if IUTEST_HAS_EXCEPTIONS
/**
 * @internal
 * @brief	throw eXgp}N
*/
#define IUTEST_TEST_THROW_(statement, expected_exception, on_failure)		\
	IUTEST_AMBIGUOUS_ELSE_BLOCKER_											\
	if( const char* msg = "" ) {											\
		try {																\
			IUTEST_SUPPRESS_UNREACHABLE_CODE_WARNING((void)statement);		\
			msg = "\nExpected: " #statement " throws an exception of type "	\
				  #expected_exception ".\n  Actual: it throws nothing.";	\
			goto IUTEST_PP_CAT(iutest_label_throw, __LINE__);				\
		} catch( expected_exception const& ) {								\
		} catch( ... ) {													\
			msg = "\nExpected: " #statement " throws an exception of type "	\
          #expected_exception ".\n  Actual: it throws a different type.";	\
			goto IUTEST_PP_CAT(iutest_label_throw, __LINE__);				\
		}																	\
	} else																	\
		IUTEST_PP_CAT(iutest_label_throw, __LINE__):						\
		on_failure(msg)

/**
 * @internal
 * @brief	any throw eXgp}N
*/
#define IUTEST_TEST_ANY_THROW_(statement, on_failure)						\
	IUTEST_AMBIGUOUS_ELSE_BLOCKER_											\
	if( iutest::detail::AlwaysTrue() ) {									\
		try {																\
			(void)statement;												\
			goto IUTEST_PP_CAT(iutest_label_anythrow, __LINE__);			\
		} catch( ... ) {													\
		}																	\
	} else																	\
		IUTEST_PP_CAT(iutest_label_anythrow, __LINE__):						\
		on_failure("\nExpected: " #statement " throws an exception.\n  Actual: it doesn's throws.")

/**
 * @internal
 * @brief	no throw eXgp}N
*/
#define IUTEST_TEST_NO_THROW_(statement, on_failure)						\
	IUTEST_AMBIGUOUS_ELSE_BLOCKER_											\
	if( iutest::detail::AlwaysTrue() ) {									\
		try {																\
			(void)statement;												\
		} catch( ... ) {													\
			goto IUTEST_PP_CAT(iutest_label_nothrow, __LINE__);				\
		}																	\
	} else																	\
		IUTEST_PP_CAT(iutest_label_nothrow, __LINE__):						\
		on_failure("\nExpected: " #statement " doesn't throw an exception.\n  Actual: it throws.")

#endif

#define IUTEST_TEST_BOOLEAN_(expression, text, actual, expected, on_failure)	\
	IUTEST_AMBIGUOUS_ELSE_BLOCKER_												\
	if( const iutest::AssertionResult iutest_ar = iutest::AssertionResult(expression ? true : false) )	\
		;																		\
	else																		\
		on_failure(iutest::internal::GetBooleanAssertionFailureMessage(			\
			iutest_ar, text, #actual, #expected).c_str() )

#include "../iutest_pred.hpp"

/**
 * @internal
 * @brief	IȎs
*/
#define IIUT_SUCCEED()						IUTEST_MESSAGE("Succeeded. ", iutest::TestPartResult::kSuccess)
#define IIUT_FAIL()							IUTEST_ASSERT_FAILURE("Failed. ")
#define IIUT_ADD_FAILURE()					IUTEST_EXPECT_FAILURE("Failed. ")
#define IIUT_ADD_FAILURE_AT(file_, line_)	IUTEST_EXPECT_FAILURE_AT("Failed. ", file_, line_)

/**
 * @internal
 * @brief	bZ[WMO
*/
#define IIUT_SCOPED_MESSAGE(msg_)			\
	const iutest::AssertionHelper::ScopedMessage IUTEST_PP_CAT(scoped_message_, __LINE__) = iutest::detail::iuCodeMessage(__FILE__, __LINE__, msg_)


/**
 * @internal
 * @brief	eXg}N
 * @{
*/
#define	IUTEST_TEST_EQ(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iutest::internal::EqHelper<IUTEST_IS_NULLLITERAL(v1)>::Compare, v1, v2, on_failure )
#define	IUTEST_TEST_NE(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iutest::internal::NeHelper<IUTEST_IS_NULLLITERAL(v1)>::Compare, v1, v2, on_failure )
//#define	IUTEST_TEST_NE(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iutest::internal::CmpHelperNE, v1, v2, on_failure )
#define	IUTEST_TEST_LE(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iutest::internal::CmpHelperLE, v1, v2, on_failure )
#define	IUTEST_TEST_LT(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iutest::internal::CmpHelperLT, v1, v2, on_failure )
#define	IUTEST_TEST_GE(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iutest::internal::CmpHelperGE, v1, v2, on_failure )
#define	IUTEST_TEST_GT(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iutest::internal::CmpHelperGT, v1, v2, on_failure )

#define IUTEST_TEST_TRUE(expr, text, on_failure)		IUTEST_TEST_BOOLEAN_( expr, text, false, true, on_failure)
#define IUTEST_TEST_FALSE(expr, text, on_failure)		IUTEST_TEST_BOOLEAN_( !(expr), text, true, false, on_failure)

#define IUTEST_TEST_FLOAT_EQ(v1, v2, on_failure)		IUTEST_PRED_FORMAT2_( iutest::internal::CmpHelperFloatingPointEQ<float> , v1, v2, on_failure )
#define IUTEST_TEST_DOUBLE_EQ(v1, v2, on_failure)		IUTEST_PRED_FORMAT2_( iutest::internal::CmpHelperFloatingPointEQ<double>, v1, v2, on_failure )

#define IUTEST_TEST_NEAR(v1, v2, abs_v, on_failure)		IUTEST_PRED_FORMAT3_( iutest::internal::CmpHelperNear, v1, v2, abs_v, on_failure )

#define	IUTEST_TEST_STREQ(v1, v2, on_failure)			IUTEST_PRED_FORMAT2_( iutest::internal::CmpHelperSTREQ, v1, v2, on_failure )
#define	IUTEST_TEST_STRNE(v1, v2, on_failure)			IUTEST_PRED_FORMAT2_( iutest::internal::CmpHelperSTRNE, v1, v2, on_failure )
#define	IUTEST_TEST_STRCASEEQ(v1, v2, on_failure)		IUTEST_PRED_FORMAT2_( iutest::internal::CmpHelperSTRCASEEQ, v1, v2, on_failure )
#define	IUTEST_TEST_STRCASENE(v1, v2, on_failure)		IUTEST_PRED_FORMAT2_( iutest::internal::CmpHelperSTRCASENE, v1, v2, on_failure )

#define IUTEST_TEST_HRESULT_SUCCEEDED(hr, on_failure)	IUTEST_PRED_FORMAT1_( iutest::internal::IsHRESULTSuccess, hr, on_failure )
#define IUTEST_TEST_HRESULT_FAILED(hr, on_failure)		IUTEST_PRED_FORMAT1_( iutest::internal::IsHRESULTFailure, hr, on_failure )

#define IUTEST_TEST_NULL(v, on_failure)					IUTEST_PRED_FORMAT1_( iutest::internal::CmpHelperNull, v, on_failure )
#define IUTEST_TEST_NOTNULL(v, on_failure)				IUTEST_PRED_FORMAT1_( iutest::internal::CmpHelperNotNull, v, on_failure )

#define IUTEST_TEST_SAME(v1, v2, on_failure)			IUTEST_PRED_FORMAT2_( iutest::internal::CmpHelperSame, v1, v2, on_failure )

#define IUTEST_TEST_NO_FATAL_FAILURE_(statement, on_failure)				\
	IUTEST_AMBIGUOUS_ELSE_BLOCKER_											\
	if( iutest::detail::AlwaysTrue() ) {									\
		iutest::detail::NewTestPartResultCheckHelper::Reporter<				\
			iutest::detail::NewTestPartResultCheckHelper::CondNe<			\
				iutest::TestPartResult::kSuccess> >	iutest_failure_checker;	\
		IUTEST_SUPPRESS_UNREACHABLE_CODE_WARNING(statement);				\
		if( iutest_failure_checker.count() > 0 ) {							\
			goto IUTEST_PP_CAT(iutest_label_test_no_fatalfailure_, __LINE__);		\
		}																	\
	} else																	\
		IUTEST_PP_CAT(iutest_label_test_no_fatalfailure_, __LINE__):		\
		on_failure("\nExpected: " #statement " doesn't generate new failure.\n  Actual: it does.")
/**
 * @}
*/

/**
 * @}
*/

#endif
