//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_spi.hpp
 * @brief		iris unit test spi Ήp t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_spi_HPP_
#define INCG_IRIS_iutest_spi_HPP_

//======================================================================
// include
#include "iutest.hpp"

#ifdef _MSC_VER
// /ZI IvV __LINE__  __LINE__Var+N(N͔ԍ) ɂȂRpCG[ɂȂ邽߂̑Ή
#  ifndef __LINE__Var
#    define __LINE__Var	0
#  endif
#endif

//======================================================================
// define
/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	Fatal Failure mFeXg
*/
#define IUTEST_ASSERT_FATAL_FAILURE(statement, substr)		IUTEST_TEST_FATAL_FAILURE_(statement, #statement, substr, IUTEST_ASSERT_FAILURE)

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	Non Fatal Failure mFeXg
*/
#define IUTEST_ASSERT_NONFATAL_FAILURE(statement, substr)	IUTEST_TEST_NONFATAL_FAILURE_(statement, #statement, substr, IUTEST_ASSERT_FAILURE)

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	Fatal Failure mFeXg
*/
#define IUTEST_EXPECT_FATAL_FAILURE(statement, substr)		IUTEST_TEST_FATAL_FAILURE_(statement, #statement, substr, IUTEST_EXPECT_FAILURE)

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	Non Fatal Failure mFeXg
*/
#define IUTEST_EXPECT_NONFATAL_FAILURE(statement, substr)	IUTEST_TEST_NONFATAL_FAILURE_(statement, #statement, substr, IUTEST_EXPECT_FAILURE)


/**
 * @private
 * @{
*/

#define IUTEST_TEST_FATAL_FAILURE_(statement, text, substr, on_failure)			\
	IUTEST_AMBIGUOUS_ELSE_BLOCKER_											\
	if( iutest::detail::AlwaysTrue() ) {									\
		class IUTestFatalFailureStatement { public: static void Execute() { statement; } }; \
		iutest::detail::NewTestPartResultCheckHelper::Reporter<				\
			iutest::detail::NewTestPartResultCheckHelper::CondEq<			\
				iutest::TestPartResult::kFatalFailure>						\
				, iutest::detail::FakeTestPartResultReporter > iutest_failure_checker;	\
		IUTestFatalFailureStatement::Execute();								\
		if( iutest_failure_checker.count() == 0 ) {							\
			goto IUTEST_PP_CAT(iutest_label_test_fatalfailure_, __LINE__);	\
		}																	\
	} else																	\
		IUTEST_PP_CAT(iutest_label_test_fatalfailure_, __LINE__):			\
		on_failure("\nExpected: " text " generate new fatal failure.\n  Actual: it does.") << substr

#define IUTEST_TEST_NONFATAL_FAILURE_(statement, text, substr, on_failure)	\
	IUTEST_AMBIGUOUS_ELSE_BLOCKER_											\
	if( iutest::detail::AlwaysTrue() ) {									\
		class IUTestFatalFailureStatement { public: static void Execute() { statement; } }; \
		iutest::detail::NewTestPartResultCheckHelper::Reporter<				\
			iutest::detail::NewTestPartResultCheckHelper::CondEq<			\
				iutest::TestPartResult::kNotFatalFailure>					\
				, iutest::detail::FakeTestPartResultReporter > iutest_failure_checker;	\
		IUTestFatalFailureStatement::Execute();								\
		if( iutest_failure_checker.count() == 0 ) {							\
			goto IUTEST_PP_CAT(iutest_label_test_fatalfailure_, __LINE__);	\
		}																	\
	} else																	\
		IUTEST_PP_CAT(iutest_label_test_fatalfailure_, __LINE__):			\
		on_failure("\nExpected: " text " generate new non fatal failure.\n  Actual: it does.") << substr

//		IUTEST_SUPPRESS_UNREACHABLE_CODE_WARNING(statement);

/**
 * @}
*/

namespace iutest {
namespace detail
{

//======================================================================
// class
/**
 * @brief	SPI p|[^[
*/
class FakeTestPartResultReporter : public TestPartResultReporterInterface
{
public:
	virtual ~FakeTestPartResultReporter(void) {}
	virtual void ReportTestPartResult(const TestPartResult& result)
	{
		IUTEST_UNUSED_VAR(result);
		//Test::CommitFailed(result);
	}
};

}
}

#endif
