//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_printers.hpp
 * @brief		iris unit test print o̓wp[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_printers_HPP_A6A321C9_9279_4336_8167_058C59EC0FD0_
#define INCG_IRIS_iutest_printers_HPP_A6A321C9_9279_4336_8167_058C59EC0FD0_

//======================================================================
// include
#include "iutest_defs.h"
#include "internal/iutest_string.h"

namespace iutest
{

//======================================================================
// declare
template<typename T>
std::string PrintToString(const T& v);

namespace detail
{

//======================================================================
// declare
template<typename T>class iuUniversalPrinter;

//======================================================================
// function

/** @private */
template<typename T>
inline void	UniversalPrint(const T& value, std::ostream* os)
{
	iuUniversalPrinter<T>::Print(value, os);
}

/**
 * @brief	ftHgϊ֐
*/
template<typename T>
inline void DefaultPrintTo(IsContainerHelper::yes_t
						   , false_type
						   , const T& container, std::ostream* os)
{
	const size_t kMaxCount = kValues::MaxPrintContainerCount;
	size_t count = 0;
	*os << "{";
	for( typename T::const_iterator it=container.begin(), end=container.end(); it != end; ++it, ++count)
	{
		if( count > 0 )
		{
			*os << ",";
			if( count == kMaxCount )
			{
				*os << "... ";
				break;
			}
		}
		*os << " ";
		UniversalPrint(*it, os);
	}
	if( count > 0 ) *os << " ";
	*os << "}";
}
template<typename T>
inline void DefaultPrintTo(IsContainerHelper::no_t
						   , false_type
						   , const T& value, std::ostream* os)
{
	*os << value;
}
// char or unsigned char ̎ɁA 0  NULL ɂȂȂ悤ɏC
inline void DefaultPrintTo(IsContainerHelper::no_t
						   , false_type
						   , const char& value, std::ostream* os)
{
	if( value == 0 ) *os << "\\0";
	else *os << "\'" << value << "\'";
}
inline void DefaultPrintTo(IsContainerHelper::no_t
						   , false_type
						   , const unsigned char& value, std::ostream* os)
{
	// lŏo͂
	*os << static_cast<unsigned int>(value);
}

template<typename T>
inline void DefaultPtrPrintTo(T* ptr, std::ostream* os, typename enable_if_t< is_convertible<T*, const void*> >::type*& = enabler::value)
{
	*os << ptr;
}
template<typename T>
inline void DefaultPtrPrintTo(T* ptr, std::ostream* os, typename disable_if_t< is_convertible<T*, const void*> >::type*& = enabler::value)
{
	*os << reinterpret_cast<const void*>(reinterpret_cast<type_least_t<8>::UInt>(ptr));
}
template<typename T>
inline void DefaultPrintTo(IsContainerHelper::no_t
						   , true_type
						   , T* ptr, std::ostream* os)
{
	if( ptr == NULL )
	{
		*os << kStrings::Null;
	}
	else
	{
		DefaultPtrPrintTo<T>(ptr, os);
	}
}

/**
 * @brief	ϊ֐
*/
template<typename T>
inline void PrintTo(const T& value, std::ostream* os)	{ DefaultPrintTo(IsContainerHelper::IsContainer<T>(0), is_pointer<T>(), value, os); }
inline void PrintTo(bool b, std::ostream* os)			{ *os << (b ? "true" : "false"); }
inline void PrintTo(const char* c, std::ostream* os)	{ *os << c; }
inline void PrintTo(char* c, std::ostream* os)			{ *os << c; }
inline void PrintTo(std::string& str, std::ostream* os)	{ *os << str.c_str(); }
template<typename T1, typename T2>
inline void PrintTo(const std::pair<T1, T2>& value, std::ostream* os)
{
	*os << "(";
	iuUniversalPrinter<T1>::Print(value.first, os);
	*os << ", ";
	iuUniversalPrinter<T2>::Print(value.second, os);
	*os << ")";
}

#if IUTEST_HAS_TUPLE

template<typename T, int I, int SIZE>
inline void PrintTupleElemTo(const T& t, std::ostream* os, typename detail::enable_if<I == 0, void>::type*& = detail::enabler::value)
{
	IUTEST_UNUSED_VAR(t);
	IUTEST_UNUSED_VAR(os);
}
template<typename T, int I, int SIZE>
inline void PrintTupleElemTo(const T& t, std::ostream* os, typename detail::enable_if<I == 1, void>::type*& = detail::enabler::value)
{
	PrintTo(tuple::get<SIZE-I>(t), os);
}
template<typename T, int I, int SIZE>
inline void PrintTupleElemTo(const T& t, std::ostream* os, typename detail::enable_if<(I&(~1)) != 0, void>::type*& = detail::enabler::value)
{
	PrintTo(tuple::get<SIZE-I>(t), os);
	*os << ", ";
	PrintTupleElemTo<T, I-1, SIZE>(t, os);
}

template<typename T>
inline void PrintTupleTo(const T& t, std::ostream* os)
{
	*os << "(";
	PrintTupleElemTo<T, tuple::tuple_size<T>::value, tuple::tuple_size<T>::value>(t, os);
	*os << ")";
}

#if IUTEST_HAS_VARIADIC_TEMPLATES

template<typename ...Args>
inline void PrintTo(const tuple::tuple<Args...>& t, std::ostream* os)
{
	PrintTupleTo(t, os);
}

#else

inline void PrintTo(const tuple::tuple<>& t, std::ostream* os) { PrintTupleTo(t, os); }
template<typename A1>
inline void PrintTo(const tuple::tuple<A1>& t, std::ostream* os) { PrintTupleTo(t, os); }
template<typename A1, typename A2>
inline void PrintTo(const tuple::tuple<A1, A2>& t, std::ostream* os) { PrintTupleTo(t, os); }
template<typename A1, typename A2, typename A3>
inline void PrintTo(const tuple::tuple<A1, A2, A3>& t, std::ostream* os) { PrintTupleTo(t, os); }
template<typename A1, typename A2, typename A3, typename A4>
inline void PrintTo(const tuple::tuple<A1, A2, A3, A4>& t, std::ostream* os) { PrintTupleTo(t, os); }
template<typename A1, typename A2, typename A3, typename A4, typename A5>
inline void PrintTo(const tuple::tuple<A1, A2, A3, A4, A5>& t, std::ostream* os) { PrintTupleTo(t, os); }
template<typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
inline void PrintTo(const tuple::tuple<A1, A2, A3, A4, A5, A6>& t, std::ostream* os) { PrintTupleTo(t, os); }
template<typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
inline void PrintTo(const tuple::tuple<A1, A2, A3, A4, A5, A6, A7>& t, std::ostream* os) { PrintTupleTo(t, os); }
template<typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
inline void PrintTo(const tuple::tuple<A1, A2, A3, A4, A5, A6, A7, A8>& t, std::ostream* os) { PrintTupleTo(t, os); }
template<typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
inline void PrintTo(const tuple::tuple<A1, A2, A3, A4, A5, A6, A7, A8, A9>& t, std::ostream* os) { PrintTupleTo(t, os); }

#endif

#endif

//======================================================================
// class

/** @private */
template<typename T>
class iuUniversalPrinter
{
public:
	static void Print(const T& value, std::ostream* os)
	{
		PrintTo(value, os);
	}
};

/** @private */
template<typename T, size_t SIZE>
class iuUniversalPrinter<T[SIZE]>
{
public:
	static void Print(const T (&a)[SIZE], std::ostream* os)
	{
		UniversalPrintArray(a, SIZE, os);
	}
};

//======================================================================
// function

/** @private */
template<typename T>
inline void	IUTEST_ATTRIBUTE_UNUSED_ UniversalTersePrint(const T& value, std::ostream* os)
{
	UniversalPrint(value, os);
}

inline void IUTEST_ATTRIBUTE_UNUSED_ UniversalTersePrint(const char* str, std::ostream* os)
{
	if( str == NULL ) *os << kStrings::Null;
	else UniversalPrint(std::string(str), os);
}
inline void IUTEST_ATTRIBUTE_UNUSED_ UniversalTersePrint(char* str, std::ostream* os)
{
	UniversalTersePrint(static_cast<const char*>(str), os);
}

/**
 * @brief	z̏o
*/
template<typename T>
inline void PrintRawArrayTo(const T* a, size_t cnt, std::ostream* os)
{
	iuUniversalPrinter<T>(a[0], os);
	for( size_t i=1; i < cnt; ++i )
	{
		*os << ", ";
		iuUniversalPrinter<T>(a[i], os);
	}
}

/**
 * @brief	z̏o
*/
template<typename T>
inline void IUTEST_ATTRIBUTE_UNUSED_ UniversalPrintArray(const T* begin, size_t N, std::ostream* os)
{
	if( N == 0 ) *os << "{}";
	else
	{
		*os << "{";
		const size_t kThreshold = kValues::PrintArrayThreshold;
		const size_t kChunksize = kValues::PrintArrayChunksize;
		if( N <= kThreshold )
		{
			PrintRawArrayTo(begin, N, os);
		}
		else
		{
			PrintRawArrayTo(begin, kChunksize, os);
			*os << ", ..., ";
			PrintRawArrayTo(begin + N - kChunksize, kChunksize, os);
		}
		*os << "}";
	}
}
/**
 * @brief	z̏o
*/
inline void IUTEST_ATTRIBUTE_UNUSED_ UniversalPrintArray(const char* begin, size_t N, std::ostream* os)
{
	IUTEST_UNUSED_VAR(N);
	UniversalTersePrint(begin, os);
}

/**
 * @}
*/

}	// end of namespace detail

//======================================================================
// function

/**
 * @brief	
*/
template<typename T>
inline std::string PrintToString(const T& v)
{
	detail::iuStringStream::type strm;
#if 0
	strm << v;
#else
	detail::UniversalTersePrint(v, &strm);
#endif
	return strm.str();
}

#if IUTEST_HAS_VARIADIC_TEMPLATES
/**
 * @brief	
*/
template<typename T>
inline std::string PrintToStrings(const char* separate, const T& v)
{
	IUTEST_UNUSED_VAR(separate);
	return PrintToString(v);
}
/**
 * @brief	
*/
template<typename T, typename ...Args>
inline std::string PrintToStrings(const char* separate, const T& v, Args... args)
{
	std::string str = PrintToString(v);
	str += separate;
	str += PrintToStrings(separate, args...);
	return str;
}
#endif

}	// end of namespace iutest

#endif
