//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_lib_c.h
 * @brief		iris unit test libc Ή t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_lib_C_H_193F89F4_8C8B_405e_A7CC_A0338271D103_
#define INCG_IRIS_iutest_lib_C_H_193F89F4_8C8B_405e_A7CC_A0338271D103_

//======================================================================
// include
#include "iutest_config_c.h"
#include <stddef.h>
#include <limits.h>

#if IUTEST_C_HAS_STDARG

#include <stdarg.h>

#else

#endif

#if IUTEST_C_HAS_LIBC

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define iu_memset	memset
#define iu_memcpy	memcpy

#else

static IUTEST_ATTRIBUTE_UNUSED_ void * iu_memcpy(void *buf1, const void *buf2, size_t n)
{
	char *dst = (char *)buf1;
	char *src = (char *)buf2;
	size_t i =0;
	for( i=0; i < n; ++i, ++dst, ++src )
	{
		*dst = *src;
	}
	return buf1;
}

static IUTEST_ATTRIBUTE_UNUSED_ void * iu_memset(void *buf, int ch, size_t n)
{
	char *p = (char *)buf;
	size_t i =0;
	for( i=0; i < n; ++i, ++p )
	{
		*p = (char)ch;
	}
	return buf;
}

//static IUTEST_ATTRIBUTE_UNUSED_ void * memcpy(void *buf1, const void *buf2, size_t n)
//{
//	return iu_memcpy(buf1, buf2, n);
//}

#endif

#if IUTEST_C_HAS_MALLOC

#define iu_malloc	malloc

#else

static IUTEST_ATTRIBUTE_UNUSED_ void * iu_malloc(size_t n) { (void)n; return NULL; }

#endif

#endif
