//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_option_message_c.h
 * @brief		iris unit test p IvVbZ[W t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_option_message_C_H_B8037C4F_8F86_4c64_B1FB_01F9018076A0_
#define INCG_IRIS_iutest_option_message_C_H_B8037C4F_8F86_4c64_B1FB_01F9018076A0_

//======================================================================
// include
#include "iutest_console_c.h"

/**
 * @brief	o[W̏o
*/
static int iuTest_ShowVersion(void)
{
	iuConsole_Output("iutest version %x.%x.%x.%x\n"
			, IUTEST_C_MAJORVER, IUTEST_C_MINORVER, IUTEST_C_BUILD, IUTEST_C_REVISION);
	return 0;
}

/**
 * @brief	wv̏o
*/
static int iuTest_ShowHelp(void)
{
	const char *readme = 
		"--------------------------------------------------\n"
		"Name\n"
		"    iutest_c - iris unit test framework\n"
		"--------------------------------------------------\n"
		"Command Line Options\n"
		"\n"
		"    --help, -h                      : generate help message.\n"
		//"    --iutest_output=xml[:path]      : path of xml report.\n"
		"    --iutest_list_tests             : list up tests.\n"
		"    --iutest_color=<yes|no|auto>    : console color enable.\n"
		"    --iutest_filter=<filter>        : Select the test run.\n"
		"    --iutest_shuffle                : do shuffle test.\n"
		"    --iutest_random_seed=<seed>     : set random seed.\n"
		"    --iutest_also_run_disabled_tests: run disabled tests.\n"
		"    --iutest_break_on_failure[=0|1] : When that failed to break.\n"
		"    --iutest_print_time=<0|1>       : Setting the display of elapsed time.\n"
		"    --iutest_repeat=<count>         : Set the number of repetitions of the test.\n"
		"    --version, -v                   : show iutest version.\n"
		"\n"
		"--------------------------------------------------\n"
		"License\n"
		"\n"
		"    Copyright (c) 2011-2012 Takazumi-Shirayanagi,\n"
		"    All rights reserved.\n"
		"\n"
		"    The new(modified) BSD License is applied to this software, see LICENSE\n"
		"\n"
		;
	iuConsole_ColorOutput(PRINT_CYAN, readme);
	return 0;
}

/**
 * @brief	wv̏o
*/
static int iuTest_ShowHelpAndSorry(void)
{
	iuTest_ShowHelp();
	iuConsole_ColorOutput(PRINT_YELLOW, "sorry. Is not supported in a wide-character string.\n");
	return 1;
}

/**
 * @brief	@\̏o
*/
static int iuTest_ShowFeature(void)
{
#define SHOW_MACRO(macro)	iuConsole_Output("#define %s  %s\n", #macro, IUTEST_PP_TOSTRING(macro))

#ifdef IUTEST_C_NO_FLOATINGPOINT
	SHOW_MACRO(IUTEST_C_NO_FLOATINGPOINT);
#endif
#ifdef IUTEST_C_NO_WCHAR_T
	SHOW_MACRO(IUTEST_C_NO_WCHAR_T);
#endif
#ifdef IUTEST_C_NO_STDARG
	SHOW_MACRO(IUTEST_C_NO_STDARG);
#endif
#ifdef IUTEST_C_NO_LIBC
	SHOW_MACRO(IUTEST_C_NO_LIBC);
#endif
#ifdef IUTEST_C_NO_MALLOC
	SHOW_MACRO(IUTEST_C_NO_MALLOC);
#endif

	SHOW_MACRO(IUTEST_C_HAS_FLOATINGPOINT);
	SHOW_MACRO(IUTEST_C_HAS_WCHAR_T);
	SHOW_MACRO(IUTEST_C_HAS_STDARG);
	SHOW_MACRO(IUTEST_C_HAS_LIBC);
	SHOW_MACRO(IUTEST_C_HAS_MALLOC);

#if !IUTEST_C_HAS_MALLOC
	SHOW_MACRO(IUTEST_C_TESTPARTRESULT_POOL_COUNT);
	SHOW_MACRO(IUTEST_C_TESTPROPERTY_POOL_COUNT);
	SHOW_MACRO(IUTEST_C_LISTENER_POOL_COUNT);
#endif

#undef SHOW_MACRO
	return 0;
}

#endif
