//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_port_c.h
 * @brief		iris unit portable t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_os_c_H_6D5DBD9D_C830_4415_957D_D38D69AEE35B_
#define INCG_IRIS_iutest_os_c_H_6D5DBD9D_C830_4415_957D_D38D69AEE35B_

//======================================================================
// include
#include "iutest_compiler_c.h"

//======================================================================
// function

IUTEST_PRAGMA_CRT_SECURE_WARN_DISABLE_BEGIN()

static IUTEST_ATTRIBUTE_UNUSED_ const char * iuTestOS_GetEnv(const char* name)
{
#if defined(IUTEST_OS_WINDOWS_MOBILE) || defined(IUTEST_C_NO_GETENV)
	IUTEST_UNUSED_VAR(name);
	return NULL;
#elif defined(__BORLANDC__) || defined(__SunOS_5_8) || defined(__SunOS_5_9)
	const char* env = getenv(name);
	return (env != NULL && env[0] != '\0') ? env : NULL;
#else
	return getenv(name);
#endif
}

IUTEST_PRAGMA_CRT_SECURE_WARN_DISABLE_END()

#if defined(IUTEST_OS_WINDOWS)

/**
 * @brief	HRESULT ̃G[擾
 * @param [in]	hr	= G[l
 * @return	
*/
static IUTEST_ATTRIBUTE_UNUSED_ char* iuTestOS_AllocHResultString(HRESULT hr)
{
#if defined(IUTEST_OS_WINDOWS_MOBILE)
	return NULL;
#else
	LPSTR buf = NULL;
	FormatMessageA(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		hr,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ftHg [U[
		(LPSTR)&buf,
		0,
		NULL );
	return buf;
#endif
}

static IUTEST_ATTRIBUTE_UNUSED_ void iuTestOS_FreeHResultString(char* ptr)
{
	LocalFree(ptr);
}

#endif

#endif
