//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_random_c.h
 * @brief		iris unit test  ` t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_random_c_H_89F260D7_9145_4b50_A8F0_B7A2696121B6_
#define INCG_IRIS_iutest_random_c_H_89F260D7_9145_4b50_A8F0_B7A2696121B6_

//======================================================================
// include
#include "iutest_time_c.h"

//======================================================================
// struct
typedef struct iuRandomContext_t
{
	unsigned int v1, v2, v3, v4;
} iuRandomContext;

//======================================================================
// define
#define iuRandomContext_ctor()	{ 0, 0, 0, 0 }

//======================================================================
// function

/**
 * @brief	V[h̐ݒ
*/
static void iuTestRandom_SetSeed(iuRandomContext* context, unsigned int seed)
{
	context->v4 = seed;
	context->v3 = 1812433253 * ((context->v4 ^ (context->v4>>30)) + 1);
	context->v2 = 1812433253 * ((context->v3 ^ (context->v3>>30)) + 2);
	context->v1 = 1812433253 * ((context->v2 ^ (context->v2>>30)) + 3);
}

/**
 * @brief	̎擾
*/
static unsigned int iuTestRandom_Gen(iuRandomContext* context)
{
	const unsigned int t = (context->v1 ^ (context->v1<<11));
	context->v1 = context->v2;
	context->v2 = context->v3;
	context->v3 = context->v4;
	context->v4 = (context->v4 ^ (context->v4>>19)) ^ (t ^ (t>>8));
	return context->v4;
}


#endif
