//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_regex_c.h
 * @brief		iris unit test p regex t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_regex_C_H_1575CB44_189A_4248_B305_DB4882E3BFC2_
#define INCG_IRIS_iutest_regex_C_H_1575CB44_189A_4248_B305_DB4882E3BFC2_

//======================================================================
// include

#if defined(_MSC_VER) && defined(__STDC_WANT_SECURE_LIB__) && __STDC_WANT_SECURE_LIB__
#  pragma warning (push)
#  pragma warning (disable:4996)
#endif

static iuBOOL	iuTestRegex_MatchImpl(const char* begin, const char* end, const char* src);

static iuBOOL	iuTestRegex_Match(const char* regex, const char* src)
{
	const char* tp = regex;

	while( *tp != '\0' )
	{
		const char* end = tp;
		while( *end != '\0' && *end != ':' ) ++end;

		{
			iuBOOL match = TRUE;
			const char* end2 = tp;
			while( end2 != end )
			{
				++end2;
				while( *end2 != '-' && end2 != end ) ++end2;
				if( *tp == '-' )
				{
					if( iuTestRegex_MatchImpl(tp+1, end2, src) ) match = FALSE;
				}
				else
				{
					if( !iuTestRegex_MatchImpl(tp, end2, src) ) match = FALSE;
				}
				tp = end2;
			}
			if( match ) return TRUE;
		}
		tp = end;
	}
	return FALSE;
}

static iuBOOL	iuTestRegex_MatchImpl(const char* begin, const char* end, const char* src)
{
	const char* tp = begin;
	if( *tp == '\0' ) return FALSE;
	while( tp != end )
	{
		if( *tp == '*' )	// Cӂ̕Ƀ}b`
		{
			++tp;
			while( *tp == '*' ) ++tp;
			if( tp == end ) return TRUE;

			{
				const char nc = *tp;
				if( nc == '\0' ) return TRUE;

				for( ; ; )
				{
					while( *src != nc )
					{
						++src;
						if( *src == '\0' ) return FALSE;
					}
					// Â
					if( iuTestRegex_MatchImpl(tp+1, end, ++src) ) return TRUE;
				}
			}
		}
		else if( *tp == '?' )	// Cӂ̈ꕶɃ}b`
		{
			if( *src == '\0' ) return FALSE;
		}
		else	// w蕶Ƀ}b`
		{
			if( *tp != *src ) return FALSE;
		}
		++tp;
		++src;
	}
	if( *src != '\0' ) return FALSE;
	return TRUE;
}

#if defined(_MSC_VER) && defined(__STDC_WANT_SECURE_LIB__) && __STDC_WANT_SECURE_LIB__
#  pragma warning (pop)
#endif

#endif
