//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_c.h
 * @brief		iris unit test t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
 * 
 * @see			iutest_ver_c.h
 * @example		main.c
 * @example		sub.c
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_H_
#define INCG_IRIS_iutest_H_

//======================================================================
// include
#include "iutest_ver_c.h"
#include "iutest_core_c.h"
#include "listener/iutest_default_printer_c.h"
#include "listener/iutest_default_xml_generator_c.h"

//======================================================================
// define
/**
 * @defgroup	TESTDEF		eXg`
 * @brief		eXg`}N
*/

/**
 * @ingroup	TESTDEF
 * @brief	[NXy[X̍\z
 * @note	ǂP c t@CŌĂяoĂ
*/
#define IUTEST_C_WORKSPACE()						IIUT_C_WORKSPACE()

/**
 * @ingroup	TESTDEF
 * @def		IUTEST(testcase_, testname_)
 * @brief	eXg֐`}N
*/
#define IUTEST(testcase_, testname_)				IIUT_C_TEST_(testcase_, testname_)

/**
 * @ingroup	TESTDEF
 * @def		IUTEST_F(testcase_, testname_)
 * @brief	eXg֐`}N
*/
#define IUTEST_F(testcase_, testname_)				IIUT_C_TEST_F_(testcase_, testname_)

#if IUTEST_C_HAS_PARAM_METHOD_TEST

/**
 * @ingroup	TESTDEF
 * @def		IUTEST_PMZ(testcase_, testname_)
 * @brief	p^CYeXg֐`}N
*/
#define IUTEST_PMZ(testcase_, testname_, method_, ...)	IIUT_C_TEST_PMZ_(testcase_, testname_, method_, __VA_ARGS__)

/**
 * @ingroup	TESTDEF
 * @def		IUTEST_PMZ_F(testcase_, testname_)
 * @brief	p^CYeXg֐`}N
*/
#define IUTEST_PMZ_F(testcase_, testname_, method_, ...)	IIUT_C_TEST_PMZ_F_(testcase_, testname_, method_, __VA_ARGS__)

#endif

/**
 * @ingroup	TESTDEF
 * @brief	iutest ̏
*/
#define IUTEST_INIT(argc_, argv_)					iuInitIrisUnitTest(argc_, argv_)

/**
 * @ingroup	TESTDEF
 * @brief	ׂẴeXgs
*/
#define IUTEST_RUN_ALL_TESTS()						iuTestRun()


/**
 * @defgroup	IUTEST_ASSERT_	AT[V(ASSERT)
 * @brief		eXgLq}N
 * @details		sꍇA̎_ŃeXg甲܂B
*/

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	== eXg
*/
#ifndef IUTEST_ASSERT_EQ
#  define	IUTEST_ASSERT_EQ(v1, v2)				IUTEST_TEST_EQ(v1, v2, IUTEST_ASSERT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	== eXg
*/
#ifndef IUTEST_ASSERT_LVALUE_EQ
#  define	IUTEST_ASSERT_LVALUE_EQ(v1, v2)			IUTEST_TEST_LVALUE_EQ(v1, v2, IUTEST_ASSERT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	== eXg
*/
#ifndef IUTEST_ASSERT_RVALUE_EQ
#  define	IUTEST_ASSERT_RVALUE_EQ(v1, v2)			IUTEST_TEST_RVALUE_EQ(v1, v2, IUTEST_ASSERT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	== eXg
*/
#ifndef IUTEST_ASSERT_NE
#  define	IUTEST_ASSERT_NE(v1, v2)				IUTEST_TEST_NE(v1, v2, IUTEST_ASSERT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	<= eXg
*/
#ifndef IUTEST_ASSERT_LE
#  define	IUTEST_ASSERT_LE(v1, v2)				IUTEST_TEST_LE(v1, v2, IUTEST_ASSERT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	< eXg
*/
#ifndef IUTEST_ASSERT_LT
#  define	IUTEST_ASSERT_LT(v1, v2)				IUTEST_TEST_LT(v1, v2, IUTEST_ASSERT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	>= eXg
*/
#ifndef IUTEST_ASSERT_GE
#  define	IUTEST_ASSERT_GE(v1, v2)				IUTEST_TEST_GE(v1, v2, IUTEST_ASSERT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	> eXg
*/
#ifndef IUTEST_ASSERT_GT
#  define	IUTEST_ASSERT_GT(v1, v2)				IUTEST_TEST_GT(v1, v2, IUTEST_ASSERT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	TRUE eXg
*/
#ifndef IUTEST_ASSERT_TRUE
#  define	IUTEST_ASSERT_TRUE(v)					IUTEST_TEST_BOOLEAN_(v, #v, FALSE, TRUE, IUTEST_ASSERT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	FALSE eXg
*/
#ifndef IUTEST_ASSERT_FALSE
#  define	IUTEST_ASSERT_FALSE(v)					IUTEST_TEST_BOOLEAN_(!(v), #v, TRUE, FALSE, IUTEST_ASSERT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	NULL eXg
*/
#ifndef IUTEST_ASSERT_NULL
#  define	IUTEST_ASSERT_NULL(v)					IUTEST_TEST_NULL(v, IUTEST_ASSERT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	NOT NULL eXg
*/
#ifndef IUTEST_ASSERT_NOTNULL
#  define	IUTEST_ASSERT_NOTNULL(v)				IUTEST_TEST_NOTNULL(v, IUTEST_ASSERT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	AhXv eXg
*/
#ifndef IUTEST_ASSERT_SAME
#  define	IUTEST_ASSERT_SAME(v1, v2)				IUTEST_TEST_SAME(v1, v2, IUTEST_ASSERT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	float ̔r eXg
*/
#ifndef IUTEST_ASSERT_FLOAT_EQ
#  define	IUTEST_ASSERT_FLOAT_EQ(v1, v2)			IUTEST_TEST_FLOAT_EQ(v1, v2, IUTEST_ASSERT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	double ̔r eXg
*/
#ifndef IUTEST_ASSERT_DOUBLE_EQ
#  define	IUTEST_ASSERT_DOUBLE_EQ(v1, v2)			IUTEST_TEST_DOUBLE_EQ(v1, v2, IUTEST_ASSERT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	Ql͈̍̔ eXg
*/
#ifndef IUTEST_ASSERT_NEAR
#  define	IUTEST_ASSERT_NEAR(v1, v2, abs_v)		IUTEST_TEST_NEAR(v1, v2, abs_v, IUTEST_ASSERT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	̈v eXg
*/
#ifndef IUTEST_ASSERT_STREQ
#  define	IUTEST_ASSERT_STREQ(v1, v2)				IUTEST_TEST_STREQ(v1, v2, IUTEST_ASSERT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	̕sv eXg
*/
#ifndef IUTEST_ASSERT_STRNE
#  define	IUTEST_ASSERT_STRNE(v1, v2)				IUTEST_TEST_STRNE(v1, v2, IUTEST_ASSERT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	̈vi啶ʂȂj eXg
*/
#ifndef IUTEST_ASSERT_STRCASEEQ
#  define	IUTEST_ASSERT_STRCASEEQ(v1, v2)			IUTEST_TEST_STRCASEEQ(v1, v2, IUTEST_ASSERT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	̕svi啶ʂȂj eXg
*/
#ifndef IUTEST_ASSERT_STRCASENE
#  define	IUTEST_ASSERT_STRCASENE(v1, v2)			IUTEST_TEST_STRCASENE(v1, v2, IUTEST_ASSERT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	HRESULT ̐ eXg
*/
#ifndef IUTEST_ASSERT_HRESULT_SUCCEEDED
#  define IUTEST_ASSERT_HRESULT_SUCCEEDED(hr)		IUTEST_TEST_HRESULT_SUCCEEDED(hr, IUTEST_ASSERT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_ASSERT_
 * @brief	HRESULT ̎s eXg
*/
#ifndef IUTEST_ASSERT_HRESULT_FAILED
#  define IUTEST_ASSERT_HRESULT_FAILED(hr)			IUTEST_TEST_HRESULT_FAILED(hr, IUTEST_ASSERT_FAILURE)
#endif


/**
 * @defgroup	IUTEST_EXPECT_		AT[V(EXPECT)
 * @brief		eXgLq}N
 * @details		sꍇłAeXg𑱍s܂B
*/

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	== eXg
*/
#ifndef IUTEST_EXPECT_EQ
#  define	IUTEST_EXPECT_EQ(v1, v2)				IUTEST_TEST_EQ(v1, v2, IUTEST_EXPECT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	== eXg
*/
#ifndef IUTEST_EXPECT_LVALUE_EQ
#  define	IUTEST_EXPECT_LVALUE_EQ(v1, v2)			IUTEST_TEST_LVALUE_EQ(v1, v2, IUTEST_EXPECT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	== eXg
*/
#ifndef IUTEST_EXPECT_RVALUE_EQ
#  define	IUTEST_EXPECT_RVALUE_EQ(v1, v2)			IUTEST_TEST_RVALUE_EQ(v1, v2, IUTEST_EXPECT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	== eXg
*/
#ifndef IUTEST_EXPECT_NE
#  define	IUTEST_EXPECT_NE(v1, v2)				IUTEST_TEST_NE(v1, v2, IUTEST_EXPECT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	<= eXg
*/
#ifndef IUTEST_EXPECT_LE
#  define	IUTEST_EXPECT_LE(v1, v2)				IUTEST_TEST_LE(v1, v2, IUTEST_EXPECT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	< eXg
*/
#ifndef IUTEST_EXPECT_LT
#  define	IUTEST_EXPECT_LT(v1, v2)				IUTEST_TEST_LT(v1, v2, IUTEST_EXPECT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	>= eXg
*/
#ifndef IUTEST_EXPECT_GE
#  define	IUTEST_EXPECT_GE(v1, v2)				IUTEST_TEST_GE(v1, v2, IUTEST_EXPECT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	> eXg
*/
#ifndef IUTEST_EXPECT_GT
#  define	IUTEST_EXPECT_GT(v1, v2)				IUTEST_TEST_GT(v1, v2, IUTEST_EXPECT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	TRUE eXg
*/
#ifndef IUTEST_EXPECT_TRUE
#  define	IUTEST_EXPECT_TRUE(v)					IUTEST_TEST_BOOLEAN_(v, #v, FALSE, TRUE, IUTEST_EXPECT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	FALSE eXg
*/
#ifndef IUTEST_EXPECT_FALSE
#  define	IUTEST_EXPECT_FALSE(v)					IUTEST_TEST_BOOLEAN_(!(v), #v, TRUE, FALSE, IUTEST_EXPECT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	NULL eXg
*/
#ifndef IUTEST_EXPECT_NULL
#  define	IUTEST_EXPECT_NULL(v)					IUTEST_TEST_NULL(v, IUTEST_EXPECT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	NOT NULL eXg
*/
#ifndef IUTEST_EXPECT_NOTNULL
#  define	IUTEST_EXPECT_NOTNULL(v)				IUTEST_TEST_NOTNULL(v, IUTEST_EXPECT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	AhXv eXg
*/
#ifndef IUTEST_EXPECT_SAME
#  define	IUTEST_EXPECT_SAME(v1, v2)				IUTEST_TEST_SAME(v1, v2, IUTEST_EXPECT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	float ̔r eXg
*/
#ifndef IUTEST_EXPECT_FLOAT_EQ
#  define	IUTEST_EXPECT_FLOAT_EQ(v1, v2)			IUTEST_TEST_FLOAT_EQ(v1, v2, IUTEST_EXPECT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	double ̔r eXg
*/
#ifndef IUTEST_EXPECT_DOUBLE_EQ
#  define	IUTEST_EXPECT_DOUBLE_EQ(v1, v2)			IUTEST_TEST_DOUBLE_EQ(v1, v2, IUTEST_EXPECT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	Ql͈̍̔ eXg
*/
#ifndef IUTEST_EXPECT_NEAR
#  define	IUTEST_EXPECT_NEAR(v1, v2, abs_v)		IUTEST_TEST_NEAR(v1, v2, abs_v, IUTEST_EXPECT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	̈v eXg
*/
#ifndef IUTEST_EXPECT_STREQ
#  define	IUTEST_EXPECT_STREQ(v1, v2)				IUTEST_TEST_STREQ(v1, v2, IUTEST_EXPECT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	̕sv eXg
*/
#ifndef IUTEST_EXPECT_STRNE
#  define	IUTEST_EXPECT_STRNE(v1, v2)				IUTEST_TEST_STRNE(v1, v2, IUTEST_EXPECT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	̈vi啶ʂȂj eXg
*/
#ifndef IUTEST_EXPECT_STRCASEEQ
#  define	IUTEST_EXPECT_STRCASEEQ(v1, v2)			IUTEST_TEST_STRCASEEQ(v1, v2, IUTEST_EXPECT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	̕svi啶ʂȂj eXg
*/
#ifndef IUTEST_EXPECT_STRCASENE
#  define	IUTEST_EXPECT_STRCASENE(v1, v2)			IUTEST_TEST_STRCASENE(v1, v2, IUTEST_EXPECT_FAILURE)
#endif

/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	HRESULT ̐ eXg
*/
#ifndef IUTEST_EXPECT_HRESULT_SUCCEEDED
#  define IUTEST_EXPECT_HRESULT_SUCCEEDED(hr)		IUTEST_TEST_HRESULT_SUCCEEDED(hr, IUTEST_EXPECT_FAILURE)
#endif
/**
 * @ingroup	IUTEST_EXPECT_
 * @brief	HRESULT ̎s eXg
*/
#ifndef IUTEST_EXPECT_HRESULT_FAILED
#  define IUTEST_EXPECT_HRESULT_FAILED(hr)			IUTEST_TEST_HRESULT_FAILED(hr, IUTEST_EXPECT_FAILURE)
#endif


/**
 * @defgroup	IUTEST_INFORM_		AT[V(INFORM)
 * @brief		eXgLq}N
 * @details		sꍇłAeXgsƂċL^܂B܂AeXg͑s܂B
*/

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	== eXg
*/
#ifndef IUTEST_INFORM_EQ
#  define	IUTEST_INFORM_EQ(expected, actual)		IUTEST_TEST_EQ(expected, actual, IUTEST_INFORM_FAILURE)
#endif

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	== eXg
*/
#ifndef IUTEST_INFORM_LVALUE_EQ
#  define	IUTEST_INFORM_LVALUE_EQ(v1, v2)			IUTEST_TEST_LVALUE_EQ(v1, v2, IUTEST_INFORM_FAILURE)
#endif

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	== eXg
*/
#ifndef IUTEST_INFORM_RVALUE_EQ
#  define	IUTEST_INFORM_RVALUE_EQ(v1, v2)			IUTEST_TEST_RVALUE_EQ(v1, v2, IUTEST_INFORM_FAILURE)
#endif

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	!= eXg
*/
#ifndef IUTEST_INFORM_NE
#  define	IUTEST_INFORM_NE(v1, v2)				IUTEST_TEST_NE(v1, v2, IUTEST_INFORM_FAILURE)
#endif

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	<= eXg
*/
#ifndef IUTEST_INFORM_LE
#  define	IUTEST_INFORM_LE(v1, v2)				IUTEST_TEST_LE(v1, v2, IUTEST_INFORM_FAILURE)
#endif
/**
 * @ingroup	IUTEST_INFORM_
 * @brief	< eXg
*/
#ifndef IUTEST_INFORM_LT
#  define	IUTEST_INFORM_LT(v1, v2)				IUTEST_TEST_LT(v1, v2, IUTEST_INFORM_FAILURE)
#endif
/**
 * @ingroup	IUTEST_INFORM_
 * @brief	>= eXg
*/
#ifndef IUTEST_INFORM_GE
#  define	IUTEST_INFORM_GE(v1, v2)				IUTEST_TEST_GE(v1, v2, IUTEST_INFORM_FAILURE)
#endif
/**
 * @ingroup	IUTEST_INFORM_
 * @brief	> eXg
*/
#ifndef IUTEST_INFORM_GT
#  define	IUTEST_INFORM_GT(v1, v2)				IUTEST_TEST_GT(v1, v2, IUTEST_INFORM_FAILURE)
#endif

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	TRUE eXg
*/
#ifndef IUTEST_INFORM_TRUE
#  define	IUTEST_INFORM_TRUE(v)					IUTEST_TEST_BOOLEAN_(v, #v, FALSE, TRUE, IUTEST_INFORM_FAILURE)
#endif
/**
 * @ingroup	IUTEST_INFORM_
 * @brief	FALSE eXg
*/
#ifndef IUTEST_INFORM_FALSE
#  define	IUTEST_INFORM_FALSE(v)					IUTEST_TEST_BOOLEAN_(!(v), #v, TRUE, FALSE, IUTEST_INFORM_FAILURE)
#endif

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	NULL eXg
*/
#ifndef IUTEST_INFORM_NULL
#  define	IUTEST_INFORM_NULL(v)					IUTEST_TEST_NULL(v, IUTEST_INFORM_FAILURE)
#endif
/**
 * @ingroup	IUTEST_INFORM_
 * @brief	NOT NULL eXg
*/
#ifndef IUTEST_INFORM_NOTNULL
#  define	IUTEST_INFORM_NOTNULL(v)				IUTEST_TEST_NOTNULL(v, IUTEST_INFORM_FAILURE)
#endif

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	AhXv eXg
*/
#ifndef IUTEST_INFORM_SAME
#  define	IUTEST_INFORM_SAME(v1, v2)				IUTEST_TEST_SAME(v1, v2, IUTEST_INFORM_FAILURE)
#endif

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	float ̔r eXg
*/
#ifndef IUTEST_INFORM_FLOAT_EQ
#  define	IUTEST_INFORM_FLOAT_EQ(expected, actual)	IUTEST_TEST_FLOAT_EQ(expected, actual, IUTEST_INFORM_FAILURE)
#endif
/**
 * @ingroup	IUTEST_INFORM_
 * @brief	double ̔r eXg
*/
#ifndef IUTEST_INFORM_DOUBLE_EQ
#  define	IUTEST_INFORM_DOUBLE_EQ(expected, actual)	IUTEST_TEST_DOUBLE_EQ(expected, actual, IUTEST_INFORM_FAILURE)
#endif

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	Ql͈̍̔ eXg
*/
#ifndef IUTEST_INFORM_NEAR
#  define	IUTEST_INFORM_NEAR(v1, v2, abs_v)		IUTEST_TEST_NEAR(v1, v2, abs_v, IUTEST_INFORM_FAILURE)
#endif

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	̈v eXg
*/
#ifndef IUTEST_INFORM_STREQ
#  define	IUTEST_INFORM_STREQ(expected_str, actual_str)	IUTEST_TEST_STREQ(expected_str, actual_str, IUTEST_INFORM_FAILURE)
#endif
/**
 * @ingroup	IUTEST_INFORM_
 * @brief	̕sv eXg
*/
#ifndef IUTEST_INFORM_STRNE
#  define	IUTEST_INFORM_STRNE(v1, v2)				IUTEST_TEST_STRNE(v1, v2, IUTEST_INFORM_FAILURE)
#endif

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	̈vi啶ʂȂj eXg
*/
#ifndef IUTEST_INFORM_STRCASEEQ
#  define	IUTEST_INFORM_STRCASEEQ(expected_str, actual_str)	IUTEST_TEST_STRCASEEQ(expected_str, actual_str, IUTEST_INFORM_FAILURE)
#endif
/**
 * @ingroup	IUTEST_INFORM_
 * @brief	̕svi啶ʂȂj eXg
*/
#ifndef IUTEST_INFORM_STRCASENE
#  define	IUTEST_INFORM_STRCASENE(v1, v2)			IUTEST_TEST_STRCASENE(v1, v2, IUTEST_INFORM_FAILURE)
#endif

/**
 * @ingroup	IUTEST_INFORM_
 * @brief	HRESULT ̐ eXg
*/
#ifndef IUTEST_INFORM_HRESULT_SUCCEEDED
#  define IUTEST_INFORM_HRESULT_SUCCEEDED(hr)		IUTEST_TEST_HRESULT_SUCCEEDED(hr, IUTEST_INFORM_FAILURE)
#endif
/**
 * @ingroup	IUTEST_INFORM_
 * @brief	HRESULT ̎s eXg
*/
#ifndef IUTEST_INFORM_HRESULT_FAILED
#  define IUTEST_INFORM_HRESULT_FAILED(hr)			IUTEST_TEST_HRESULT_FAILED(hr, IUTEST_INFORM_FAILURE)
#endif

//======================================================================
// declare
static void			iuTestInitialize(void);

//======================================================================
// function
/**
 * @brief	eXg̏
*/
static IUTEST_ATTRIBUTE_UNUSED_ void	iuInitIrisUnitTestA(int* argc, char** argv)
{
	iuTestEnv_ParseCommandLineA(argc, argv);
	iuTestInitialize();
}
#if IUTEST_C_HAS_WCHAR_T
static IUTEST_ATTRIBUTE_UNUSED_ void	iuInitIrisUnitTestW(int* argc, wchar_t** argv)
{
	iuTestEnv_ParseCommandLineW(argc, argv);
	iuTestInitialize();
}
#endif

//! eXg̏
#ifdef UNICODE
#  define iuInitIrisUnitTest	iuInitIrisUnitTestW
#else
#  define iuInitIrisUnitTest	iuInitIrisUnitTestA
#endif

/**
 * @biref	eXg̏iʍj
*/
static void			iuTestInitialize(void)
{
	{
		iuTestListener* listener = iuTestListener_MakeListener(&IIUT_C_UNITTEST().def_printer
			, iuTestDefaultPrinter_OnTestProgramStart
			, iuTestDefaultPrinter_OnTestIterationStart
			, iuTestDefaultPrinter_OnTestCaseStart
			, iuTestDefaultPrinter_OnTestStart
			, iuTestDefaultPrinter_OnTestPartResult
			, iuTestDefaultPrinter_OnTestRecordProperty
			, iuTestDefaultPrinter_OnTestEnd
			, iuTestDefaultPrinter_OnTestCaseEnd
			, iuTestDefaultPrinter_OnTestIterationEnd
			, iuTestDefaultPrinter_OnTestProgramEnd
			);
		if( listener != NULL )
		{
			iuUnitTest_AddTestListener(listener);
		}
	}
	if( iuTestEnv_IsEnableFlag(IUTESTENV_OUTPUT_XML_REPORT) )
	{
		iuTestListener* listener = iuTestListener_MakeListener(&IIUT_C_UNITTEST().def_xml_generator
			, iuTestDefaultXMLGenerator_OnTestProgramStart
			, iuTestDefaultXMLGenerator_OnTestIterationStart
			, iuTestDefaultXMLGenerator_OnTestCaseStart
			, iuTestDefaultXMLGenerator_OnTestStart
			, iuTestDefaultXMLGenerator_OnTestPartResult
			, iuTestDefaultXMLGenerator_OnTestRecordProperty
			, iuTestDefaultXMLGenerator_OnTestEnd
			, iuTestDefaultXMLGenerator_OnTestCaseEnd
			, iuTestDefaultXMLGenerator_OnTestIterationEnd
			, iuTestDefaultXMLGenerator_OnTestProgramEnd
			);
		if( listener != NULL )
		{
			iuUnitTest_AddTestListener(listener);
		}
	}
}

#endif
