//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_listener_c.h
 * @brief		iris unit test CxgXi[ ` t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_listener_C_H_B8604F9D_23F4_455e_B7EF_6D5E5D3EF9EC_
#define INCG_IRIS_iutest_listener_C_H_B8604F9D_23F4_455e_B7EF_6D5E5D3EF9EC_

//======================================================================
// include
#include "internal/iutest_pool_c.h"

//======================================================================
// declare
struct iuUnitTest_t;
struct iuTestInfo_t;
struct iuTestCase_t;
struct iuTestPartResult_t;
struct iuTestProperty_t;

//======================================================================
// typedef
typedef void (*iuTestListener_OnTestProgramStart)(struct iuUnitTest_t* unit_test);
typedef void (*iuTestListener_OnTestIterationStart)(struct iuUnitTest_t* unit_test, int iteration);
typedef void (*iuTestListener_OnTestCaseStart)(struct iuTestCase_t* test_case);
typedef void (*iuTestListener_OnTestStart)(struct iuTestCase_t* test_case, struct iuTestInfo_t* test_info);
typedef void (*iuTestListener_OnTestPartResult)(struct iuTestPartResult_t* test_part_result);
typedef void (*iuTestListener_OnTestRecordProperty)(struct iuTestProperty_t* test_property);
typedef void (*iuTestListener_OnTestEnd)(struct iuTestCase_t* test_case, struct iuTestInfo_t* test_info);
typedef void (*iuTestListener_OnTestCaseEnd)(struct iuTestCase_t* test_case);
typedef void (*iuTestListener_OnTestIterationEnd)(struct iuUnitTest_t* unit_test, int iteration);
typedef void (*iuTestListener_OnTestProgramEnd)(struct iuUnitTest_t* unit_test);

typedef struct iuTestListener_t	iuTestListener;

//======================================================================
// struct
/**
 * @brief	eXgCxgXi[\
*/
struct iuTestListener_t
{
	iuTestListener_OnTestProgramStart	OnTestProgramStart;
	iuTestListener_OnTestIterationStart	OnTestIterationStart;
	iuTestListener_OnTestCaseStart		OnTestCaseStart;
	iuTestListener_OnTestStart			OnTestStart;
	iuTestListener_OnTestPartResult		OnTestPartResult;
	iuTestListener_OnTestRecordProperty	OnTestRecordProperty;
	iuTestListener_OnTestEnd			OnTestEnd;
	iuTestListener_OnTestCaseEnd		OnTestCaseEnd;
	iuTestListener_OnTestIterationEnd	OnTestIterationEnd;
	iuTestListener_OnTestProgramEnd		OnTestProgramEnd;
	iuTestListener*	next;
};

//======================================================================
// define
#define iuTestListener_ctor()	{ NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL }

//======================================================================
// function
/**
 * @brief	Xi[̍쐬
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuTestListener* iuTestListener_MakeListener(iuTestListener* listener
													, iuTestListener_OnTestProgramStart OnTestProgramStart
													, iuTestListener_OnTestIterationStart OnTestIterationStart
													, iuTestListener_OnTestCaseStart OnTestCaseStart
													, iuTestListener_OnTestStart OnTestStart
													, iuTestListener_OnTestPartResult OnTestPartResult
													, iuTestListener_OnTestRecordProperty OnTestProperty
													, iuTestListener_OnTestEnd OnTestEnd
													, iuTestListener_OnTestCaseEnd OnTestCaseEnd
													, iuTestListener_OnTestIterationEnd OnTestIterationEnd
													, iuTestListener_OnTestProgramEnd OnTestProgramEnd
													)
{
	if( listener == NULL ) return NULL;
	listener->next = NULL;
	listener->OnTestProgramStart	= OnTestProgramStart;
	listener->OnTestIterationStart	= OnTestIterationStart;
	listener->OnTestCaseStart		= OnTestCaseStart;
	listener->OnTestStart			= OnTestStart;
	listener->OnTestPartResult		= OnTestPartResult;
	listener->OnTestRecordProperty	= OnTestProperty;
	listener->OnTestEnd				= OnTestEnd;
	listener->OnTestCaseEnd			= OnTestCaseEnd;
	listener->OnTestIterationEnd	= OnTestIterationEnd;
	listener->OnTestProgramEnd		= OnTestProgramEnd;
	return listener;
}


/**
 * @brief	iuTestListener ̍쐬
*/
static iuTestListener*	iuTestListener_AllocListener(void)
{
#if IUTEST_C_HAS_MALLOC
	return (iuTestListener*)iu_malloc(sizeof(iuTestListener));
#else
	iuTestListener* ptr = NULL;
	IUTEST_C_AllocByPool(ptr, iuTestListener, IUTEST_C_LISTENER_POOL_COUNT);
	return ptr;
#endif
}

/**
 * @brief	Xi[̍쐬
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuTestListener* iuTestListener_NewListener(
	iuTestListener_OnTestProgramStart OnTestProgramStart
	, iuTestListener_OnTestIterationStart OnTestIterationStart
	, iuTestListener_OnTestCaseStart OnTestCaseStart
	, iuTestListener_OnTestStart OnTestStart
	, iuTestListener_OnTestPartResult OnTestPartResult
	, iuTestListener_OnTestRecordProperty OnTestProperty
	, iuTestListener_OnTestEnd OnTestEnd
	, iuTestListener_OnTestCaseEnd OnTestCaseEnd
	, iuTestListener_OnTestIterationEnd OnTestIterationEnd
	, iuTestListener_OnTestProgramEnd OnTestProgramEnd
	)
{
	iuTestListener* listener = iuTestListener_AllocListener();
	return iuTestListener_MakeListener(listener
		, OnTestProgramStart
		, OnTestIterationStart
		, OnTestCaseStart
		, OnTestStart
		, OnTestPartResult
		, OnTestProperty
		, OnTestEnd
		, OnTestCaseEnd
		, OnTestIterationEnd
		, OnTestProgramEnd
		);
}

#endif
