//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_factory.hpp
 * @brief		iris unit test eXgt@Ng[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_factory_HPP_9C2B4B94_95A0_479a_9C9D_43FB31845A73_
#define INCG_IRIS_iutest_factory_HPP_9C2B4B94_95A0_479a_9C9D_43FB31845A73_

//======================================================================
// include
#include "iutest_internal_defs.hpp"
#include "iutest_list.hpp"

namespace iutest {

//======================================================================
// declare
class Test;

namespace detail
{

//======================================================================
// class
/**
 * @internal
 * @brief	eXgNXC^[tF[X
*/
class iuFactoryBase
{
	IUTEST_PP_DISALLOW_COPY_AND_ASSIGN(iuFactoryBase);
public:
	iuFactoryBase(void) {}
	virtual ~iuFactoryBase(void) {}
public:
	virtual auto_ptr<Test>	Create(void) = 0;
};

/**
 * @internal
 * @brief	eXgNX
 * @tparam	Tester	= eXgNX
*/
template<class Tester>
class iuFactory : public iuFactoryBase
{
public:
	virtual auto_ptr<Test>	Create(void)
	{
		auto_ptr<Test> p = new Tester();
		return p;
	}
};

/**
 * @internal
 * @brief	p[^ZbgeXgNXC^[tF[X
 * @tparam	ParamType	= p[^̌^
*/
template<typename ParamType>
class iuParamTestFactoryBase : public iuFactoryBase
{
public:
	iuParamTestFactoryBase(void) {}
	iuParamTestFactoryBase(ParamType param) : m_param(param) {}
public:
	void				SetParam(ParamType param)	{ m_param = param; }
	const ParamType&	GetParam(void)		const	{ return m_param; }
protected:
	ParamType	m_param;
};


/**
 * @internal
 * @brief	p[^ZbgeXgNX
 * @tparam	Tester	= eXgNX
*/
template<class Tester>
class iuParamTestFactory : public iuParamTestFactoryBase<typename Tester::ParamType>
{
	typedef typename Tester::ParamType			ParamType;
	typedef iuParamTestFactoryBase<ParamType>	_Mybase;
public:
	iuParamTestFactory(void) {}
	iuParamTestFactory(ParamType param) : _Mybase(param) {}

public:
	virtual auto_ptr<Test>	Create(void)
	{
		Tester::SetParam(&this->m_param);
		auto_ptr<Test> p = new Tester();
		return p;
	}
};

}	// end of namespace detail
}	// end of namespace iutest

#endif
