//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_time_c.h
 * @brief		iris unit test time utility t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_time_c_H_C6B9E65B_4059_4175_A6DB_397DBF338AA8_
#define INCG_IRIS_iutest_time_c_H_C6B9E65B_4059_4175_A6DB_397DBF338AA8_

//======================================================================
// include
#include "../iutest_defs_c.h"

#if IUTEST_C_HAS_HDR_TIME
#  include <time.h>
#endif

//======================================================================
// function

/**
 * @brief	~bbPʂ̕𐶐
*/
static IUTEST_ATTRIBUTE_UNUSED_ void	iuTest_FormatTimeInMillisecAsSecond(char* dst, iuTimeInMillisec mmsec)
{
#if IUTEST_C_HAS_LIBC && IUTEST_C_HAS_FLOATINGPOINT
IUTEST_PRAGMA_CRT_SECURE_WARN_DISABLE_BEGIN()
	sprintf(dst, "%f", mmsec/1000.0f);
IUTEST_PRAGMA_CRT_SECURE_WARN_DISABLE_END()
#else
	char* p = dst;
	{
		iuTimeInMillisec sec = mmsec/1000;
		if( sec > 0 )
		{
			for( ; sec > 0; sec/=10, ++p ) *p = (char)('0' + sec % 10);
			iu_strrev_self(dst);
		}
		else
		{
			*p = '0';
			++p;
		}
	}
	{
		iuTimeInMillisec dec = mmsec%1000;
		if( dec > 0 )
		{
			int i = 0;
			*p++ = '.';
			for( i=0; i < 3; ++i, ++p )
			{
				int digit = 10*(2-i);
				if( digit )
				{
					*p = (char)('0' + (dec/digit)%10);
					if( dec % digit == 0 ) break;
				}
				else
				{
					*p = (char)('0' + (dec%10));
				}
			}
		}
	}
	*p = '\0';
#endif
}

/**
 * @brief	ݎ̎擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuTimeInMillisec	iuTest_GetTime(void)
{
#if IUTEST_C_HAS_CTIME
	return (iuTimeInMillisec)time(NULL);
#else
	return 0;
#endif
}

/**
 * @brief	ݎ̃~b擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuTimeInMillisec	iuTest_GetTimeInMillis(void)
{
#if		defined(IUTEST_GetMillisec)
	return IUTEST_GetMillisec();

#elif	defined(IUTEST_OS_WINDOWS)
	return (iuTimeInMillisec)(GetTickCount());

#elif	IUTEST_C_HAS_GETTIMEOFDAY
	timeval tv;
	gettimeofday(&tv, NULL);
	return (iuTimeInMillisec)(tv.tv_sec) * 1000 + (iuTimeInMillisec)(tv.tv_usec) / 1000;

#elif	IUTEST_C_HAS_CLOCK
	return clock() * 1000 / CLOCKS_PER_SEC;

#else

#define IUTEST_C_NO_GETTIMEINMILLIS
	return iuTest_GetTime()*1000;
#endif
}

/**
 * @brief	sȒl̎擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuUInt32 iuTest_GetIndefiniteValue(void)
{
#if !defined(IUTEST_C_NO_GETTIMEINMILLIS)
	return (iuUInt32)(iuTest_GetTimeInMillis());
#else
	// ȂׂɂȂȂ悤ɂ
	static iuUInt32 s = 20120206u;
	s = s*1664525u + 1013904223u;
	return s;
#endif
}

/**
 * @brief	XgbvEHb`p\
*/
typedef struct iuTestStopWatch_t
{
	iuTimeInMillisec	begin;
} iuTestStopWatch;

/**
 * @brief	XgbvEHb`̃X^[g
*/
static void	iuTest_StopWatchStart(iuTestStopWatch* watch)
{
	watch->begin = iuTest_GetTimeInMillis();
}

/**
 * @brief	XgbvEHb`̒~
*/
static iuTimeInMillisec	iuTest_StopWatchStop(iuTestStopWatch* watch)
{
	return iuTest_GetTimeInMillis() - watch->begin;
}


#endif
