//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_env_c.h
 * @brief		iris unit test  t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_env_C_H_DC5C5193_7081_4fef_B668_283CAEFA1F77_
#define INCG_IRIS_iutest_env_C_H_DC5C5193_7081_4fef_B668_283CAEFA1F77_

//======================================================================
// include
#include "iutest_listener_c.h"
#include "internal/iutest_random_c.h"
#include "internal/iutest_string_c.h"

//======================================================================
// define
/**
 * @private
 * @{
*/
#define IIUT_C_TESTENV_NAME		g_iutest_c_testenv_instance
#define IIUT_C_TESTENV()		IIUT_C_TESTENV_NAME
/**
 * @}
*/

#define IUTEST_FLAG(name)	IIUT_C_TESTENV().option.name

//======================================================================
// enum
typedef enum IUTESTENV_FLAG
{
	IUTESTENV_FILTERING_TESTS		= 0x0004,	//!< tB^O
	IUTESTENV_CONSOLECOLOR_ON		= 0x0010,	//!< FoON
	IUTESTENV_CONSOLECOLOR_OFF		= 0x0020,	//!< FoOFF
	IUTESTENV_CONSOLECOLOR_ANSI		= 0x0040,	//!< GXP[vV[PXŏo
	IUTESTENV_OUTPUT_XML_REPORT		= 0x0100,	//!< xml o
	IUTESTENV_SHOWHELP_AND_SORRY	= 0x0400,	//!< wvo
	IUTESTENV_SHOWHELP				= 0x0800,	//!< wvo
	IUTESTENV_SHOWVER				= 0x1000,	//!< o[Wo
	IUTESTENV_SHOWTESTSLIST			= 0x2000,	//!< eXgXgo
	IUTESTENV_SHOWFEATURE			= 0x4000,	//!< @\o

	IUTESTENV_FLAG_DEFAULT			= 0
} IUTESTENV_FLAG;

//======================================================================
// typedef
typedef int (*iuVPrintf)(const char* fmt, va_list va);
typedef void (*iuGlobalEnvironmentSetUp)(void);
typedef void (*iuGlobalEnvironmentTearDown)(void);

//======================================================================
// struct
/**
 * @brief	O[o SetUp \
*/
typedef struct iuTestGlobalEnvSetUp_t
{
	iuGlobalEnvironmentSetUp		func;	//!< SetUp ֐
	struct iuTestGlobalEnvSetUp_t*	next;	//!< ̍\
} iuTestGlobalEnvSetUp;

/**
 * @brief	O[o TearDown \
*/
typedef struct iuTestGlobalEnvTearDown_t
{
	iuGlobalEnvironmentTearDown			func;	//!< TearDown ֐
	struct iuTestGlobalEnvTearDown_t*	next;	//!< ̍\
} iuTestGlobalEnvTearDown;

/**
 * @brief	eXg\
*/
typedef struct iuTestEnv_t
{
	iuTestListener*	listeners;		//!< Xi[Xg
	iuTestGlobalEnvSetUp*		env_setup;		//!< O[o SetUp Xg
	iuTestGlobalEnvTearDown*	env_teardown;	//!< O[o TearDown Xg
	iuUInt32		flag;			//!< tO
	iuUInt32		current_seed;	//!< V[ȟݒl
	iuRandomContext	random_context;	//!< ReLXg

	// IvV
	struct {
		const char*		filter;			//!< eXgtB^O
		int				repeat;			//!< s[gJEg
		iuUInt32		random_seed;	//!< V[h̐ݒl
		iuBOOL			shuffle;		//!< VbteXg
		iuBOOL			print_time;		//!< oߎԂ̏o
		iuBOOL			break_on_failure;			//!< eXgsɃu[N
		iuBOOL			also_run_disabled_tests;	//!< DISABLED eXgs
	} option;
	iuVPrintf		pfnvpritf;			//!< vprintf ֐|C^
	char			output_xml[260];	//!< oXMLt@CpX
} iuTestEnv;

//======================================================================
// define
/**
 * @private
 * @{
*/
#define iuTestEnvOption_ctor()	{ NULL, 1, 0, FALSE, TRUE, FALSE, FALSE }
#define iuTestEnv_ctor()	{ NULL, NULL, NULL, IUTESTENV_FLAG_DEFAULT, 0, iuRandomContext_ctor()	\
								, iuTestEnvOption_ctor(), NULL, {0} }
/**
 * @}
*/

//======================================================================
// variable
extern iuTestEnv	IIUT_C_TESTENV_NAME;

//======================================================================
// function
/**
 * @brief	eXgCX^X̎擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuTestEnv* iuTestEnv_GetInstance(void)
{
	return &IIUT_C_TESTENV();
}

/**
 * @brief	vprintf ֐|C^ݒ
*/
static IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_SetVPrintfFunction(iuVPrintf proc)
{
	iuTestEnv_GetInstance()->pfnvpritf = proc;
}

/**
 * @brief	TestListener ̒ǉ
*/
static iuBOOL	iuTestEnv_AddTestListener(iuTestEnv* test_env, iuTestListener* test_listener)
{
	if( test_env == NULL ) return FALSE;
	iuTestHelper_AddList(iuTestListener, test_env->listeners, test_listener);
	return TRUE;
}

/**
 * @brief	TestListener ̍폜
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuBOOL	iuTestEnv_SubTestListener(iuTestEnv* test_env, iuTestListener* test_listener)
{
	if( test_env == NULL ) return FALSE;
	if( test_listener == NULL ) return FALSE;
	{
		iuTestListener *top = test_env->listeners;
		if( top == NULL ) return FALSE;
		if( top == test_listener )
		{
			test_env->listeners = test_listener->next;
			test_listener->next = NULL;
			return TRUE;
		}
		{
			iuTestListener *prev = top;
			iuTestListener *curr = top->next;
			while( curr != NULL )
			{
				if( curr == test_listener )
				{
					prev->next = test_listener->next;
					test_listener->next = NULL;
					return TRUE;
				}
				prev = curr;
				curr = curr->next;
			}
		}
	}
	return FALSE;
}

static iuTestGlobalEnvSetUp*	iuTestEnv_AllocGlobalEnvSetUp(void);
static iuTestGlobalEnvTearDown*	iuTestEnv_AllocGlobalEnvTearDown(void);

/**
 * @brief	GlobalEnvironmentSetUp ̒ǉ
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuBOOL	iuTestEnv_AddGlobalEnvironmentSetUp(iuTestEnv* test_env, iuGlobalEnvironmentSetUp func)
{
	if( test_env == NULL ) return FALSE;
	{
		iuTestGlobalEnvSetUp* elem = iuTestEnv_AllocGlobalEnvSetUp();
		if( elem == NULL ) return FALSE;
		elem->func = func;
		elem->next = NULL;
		iuTestHelper_AddList(iuTestGlobalEnvSetUp, test_env->env_setup, elem);
	}
	return TRUE;
}

/**
 * @brief	GlobalEnvironmentTearDown ̒ǉ
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuBOOL	iuTestEnv_AddGlobalEnvironmentTearDown(iuTestEnv* test_env, iuGlobalEnvironmentTearDown func)
{
	if( test_env == NULL ) return FALSE;
	{
		iuTestGlobalEnvTearDown* elem = iuTestEnv_AllocGlobalEnvTearDown();
		if( elem == NULL ) return FALSE;
		elem->func = func;
		elem->next = NULL;
		iuTestHelper_AddList(iuTestGlobalEnvTearDown, test_env->env_teardown, elem);
	}
	return TRUE;
}

/**
 * @brief	GlobalEnvironmentSetUp ̎s
*/
static void	iuTestEnv_GlobalEnvironmentSetUp(void)
{
	iuTestGlobalEnvSetUp* curr = IIUT_C_TESTENV().env_setup;
	while( curr != NULL )
	{
		if( curr->func != NULL )
		{
			(*curr->func)();
		}
		curr = curr->next;
	}
}

/**
 * @brief	GlobalEnvironmentTearDown ̎s
*/
static void	iuTestEnv_GlobalEnvironmentTearDown(void)
{
	iuTestGlobalEnvTearDown* curr = IIUT_C_TESTENV().env_teardown;
	while( curr != NULL )
	{
		if( curr->func != NULL )
		{
			(*curr->func)();
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnTestProgramStart
*/
static void	iuTestEnv_ListenerEvent_OnTestProgramStart(struct iuUnitTest_t* unit_test)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnTestProgramStart != NULL )
		{
			(*curr->OnTestProgramStart)(unit_test);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnTestIterationStart
*/
static void	iuTestEnv_ListenerEvent_OnTestIterationStart(struct iuUnitTest_t* unit_test, int iteration)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnTestIterationStart != NULL )
		{
			(*curr->OnTestIterationStart)(unit_test, iteration);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnEnvironmentsSetUpStart
*/
static void	iuTestEnv_ListenerEvent_OnEnvironmentsSetUpStart(struct iuUnitTest_t* unit_test)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnEnvironmentsSetUpStart != NULL )
		{
			(*curr->OnEnvironmentsSetUpStart)(unit_test);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnEnvironmentsSetUpEnd
*/
static void	iuTestEnv_ListenerEvent_OnEnvironmentsSetUpEnd(struct iuUnitTest_t* unit_test)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnEnvironmentsSetUpEnd != NULL )
		{
			(*curr->OnEnvironmentsSetUpEnd)(unit_test);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnTestCaseStart
*/
static void	iuTestEnv_ListenerEvent_OnTestCaseStart(struct iuTestCase_t* test_case)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnTestCaseStart != NULL )
		{
			(*curr->OnTestCaseStart)(test_case);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnTestStart
*/
static void	iuTestEnv_ListenerEvent_OnTestStart(struct iuTestCase_t* test_case, struct iuTestInfo_t* test_info)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnTestStart != NULL )
		{
			(*curr->OnTestStart)(test_case, test_info);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnTestPartResult
*/
static void	iuTestEnv_ListenerEvent_OnTestPartResult(struct iuTestPartResult_t* test_part_result)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnTestPartResult != NULL )
		{
			(*curr->OnTestPartResult)(test_part_result);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnTestRecordProperty
*/
static void	iuTestEnv_ListenerEvent_OnTestRecordProperty(struct iuTestProperty_t* test_property)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnTestRecordProperty != NULL )
		{
			(*curr->OnTestRecordProperty)(test_property);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnTestEnd
*/
static void	iuTestEnv_ListenerEvent_OnTestEnd(struct iuTestCase_t* test_case, struct iuTestInfo_t* test_info)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnTestEnd != NULL )
		{
			(*curr->OnTestEnd)(test_case, test_info);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnTestCaseEnd
*/
static void	iuTestEnv_ListenerEvent_OnTestCaseEnd(struct iuTestCase_t* test_case)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnTestCaseEnd != NULL )
		{
			(*curr->OnTestCaseEnd)(test_case);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnEnvironmentsTearDownStart
*/
static void	iuTestEnv_ListenerEvent_OnEnvironmentsTearDownStart(struct iuUnitTest_t* unit_test)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnEnvironmentsTearDownStart != NULL )
		{
			(*curr->OnEnvironmentsTearDownStart)(unit_test);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnEnvironmentsTearDownEnd
*/
static void	iuTestEnv_ListenerEvent_OnEnvironmentsTearDownEnd(struct iuUnitTest_t* unit_test)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnEnvironmentsTearDownEnd != NULL )
		{
			(*curr->OnEnvironmentsTearDownEnd)(unit_test);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnTestIterationEnd
*/
static void	iuTestEnv_ListenerEvent_OnTestIterationEnd(struct iuUnitTest_t* unit_test, int iteration)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnTestIterationEnd != NULL )
		{
			(*curr->OnTestIterationEnd)(unit_test, iteration);
		}
		curr = curr->next;
	}
}

/**
 * @brief	OnTestProgramEnd
*/
static void	iuTestEnv_ListenerEvent_OnTestProgramEnd(struct iuUnitTest_t* unit_test)
{
	iuTestListener* curr = IIUT_C_TESTENV().listeners;
	while( curr != NULL )
	{
		if( curr->OnTestProgramEnd != NULL )
		{
			(*curr->OnTestProgramEnd)(unit_test);
		}
		curr = curr->next;
	}
}

/**
 * @brief	eXg̃ZbgAbv
*/
static void iuTestEnv_SetUp(iuTestEnv* test_env)
{
	iuUInt32 seed = test_env->option.random_seed;
	if( seed == 0 )
	{
		seed = iuTest_GetIndefiniteValue();
	}
	iuTestRandom_SetSeed(&test_env->random_context, seed);
	test_env->current_seed = seed;
}

/**
 * @brief	IvV񂩂ݒ蕶̐擪AhX擾
*/
static const char* iuTestEnv_ParseOptionSettingStr(const char* opt)
{
	const char* eq = iu_strchr(opt, '=');
	if( eq == NULL ) return eq;
	return eq+1;
}

/**
 * @brief	eXgtOݒ
*/
static void iuTestEnv_SetFlag(int enable, int mask)
{
	IIUT_C_TESTENV().flag |= enable;
	IIUT_C_TESTENV().flag &= mask;
}

/**
 * @brief	DISABLED eXgs邩ǂ
*/
static iuBOOL iuTestEnv_IsEnableRunDisabledTests(void)
{
	return IIUT_C_TESTENV().option.also_run_disabled_tests;
}

/**
 * @brief	VbteXgǂ
*/
static iuBOOL iuTestEnv_IsEnableShuffleTests(void)
{
	return IIUT_C_TESTENV().option.shuffle;
}

/**
 * @brief	eXgs BREAK 邩ǂ
*/
static iuBOOL iuTestEnv_IsEnableBreakOnFailure(void)
{
	return IIUT_C_TESTENV().option.break_on_failure;
}

/**
 * @brief	ԏo͂邩ǂ
*/
static iuBOOL iuTestEnv_IsEnablePrintTime(void)
{
	return IIUT_C_TESTENV().option.print_time;
}

/**
 * @brief	eXgtOLǂ
*/
static iuBOOL iuTestEnv_IsEnableFlag(int mask)
{
	return IIUT_C_TESTENV().flag & mask ? TRUE : FALSE;
}

static iuBOOL	iuTestEnv_IsYesOption(const char* option);
static iuBOOL	iuTestEnv_ParseOutputOption(const char* option);
static iuBOOL	iuTestEnv_ParseColorOption(const char* option);
static iuBOOL	iuTestEnv_ParseYesNoFlagOption(const char* option, iuBOOL* flag, int def);

/**
 * @brief	R}hC̉
*/
#ifdef UNICODE
#  define iuTestEnv_ParseCommandLine	iuTestEnv_ParseCommandLineW
#else
#  define iuTestEnv_ParseCommandLine	iuTestEnv_ParseCommandLineA
#endif

static iuBOOL	iuTestEnv_ParseCommandLineElemA(const char* arg)
{
	iuBOOL find = FALSE;
	if( arg == NULL ) return FALSE;
	if( *arg == '-' )
	{
		find = TRUE;
		++arg;
		if( *arg == '-' )
		{
			iuBOOL iuopt = TRUE;
			++arg;
			{
				const char* base = arg;
				const char* prefix = "iutest_";
				size_t i=0, n=iu_strlen(prefix);
				for( i=0; i < n; ++i, ++arg )
				{
					if( *arg != prefix[i] )
					{
						iuopt = FALSE;
						arg = base;
						break;
					}
				}
			}
			if( iuopt )
			{
				if( iu_strstr(arg, "filter") == arg )
				{
					const char* opt = iuTestEnv_ParseOptionSettingStr(arg);
					if( opt != NULL )
					{
						IUTEST_FLAG(filter) = opt;
						iuTestEnv_SetFlag(IUTESTENV_FILTERING_TESTS, -1);
					}
				}
				else if( iu_strstr(arg, "output") == arg )
				{
					find = iuTestEnv_ParseOutputOption(iuTestEnv_ParseOptionSettingStr(arg));
				}
				else if( iu_strstr(arg, "color") == arg )
				{
					find = iuTestEnv_ParseColorOption(iuTestEnv_ParseOptionSettingStr(arg));
				}
				else if( iuString_IsStringEqual(arg, "list_tests") )
				{
					iuTestEnv_SetFlag(IUTESTENV_SHOWTESTSLIST, -1);
				}
				else if( iuString_IsStringEqual(arg, "also_run_disabled_tests") )
				{
					IUTEST_FLAG(also_run_disabled_tests) = TRUE;
				}
				else if( iu_strstr(arg, "break_on_failure") == arg )
				{
					find = iuTestEnv_ParseYesNoFlagOption(arg, &IIUT_C_TESTENV().option.break_on_failure, 1);
				}
				else if( iuString_IsStringEqual(arg, "shuffle") )
				{
					IUTEST_FLAG(shuffle) = TRUE;
				}
				else if( iu_strstr(arg, "random_seed") == arg )
				{
					const char* opt = iuTestEnv_ParseOptionSettingStr(arg);
					if( opt != NULL )
					{
						IUTEST_FLAG(random_seed) = (unsigned int)iuString_ToInt(opt);
					}
					else
					{
						find = FALSE;
					}
				}
				else if( iu_strstr(arg, "print_time") == arg )
				{
					find = iuTestEnv_ParseYesNoFlagOption(arg, &IIUT_C_TESTENV().option.print_time, -1);
				}
				else if( iu_strstr(arg, "repeat") == arg )
				{
					const char* opt = iuTestEnv_ParseOptionSettingStr(arg);
					if( opt != NULL )
					{
						IUTEST_FLAG(repeat) = (int)iuString_ToInt(opt);
					}
					else
					{
						find = FALSE;
					}
				}
 				else
				{
					find = FALSE;
					iuTestEnv_SetFlag(IUTESTENV_SHOWHELP, -1);
				}
			}
			else
			{
				if( iuString_IsStringEqual(arg, "version") )
				{
					iuTestEnv_SetFlag(IUTESTENV_SHOWVER, -1);
				}
				else if( iuString_IsStringEqual(arg, "help") )
				{
					iuTestEnv_SetFlag(IUTESTENV_SHOWHELP, -1);
				}
				else if( iuString_IsStringEqual(arg, "feature") )
				{
					iuTestEnv_SetFlag(IUTESTENV_SHOWFEATURE, -1);
				}
 				else
				{
					find = FALSE;
				}
			}
		}
		else
		{
			if( iuString_IsStringEqual(arg, "v") )
			{
				iuTestEnv_SetFlag(IUTESTENV_SHOWVER, -1);
			}
			else if( iuString_IsStringEqual(arg, "h")
				|| iuString_IsStringEqual(arg, "?") )
			{
				iuTestEnv_SetFlag(IUTESTENV_SHOWHELP, -1);
			}
 			else
			{
				find = FALSE;
			}
		}
	}
	return find;
}

static void	iuTestEnv_ParseCommandLineA(int* pargc, char** argv)
{
	if( pargc == NULL ) return;
	if( argv == NULL ) return;

	{
		int i=0;
		int argc = *pargc;
		for( i=0; i < argc; )
		{
			if( iuTestEnv_ParseCommandLineElemA(argv[i]) )
			{
				int k=0;
				--argc;
				// ꍇAIvV𖖔Ɉړ
				for( k=i; k < argc; ++k )
				{
					char* tmp = argv[k];
					argv[k] = argv[k+1];
					argv[k+1] = tmp;
				}
			}
			else
			{
				++i;
			}
		}
		*pargc = argc;
	}
}

#if IUTEST_C_HAS_WCHAR_T
static iuBOOL	iuTestEnv_ParseCommandLineElemW(const wchar_t* arg)
{
	iuBOOL find = FALSE;
	if( arg == NULL ) return FALSE;
	if( *arg == L'-' )
	{
		find = TRUE;
		++arg;
		if( *arg == L'-' )
		{
			iuBOOL iuopt = TRUE;
			++arg;
			{
				const wchar_t* base = arg;
				const wchar_t* prefix = L"iutest_";
				size_t i=0, n=iu_wcslen(prefix);
				for( i=0; i < n; ++i, ++arg )
				{
					if( *arg != prefix[i] )
					{
						iuopt = FALSE;
						arg = base;
						break;
					}
				}
			}
			if( iuopt )
			{
				// not supproted
				iuTestEnv_SetFlag(IUTESTENV_SHOWHELP_AND_SORRY, -1);
			}
		}
	}
	return find;
}

static void	iuTestEnv_ParseCommandLineW(int* pargc, wchar_t** argv)
{
	if( pargc == NULL ) return;
	if( argv == NULL ) return;

	{
		int i=0;
		int argc = *pargc;
		for( i=0; i < argc; )
		{
			if( iuTestEnv_ParseCommandLineElemW(argv[i]) )
			{
				int k=0;
				--argc;
				// ꍇAIvV𖖔Ɉړ
				for( k=i; k < argc; ++k )
				{
					wchar_t* tmp = argv[k];
					argv[k] = argv[k+1];
					argv[k+1] = tmp;
				}
			}
			else
			{
				++i;
			}
		}
		*pargc = argc;
	}
}
#endif

static void iuTestEnv_LoadEnviromentVariable(void)
{
	{
		int var = 0;
		if( iuTestOS_GetEnvironmentInt("IUTEST_ALSO_RUN_DISABLED_TESTS", &var) )
		{
			IUTEST_FLAG(also_run_disabled_tests) = var ? TRUE : FALSE;
		}
		if( iuTestOS_GetEnvironmentInt("IUTEST_SHUFFLE", &var) )
		{
			IUTEST_FLAG(shuffle) = var ? TRUE : FALSE;
		}
		if( iuTestOS_GetEnvironmentInt("IUTEST_BREAK_ON_FAILURE", &var) )
		{
			IUTEST_FLAG(break_on_failure) = var ? TRUE : FALSE;
		}
		if( iuTestOS_GetEnvironmentInt("IUTEST_RANDOM_SEED", &var) )
		{
			IUTEST_FLAG(random_seed) = (unsigned int)var;
		}
		if( iuTestOS_GetEnvironmentInt("IUTEST_PRINT_TIME", &var) )
		{
			IUTEST_FLAG(print_time) = var ? TRUE : FALSE;
		}
		if( iuTestOS_GetEnvironmentInt("IUTEST_REPEAT", &var) )
		{
			IUTEST_FLAG(repeat) = var;
		}
	}
	{
		char var[128] = {0};
		if( iuTestOS_GetEnvironmentVariable("IUTEST_COLOR", var, 128) )
		{
			iuTestEnv_ParseColorOption(var);
		}
	}
	{
		char path[260+32] = {0};
		if( iuTestOS_GetEnvironmentVariable("IUTEST_OUTPUT", path, sizeof(path)) )
		{
			iuTestEnv_ParseOutputOption(path);
		}
		if( iuTestOS_GetEnvironmentVariable("IUTEST_FILTER", path, sizeof(path)) )
		{
			static char f[260+32];
			iu_strcpy(f, path);
			IUTEST_FLAG(filter) = f;
		}
	}
}

/**
 * @brief	yes IvV
*/
static iuBOOL iuTestEnv_IsYesOption(const char* option)
{
	if( iuString_IsStringCaseEqual(option, "yes")
		|| iuString_IsStringCaseEqual(option, "y")
		|| iuString_IsStringCaseEqual(option, "on")
		|| iuString_IsStringCaseEqual(option, "true")
		|| iuString_IsStringCaseEqual(option, "t")
		|| iuString_IsStringEqual(option, "1") ) 
	{
		return TRUE;
	}
	return FALSE;
}
/**
 * @brief	no IvV
*/
static iuBOOL iuTestEnv_IsNoOption(const char* option)
{
	if( iuString_IsStringCaseEqual(option, "no")
		|| iuString_IsStringCaseEqual(option, "n")
		|| iuString_IsStringCaseEqual(option, "off")
		|| iuString_IsStringCaseEqual(option, "false")
		|| iuString_IsStringCaseEqual(option, "f")
		|| iuString_IsStringEqual(option, "0") ) 
	{
		return TRUE;
	}
	return FALSE;
}

/**
 * @brief	yes IvV no IvV̔
 * @param [in]	option	= IvV
 * @retval	< 0	= YȂ
 * @retval	0	= NO
 * @retval	> 0 = YES
*/
static int iuTestEnv_ParseYesNoOption(const char* option)
{
	if( option == NULL ) return -1;
	if( iuTestEnv_IsYesOption(option) ) return 1;
	if( iuTestEnv_IsNoOption(option) ) return 0;
	return -1;
}

static iuBOOL	iuTestEnv_ParseOutputOption(const char* option)
{
	if( option == NULL ) return FALSE;
	if( iu_strstr(option, "xml") != option ) return FALSE;

	iuTestEnv_SetFlag(IUTESTENV_OUTPUT_XML_REPORT, -1);

	{
IUTEST_PRAGMA_CRT_SECURE_WARN_DISABLE_BEGIN()
		const char* file = iu_strchr(option+3, ':');
		if( file != NULL )
		{
			iu_strcpy(IIUT_C_TESTENV().output_xml, file+1);
		}
		else
		{
			iu_strcpy(IIUT_C_TESTENV().output_xml, "test_detail.xml");
		}
IUTEST_PRAGMA_CRT_SECURE_WARN_DISABLE_END()
	}
	return TRUE;
}

static iuBOOL	iuTestEnv_ParseColorOption(const char* option)
{
	if( option == NULL ) return FALSE;

	if( iuTestEnv_IsYesOption(option) )
	{
		iuTestEnv_SetFlag(IUTESTENV_CONSOLECOLOR_ON, ~IUTESTENV_CONSOLECOLOR_OFF);
	}
	else if( iuTestEnv_IsNoOption(option) )
	{
		iuTestEnv_SetFlag(IUTESTENV_CONSOLECOLOR_OFF, ~IUTESTENV_CONSOLECOLOR_ON);
	}
	else if( iuString_IsStringCaseEqual(option, "auto") )
	{
		// auto
		iuTestEnv_SetFlag(0, ~(IUTESTENV_CONSOLECOLOR_ON|IUTESTENV_CONSOLECOLOR_OFF));
	}
	else if( iuString_IsStringCaseEqual(option, "ansi") )
	{
		// ansi
		iuTestEnv_SetFlag(IUTESTENV_CONSOLECOLOR_ON|IUTESTENV_CONSOLECOLOR_ANSI, ~IUTESTENV_CONSOLECOLOR_OFF);
	}
	else 
	{
		return FALSE;
	}
	return TRUE;
}

static iuBOOL	iuTestEnv_ParseYesNoFlagOption(const char* option, iuBOOL* flag, int def)
{
	const char* str = iuTestEnv_ParseOptionSettingStr(option);
	int yesno = str != NULL ? iuTestEnv_ParseYesNoOption(str) : def;
	if( yesno < 0 )
	{
		return FALSE;
	}
	*flag = yesno;
	return TRUE;
}

/**
 * @brief	iuTestGlobalEnvSetUp ̍쐬
*/
static iuTestGlobalEnvSetUp*	iuTestEnv_AllocGlobalEnvSetUp(void)
{
#if IUTEST_C_HAS_MALLOC
	return (iuTestGlobalEnvSetUp*)iu_malloc(sizeof(iuTestGlobalEnvSetUp));
#else
	iuTestGlobalEnvSetUp* ptr = NULL;
	IUTEST_C_AllocByPool(ptr, iuTestGlobalEnvSetUp, IUTEST_C_GLOBALENVSETUP_POOL_COUNT);
	return ptr;
#endif
}

/**
 * @brief	iuTestGlobalEnvTearDown ̍쐬
*/
static iuTestGlobalEnvTearDown*	iuTestEnv_AllocGlobalEnvTearDown(void)
{
#if IUTEST_C_HAS_MALLOC
	return (iuTestGlobalEnvTearDown*)iu_malloc(sizeof(iuTestGlobalEnvTearDown));
#else
	iuTestGlobalEnvTearDown* ptr = NULL;
	IUTEST_C_AllocByPool(ptr, iuTestGlobalEnvTearDown, IUTEST_C_GLOBALENVTEARDOWN_POOL_COUNT);
	return ptr;
#endif
}

#endif
