//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_info_c.h
 * @brief		iris unit test info t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_info_c_H_A3DF31D4_5FC6_4c62_BCF6_EF835E47B10A_
#define INCG_IRIS_iutest_info_c_H_A3DF31D4_5FC6_4c62_BCF6_EF835E47B10A_

//======================================================================
// include
#include "iutest_body_c.h"
#include "iutest_env_c.h"
#include "internal/iutest_regex_c.h"

//======================================================================
// declare
struct iuTestCase_t;

//======================================================================
// enum
typedef enum IUTESTINFO_FLAG
{
	IUTESTINFO_SHOULD_NOTRUN	= 0x00000001,	//!< s邩ǂ
	IUTESTINFO_DISABLED			= 0x00000002,	//!< ǂ
	IUTESTINFO_RAN				= 0x00000010,	//!< sǂ
} IUTESTINFO_FLAG;

//======================================================================
// struct
/**
 * @brief	TestInfo \
*/
typedef struct iuTestInfo_t
{
	const char*		name;	//!< eXg
	iuTest			test;	//!< eXg{
	iuUInt32		flag;	//!< bit tO
	const char*		testcase_name;	//!< eXgP[X
	iuTestResult	result;	//!< eXg
	struct iuTestInfo_t		*next;	//!< ̃m[h
} iuTestInfo;

//======================================================================
// define
/** @private */
#define iuTestInfo_ctor(name, body)	{ name, iuTest_ctor(body), 0, NULL, iuTestResult_ctor(), NULL }

//======================================================================
// declare
static iuBOOL iuTestInfo_IsShouldRunTest(iuTestInfo* test_info);

//======================================================================
// function
/**
 * @brief	TestBody ̎s
*/
static iuBOOL iuTestInfo_Run(struct iuTestCase_t* test_case, iuTestInfo* test_info)
{
	if( test_info == NULL ) return FALSE;
	if( !iuTestInfo_IsShouldRunTest(test_info) ) return TRUE;

	test_info->flag |= IUTESTINFO_RAN;

	iuUnitTest_SetCurrentTestInfo(test_info);
	iuTestEnv_ListenerEvent_OnTestStart(test_case, test_info);

	{
		iuTestStopWatch watch;
		iuTest_StopWatchStart(&watch);

		if( test_info->test.setup != NULL )
		{
			(*test_info->test.setup)();
		}
		if( test_info->test.body != NULL )
		{
			(*test_info->test.body)();
		}
		if( test_info->test.teardown != NULL )
		{
			(*test_info->test.teardown)();
		}

		test_info->result.elapsedmsec = iuTest_StopWatchStop(&watch);
	}
	iuTestEnv_ListenerEvent_OnTestEnd(test_case, test_info);

	return test_info->result.result;
}

/**
 * @brief	sǂ
*/
static iuBOOL iuTestInfo_IsShouldRunTest(iuTestInfo *test_info)
{
	return test_info->flag & IUTESTINFO_SHOULD_NOTRUN ? FALSE : TRUE;
}

/**
 * @brief	sǂ
*/
static iuBOOL iuTestInfo_IsRanTest(iuTestInfo *test_info)
{
	return test_info->flag & IUTESTINFO_RAN ? TRUE : FALSE;
}

/**
 * @brief	sǂ
*/
static iuBOOL iuTestInfo_HasFailure(iuTestInfo *test_info)
{
	//if( !iuTestInfo_IsRanTest(test_info) ) return FALSE;
	return iuTestResult_IsFailed(&test_info->result);
}

/**
 * @brief	ǂ
*/
static iuBOOL iuTestInfo_IsDisabledTest(iuTestInfo *test_info)
{
	return test_info->flag & IUTESTINFO_DISABLED ? TRUE : FALSE;
}

/**
 * @brief	Ԃ̃NA
*/
static void iuTestInfo_Clear(iuTestInfo* test_info)
{
	test_info->flag &= ~IUTESTINFO_RAN;
}

/**
 * @brief	eXg̃tB^O
*/
static void iuTestInfo_Filter(iuTestInfo *test_info)
{
	if( test_info != NULL )
	{
		iuBOOL bRun = TRUE;
		if( !iuTestEnv_IsEnableRunDisabledTests() 
			&& iuTestInfo_IsDisabledTest(test_info) )
		{
			bRun = FALSE;
		}
		if( IUTEST_FLAG(filter) != NULL )
		{
			char fullname[256];
			iu_strcpy(fullname, test_info->testcase_name);
			iu_strcat(fullname, ".");
			iu_strcat(fullname, test_info->name);
			if( !iuTestRegex_Match(IUTEST_FLAG(filter), fullname) )
			{
				bRun = FALSE;
			}
		}
		if( bRun )
		{
			test_info->flag &= ~IUTESTINFO_SHOULD_NOTRUN;
		}
		else
		{
			test_info->flag |= IUTESTINFO_SHOULD_NOTRUN;
		}
	}
}

#endif
