//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_static_assertion_c.h
 * @brief		iris unit test static assertion ` t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_static_assertion_C_H_53842FD6_9E5D_40a6_905D_EC6DEBE5ED6A_
#define INCG_IRIS_iutest_static_assertion_C_H_53842FD6_9E5D_40a6_905D_EC6DEBE5ED6A_

//======================================================================
// include

//======================================================================
// define
/**
 * @brief	static_assert
*/
#define IUTEST_STATIC_ASSERT_MSG(B, Msg)	\
	typedef char IUTEST_PP_CAT(static_assert_typedef_, __LINE__)[(iuBOOL)( B ) ? 1 : -1]

/**
 * @brief	static_assert
*/
#ifdef IUTEST_NO_VARIADIC_MACROS
#  define IUTEST_STATIC_ASSERT(B)		IUTEST_STATIC_ASSERT_MSG(B, "")
#else
#  define IUTEST_STATIC_ASSERT(...)		IUTEST_STATIC_ASSERT_MSG((__VA_ARGS__), "")
#endif

#endif
