/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_result_c.h
 * @brief		iris unit test result t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_IRIS_iutest_result_C_H_D27B1599_F42F_4e2d_B3EB_FACE24C2B921_
#define INCG_IRIS_iutest_result_C_H_D27B1599_F42F_4e2d_B3EB_FACE24C2B921_

/* include ===========================================================*/
#include "internal/iutest_message_c.h"
#include "internal/iutest_console_c.h"

/* declare ===========================================================*/
struct iuTestPartResult_t;
struct iuTestResult_t;
struct iuTestProperty_t;

/* enum ==============================================================*/
/**
 * @brief	ʂ̃^Cv
*/
typedef enum eTestResultType
{
	kTestResultWarning = -1,	/*!< x */
	kTestResultSuccess,			/*!<  */
	kTestResultNotFatalFailure,	/*!< vIł͂Ȃs */
	kTestResultFatalFailure		/*!< vIȎs */
} eTestResultType;

/* struct ============================================================*/
/**
 * @brief	eXg̕
*/
typedef struct iuTestPartResult_t
{
	eTestResultType		type;			/*!<  */
	const char*			message;		/*!< bZ[W */
	const char*			file;			/*!< t@C */
	int					line;			/*!< t@CC */
	struct iuTestPartResult_t	*next;	/*!<  */
} iuTestPartResult;

/**
 * @brief	vpeB
*/
typedef struct iuTestProperty_t
{
	const char*	key;				/*!< O */
	const char*	value;				/*!< l */
	struct iuTestProperty_t *next;	/*!<  */
} iuTestProperty;

/**
 * @brief	eXg
*/
typedef struct iuTestResult_t
{
	iuBOOL				result;			/*!<  */
	iuTestPartResult	*list;			/*!< ʃXg */
	iuTestProperty		*properties;	/*!< vpeBXg */
	iuTimeInMillisec	elapsedmsec;	/*!< s */
} iuTestResult;

/* define ============================================================*/
/** @private */
#define iuTestResult_ctor()	{ TRUE, NULL, NULL, 0 }

/* declare ===========================================================*/
static iuTestPartResult*	iuTestResult_AllocTestPartResult(void);

/* function ==========================================================*/

/**
 * @brief	TestPartResult ̍쐬
*/
static iuTestPartResult*	iuTestResult_CreatePartResult(const char* file, int line, const char* message, eTestResultType type)
{
	iuTestPartResult* part = iuTestResult_AllocTestPartResult();
	if( part == NULL ) return NULL;
	iu_memset(part, 0, sizeof(iuTestPartResult));
	part->file = file;
	part->line = line;
	part->message = message;	/* mۂꂽ̂Ƃ */
	part->type = type;
	return part;
}

/**
 * @brief	eXgʂ̒ǉ
*/
static void iuTestResult_AddPartResult(iuTestResult *result, iuTestPartResult *part)
{
	if( result == NULL ) return;
	if( part == NULL ) return;
	iuTestHelper_AddList(iuTestPartResult, result->list, part);
}

/**
 * @brief	eXgʂ̎擾
*/
static iuBOOL	iuTestPartResult_IsFailed(iuTestPartResult *result)
{
	if( result == NULL ) return FALSE;
	if( result->type != kTestResultSuccess && result->type != kTestResultWarning ) return TRUE;
	return FALSE;
}

/**
 * @brief	eXgʂ̎擾
*/
static iuBOOL	iuTestResult_IsFailed(iuTestResult *result)
{
	if( result == NULL ) return FALSE;

	{
		iuTestPartResult *curr = result->list;
		while( curr != NULL )
		{
			if( iuTestPartResult_IsFailed(curr) ) return TRUE;
			curr = curr->next;
		}
	}
	return FALSE;
}

/**
 * @private
 * @brief	eXgʃbZ[W̍쐬
*/
static const char* iuTestResult_PartMessage(char* buf, const iuTestPartResult *test_part_result)
{
	if( buf != NULL )
	{
		if( test_part_result == NULL )
		{
			buf[0] = 0;
		}
		else
		{
			iuTest_FormatCompilerFileLocation(buf, test_part_result->file, test_part_result->line);
			iu_strcat(buf, ":");
			iu_strcat(buf, test_part_result->message);
			iu_strcat(buf, "\n");
		}
	}
	return buf;
}

/**
 * @private
 * @brief	TestPartResult ̍쐬
*/
static iuTestPartResult *	iuTestResult_AllocTestPartResult(void)
{
#if IUTEST_C_HAS_MALLOC
	return (iuTestPartResult *)iu_malloc(sizeof(iuTestPartResult));
#else
	iuTestPartResult *ptr = NULL;
	IUTEST_C_AllocByPool(ptr, iuTestPartResult, IUTEST_C_TESTPARTRESULT_POOL_COUNT);
	return ptr;
#endif
}

/**
 * @private
 * @brief	TestProperty ̍쐬
*/
static iuTestProperty *	iuTestResult_AllocTestProperty(void)
{
#if IUTEST_C_HAS_MALLOC
	return (iuTestProperty *)iu_malloc(sizeof(iuTestProperty));
#else
	iuTestProperty *ptr = NULL;
	IUTEST_C_AllocByPool(ptr, iuTestProperty, IUTEST_C_TESTPROPERTY_POOL_COUNT);
	return ptr;
#endif
}

#endif
