/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_console_c.h
 * @brief		iris unit test console t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_IRIS_iutest_console_C_H_5D02AA77_5C25_4919_BDEC_CD32EB5774C8_
#define INCG_IRIS_iutest_console_C_H_5D02AA77_5C25_4919_BDEC_CD32EB5774C8_

/* include ===========================================================*/
#include "iutest_port_c.h"
#include "../iutest_env_c.h"

/* define ============================================================*/
#ifndef IUTEST_VPRINTF
#  if IUTEST_C_HAS_LIBC
#    define IUTEST_VPRINTF(f, a)	vprintf(f, a)
#  else
#    define IUTEST_VPRINTF(f, a)	(void)0
#  endif
#endif

#ifndef IUTEST_HAS_COLORCONSOLE
#  if defined(IUTEST_OS_WINDOWS_MOBILE) || defined(IUTEST_OS_NACL)
#    define IUTEST_HAS_COLORCONSOLE	0	/*!< F^[~igp\ǂ */
#  else
#    define IUTEST_HAS_COLORCONSOLE	1	/*!< F^[~igp\ǂ */
#  endif
#endif

/* enum ==============================================================*/
/**
 * @internal
 * @brief	F
*/
typedef enum iuConsoleColor
{
	PRINT_BLACK,
	PRINT_RED,
	PRINT_GREEN,
	PRINT_YELLOW,
	PRINT_BLUE,
	PRINT_MAGENTA,
	PRINT_CYAN,
	PRINT_WHITE
} iuConsoleColor;

/* function ==========================================================*/
/**
 * @brief	Wo
*/
static void	IUTEST_ATTRIBUTE_UNUSED_ iuConsole_VPrint(const char *fmt, va_list va)
{
	if( iuTestEnv_GetInstance()->pfnvpritf != NULL )
	{
		(void)(iuTestEnv_GetInstance()->pfnvpritf)(fmt, va);
	}
	else
	{
		IUTEST_UNUSED_VAR(fmt);
		IUTEST_UNUSED_VAR(va);
		IUTEST_VPRINTF(fmt, va);
	}
}

/**
 * @brief	Wo
*/
static void	IUTEST_ATTRIBUTE_UNUSED_ iuConsole_Output(const char *fmt, ...)
{
	va_list va;
	va_start(va, fmt);
	iuConsole_VPrint(fmt, va);
	va_end(va);
}

/**
 * @brief	Wo
*/
static void	IUTEST_ATTRIBUTE_UNUSED_ iuConsole_Print(const char *buf)
{
	iuConsole_Output(buf);
}

/**
 * @brief	FwŕWo
 * @param [in]	color	= F
*/
static void	IUTEST_ATTRIBUTE_UNUSED_ iuConsole_ColorOutputV(int color, const char *fmt, va_list va)
{
#if defined(IUTEST_OS_WINDOWS) && !defined(IUTEST_OS_WINDOWS_MOBILE)
	const WORD attr[] = {
		0,
		FOREGROUND_RED,
		FOREGROUND_GREEN,
		FOREGROUND_GREEN | FOREGROUND_RED,
		FOREGROUND_BLUE,
		FOREGROUND_RED | FOREGROUND_BLUE,
		FOREGROUND_GREEN | FOREGROUND_BLUE,
		FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE
	};
	const HANDLE stdout_handle = GetStdHandle(STD_OUTPUT_HANDLE);
	CONSOLE_SCREEN_BUFFER_INFO csbi;
	GetConsoleScreenBufferInfo(stdout_handle, &csbi);
	{
		const WORD wAttributes = csbi.wAttributes;

		fflush(stdout);
		SetConsoleTextAttribute(stdout_handle, attr[color] | FOREGROUND_INTENSITY);

		iuConsole_VPrint(fmt, va);

		fflush(stdout);
		SetConsoleTextAttribute(stdout_handle, wAttributes);
	}
#else
	const char c = (char)('0' + color);
	IUTEST_UNUSED_VAR(color);
	IUTEST_UNUSED_VAR(fmt);
	IUTEST_UNUSED_VAR(va);

	iuConsole_Output("\033[1;3%cm", c);
	iuConsole_VPrint(fmt, va);
	iuConsole_Output("\033[m");
#endif
}

static iuBOOL IUTEST_ATTRIBUTE_UNUSED_ iuConsole_IsShouldUseColor(iuBOOL use_color);

/**
 * @brief	FwŕWo
 * @param [in]	color	= F
*/
static void	IUTEST_ATTRIBUTE_UNUSED_ iuConsole_ColorOutput(int color, const char *fmt, ...)
{
	va_list va;
	va_start(va, fmt);
	if( iuConsole_IsShouldUseColor(TRUE) )
	{
		iuConsole_ColorOutputV(color, fmt, va);
	}
	else
	{
		iuConsole_VPrint(fmt, va);
	}
	va_end(va);
}


static iuBOOL IUTEST_ATTRIBUTE_UNUSED_ iuConsole_IsColorModeOff(void)
{
	return iuTestEnv_IsEnableFlag(IUTESTENV_CONSOLECOLOR_OFF);
}
static iuBOOL IUTEST_ATTRIBUTE_UNUSED_ iuConsole_IsColorModeOn(void)
{
	return iuTestEnv_IsEnableFlag(IUTESTENV_CONSOLECOLOR_ON);
}
static iuBOOL IUTEST_ATTRIBUTE_UNUSED_ iuConsole_IsColorModeAnsi(void)
{
	return iuTestEnv_IsEnableFlag(IUTESTENV_CONSOLECOLOR_ANSI);
}

static iuBOOL IUTEST_ATTRIBUTE_UNUSED_ iuConsole_IsShouldUseColor(iuBOOL use_color)
{
	if( iuConsole_IsColorModeOn() )
	{
		return TRUE;
	}
	else if( iuConsole_IsColorModeOff() )
	{
		return FALSE;
	}

#if defined(IUTEST_OS_WINDOWS)
	return use_color;
#else
	{
		const char* env = iuTestOS_GetEnv("TERM");
		iuBOOL term_conf = (env != NULL) && (
			iuString_IsStringEqual(env, "xterm")
			|| iuString_IsStringEqual(env, "xterm-color")
			|| iuString_IsStringEqual(env, "xterm-256color")
			|| iuString_IsStringEqual(env, "screen")
			|| iuString_IsStringEqual(env, "screen-256color")
			|| iuString_IsStringEqual(env, "linux")
			|| iuString_IsStringEqual(env, "cygwin")
			);
		return use_color && term_conf;
	}
#endif
}

#endif
