/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_defs_c.h
 * @brief		iris unit test def t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_IRIS_iutest_defs_c_H_C65D73ED_BE82_4b01_8B5D_756A3C887B9A_
#define INCG_IRIS_iutest_defs_c_H_C65D73ED_BE82_4b01_8B5D_756A3C887B9A_

/* include ===========================================================*/
#include "internal/iutest_internal_defs_c.h"

/* define ============================================================*/
/**
 * @defgroup	IUTEST_CONFIG	IUTEST_CONFIG
 * @brief		ݒ}N
 * @note		[U[O`邱ƂŕύX\
 * @{
*/

#ifndef IUTEST_C_HAS_PARAM_METHOD_TEST
#  if IUTEST_C_HAS_VARIADIC_MACROS
#    define IUTEST_C_HAS_PARAM_METHOD_TEST	1
#  else
#    define IUTEST_C_HAS_PARAM_METHOD_TEST	0
#  endif
#endif

#ifdef IUTEST_BUILD_DOXYGEN

#define IUTEST_C_NO_FLOATINGPOINT	/*!< _gȂꍇ͒` */
#define IUTEST_C_NO_WCHAR_T			/*!< wchar_t Ȃꍇ͒` */
#define IUTEST_C_NO_STDARG			/*!< stdarg.h Ȃꍇ͒` */
#define IUTEST_C_NO_LIBC			/*!< libc gȂꍇ͒` */
#define IUTEST_C_NO_MALLOC			/*!< malloc Ȃꍇ͒` */
#define IUTEST_C_NO_LONGLONG		/*!< long long gȂꍇ */
#define IUTEST_C_NO_GETENV			/*!< getenv Ȃꍇ */
#define IUTEST_C_NO_PUTENV			/*!< putenv Ȃꍇ */

#endif

#if !IUTEST_C_HAS_MALLOC

/** malloc gȂꍇ TestResult  Pool  */
#ifndef IUTEST_C_TESTPARTRESULT_POOL_COUNT
#  define IUTEST_C_TESTPARTRESULT_POOL_COUNT	512
#endif

/** malloc gȂꍇ TestProerty  Pool  */
#ifndef IUTEST_C_TESTPROPERTY_POOL_COUNT
#  define IUTEST_C_TESTPROPERTY_POOL_COUNT		128
#endif

/** malloc gȂꍇ TestListner  Pool  */
#ifndef IUTEST_C_LISTENER_POOL_COUNT
#  define IUTEST_C_LISTENER_POOL_COUNT			8
#endif

/** malloc gȂꍇ iuTestGlobalEnvSetUp  Pool  */
#ifndef IUTEST_C_GLOBALENVSETUP_POOL_COUNT
#  define IUTEST_C_GLOBALENVSETUP_POOL_COUNT	8
#endif

/** malloc gȂꍇ iuTestGlobalEnvTearDown  Pool  */
#ifndef IUTEST_C_GLOBALENVTEARDOWN_POOL_COUNT
#  define IUTEST_C_GLOBALENVTEARDOWN_POOL_COUNT	8
#endif

/** malloc gȂꍇ eXgbZ[Wobt@  Pool  */
#ifndef IUTEST_C_TESTMSGBUFFER_POOL_COUNT
#  define IUTEST_C_TESTMSGBUFFER_POOL_COUNT		16*1024
#endif

#endif

/**
 * @}
*/

#define IUTEST_SUPPRESS_UNREACHABLE_CODE_WARNING(statement)	if( iuAlwaysTrue() ) statement

/* typedef ===========================================================*/
typedef signed char		iuInt8;
typedef unsigned char	iuUInt8;
typedef signed short	iuInt16;
typedef unsigned short	iuUInt16;
typedef long			iuInt32;
typedef unsigned long	iuUInt32;

#if IUTEST_C_HAS_LONGLONG

#if defined(_MSC_VER)
typedef __int64				iuInt64;
typedef unsigned __int64	iuUInt64;
#else
typedef long long			iuInt64;
typedef unsigned long long	iuUInt64;
#endif

typedef iuUInt64	iuTimeInMillisec;

#else

typedef iuUInt32	iuTimeInMillisec;

typedef struct iuUInt64
{
	iuUInt32	lo;
	iuUInt32	hi;
} iuUInt64, iuInt64;

#endif


/* strict ============================================================*/

#if IUTEST_C_HAS_FLOATINGPOINT

typedef union iuF32Int
{
	float fv;
	iuInt32 iv;
	iuUInt32 uv;
} iuF32Int;

typedef union iuF64Int
{
	double fv;
	iuInt64 iv;
	iuUInt64 uv;
} iuF64Int;

/* function ==========================================================*/
/**
 * @brief	float ̂܂r
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuBOOL	iuAlmostFloatEquals(float val1, float val2)
{
	iuF32Int fi1, fi2;
	fi1.fv = val1;
	fi2.fv = val2;
	{
		const iuInt32 kMaxUlps = 4;
		const iuInt32 v1 = fi1.iv < 0 ? ~fi1.iv + 1 : fi1.iv;
		const iuInt32 v2 = fi2.iv < 0 ? ~fi2.iv + 1 : fi2.iv;
		const iuInt32 diff = (v1 > v2) ? v1 - v2 : v2 - v1;
		if( diff <= kMaxUlps ) return TRUE;
	}
	return FALSE;
}

/**
 * @brief	double ̂܂r
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuBOOL iuAlmostDoubleEquals(double val1, double val2)
{
	iuF64Int fi1, fi2;
	fi1.fv = val1;
	fi2.fv = val2;
	{
#if IUTEST_C_HAS_LONGLONG
		const iuInt64 kMaxUlps = 4;
		const iuInt64 v1 = fi1.iv < 0 ? ~fi1.iv + 1 : fi1.iv;
		const iuInt64 v2 = fi2.iv < 0 ? ~fi2.iv + 1 : fi2.iv;
		const iuInt64 diff = (v1 > v2) ? v1 - v2 : v2 - v1;
		if( diff <= kMaxUlps ) return TRUE;
#else
		const iuInt32 kMaxUlps = 4;
		if( fi1.iv.hi == fi2.iv.hi )
		{
			const iuInt32 v1 = fi1.iv.lo < 0 ? ~fi1.iv.lo + 1 : fi1.iv.lo;
			const iuInt32 v2 = fi2.iv.lo < 0 ? ~fi2.iv.lo + 1 : fi2.iv.lo;
			const iuInt32 diff = (v1 > v2) ? v1 - v2 : v2 - v1;
			if( diff <= kMaxUlps ) return TRUE;
		}
#endif
	}
	return FALSE;
}

#endif

#endif
