/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_core_c.h
 * @brief		iris unit test core t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_IRIS_iutest_core_c_H_5D8217F4_1A99_4dd8_A103_7DCBCA25ABAE_
#define INCG_IRIS_iutest_core_c_H_5D8217F4_1A99_4dd8_A103_7DCBCA25ABAE_

/* include ===========================================================*/
#include "iutest_case_c.h"
#include "internal/iutest_option_message_c.h"
#include "internal/iutest_internal_c.h"

/* define ============================================================*/
/**
 * @private
 * @{
*/
/* RACX^X */
#define IIUT_C_UNITTEST_NAME	g_iutest_c_unittest_instance
#define IIUT_C_UNITTEST()		IIUT_C_UNITTEST_NAME

/* [NXy[X̐ */
#define IIUT_C_WORKSPACE()								\
	iuUnitTest	IIUT_C_UNITTEST_NAME = { NULL, NULL, 0, iuTestResult_ctor(), iuTestListener_ctor(), iuTestListener_ctor(), 0 };	\
	iuTestEnv	IIUT_C_TESTENV_NAME = iuTestEnv_ctor()
/**
 * @}
*/


/* struct ============================================================*/
/**
 * @brief	eXgRA\
*/
typedef struct iuUnitTest_t
{
	iuTestCase*			list;				/*!< TestCase Xg */
	iuTestInfo*			current_test_info;	/*!< s TestInfo */
	iuTimeInMillisec	elapsedmsec;		/*!< s */
	iuTestResult		adhoc_testresult;	/*!< eXgsłȂƂ̃eXg */
	iuTestListener		def_printer;		/*!< ftHgPrinter */
	iuTestListener		def_xml_generator;	/*!< ftHgXMLo */
	int					initialized_count;	/*!<  */
} iuUnitTest;

/**
 * @brief	eXgtBNX`
*/
typedef struct iuTestFixture_t
{
	const iuTestSetUpTestCase		setup_testcase;
	const iuTestTearDownTestCase	teardown_testcase;
	const iuTestSetUp		setup;
	const iuTestTearDown	teardown;
} iuTestFixture;

/* extern ============================================================*/
extern iuUnitTest	IIUT_C_UNITTEST_NAME;

/* declare ===========================================================*/
static iuTestCase*	iuUnitTest_AddTestCase(const char* testcase_name
						, iuTestSetUpTestCase setup, iuTestTearDownTestCase teardown, iuTest_AllocTestCase pfnAlloc);
static iuTestCase*	iuUnitTest_FindTestCase(const char* testcase_name);
static int			iuTestRun_Run(iuUnitTest *unit_test);
static void			iuTestRun_TestProgramStart(iuUnitTest *unit_test);
static void			iuTestRun_TestProgramEnd(iuUnitTest *unit_test);
static int			iuTest_ShowTestList(const iuUnitTest* unit_test);

/* function ==========================================================*/
/**
 * @brief	eXgǗCX^X̎擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuUnitTest* iuUnitTest_GetInstance(void)
{
	return &IIUT_C_UNITTEST();
}

/**
 * @brief	vprintf ֐|C^ݒ
*/
static IUTEST_ATTRIBUTE_UNUSED_ void iuUnitTest_SetVPrintfFunction(iuVPrintf proc)
{
	iuTestEnv_SetVPrintfFunction(iuTestEnv_GetInstance(), proc);
}

/**
 * @brief	TestListener ̒ǉ
*/
static iuBOOL	iuUnitTest_AddTestListener(iuTestListener* test_listener)
{
	return iuTestEnv_AddTestListener(iuTestEnv_GetInstance(), test_listener);
}

/**
 * @brief	GlobalEnvironmentSetUp ̒ǉ
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuBOOL	iuUnitTest_AddGlobalEnvironmentSetUp(iuGlobalEnvironmentSetUp func)
{
	return iuTestEnv_AddGlobalEnvironmentSetUp(iuTestEnv_GetInstance(), func);
}

/**
 * @brief	GlobalEnvironmentTearDown ̒ǉ
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuBOOL	iuUnitTest_AddGlobalEnvironmentTearDown(iuGlobalEnvironmentTearDown func)
{
	return iuTestEnv_AddGlobalEnvironmentTearDown(iuTestEnv_GetInstance(), func);
}

/**
 * @biref	eXg̏
*/
static IUTEST_ATTRIBUTE_UNUSED_ void iuUnitTest_Init(void)
{
	/*
	if( IIUT_C_UNITTEST().initialized_count == 0 )
	{

	}
	*/
	++IIUT_C_UNITTEST().initialized_count;
}

/**
 * @biref	eXg̎s
*/
static IUTEST_ATTRIBUTE_UNUSED_ int iuUnitTest_Run(void)
{
	if( IIUT_C_UNITTEST().initialized_count == 0 )
	{
		return iuTest_ShowNotinitializedWarning();
	}
	if( iuTestEnv_IsEnableFlag(IUTESTENV_SHOWVER) )
	{
		return iuTest_ShowVersion();
	}
	if( iuTestEnv_IsEnableFlag(IUTESTENV_SHOWHELP) )
	{
		return iuTest_ShowHelp();
	}
	if( iuTestEnv_IsEnableFlag(IUTESTENV_SHOWHELP_AND_SORRY) )
	{
		return iuTest_ShowHelpAndSorry();
	}
	if( iuTestEnv_IsEnableFlag(IUTESTENV_SHOWFEATURE) )
	{
		return iuTest_ShowFeature();
	}
	if( iuTestEnv_IsEnableFlag(IUTESTENV_SHOWTESTSLIST) )
	{
		return iuTest_ShowTestList(&IIUT_C_UNITTEST());
	}

	return iuTestRun_Run(&IIUT_C_UNITTEST());
}

/**
 * @biref	eXgP[X̌
*/
static iuTestCase* iuUnitTest_FindTestCase(const char* testcase_name)
{
	iuTestCase* curr = IIUT_C_UNITTEST().list;
	while( curr != NULL )
	{
		if( iuString_IsStringEqual(testcase_name, curr->name) ) return curr;
		curr = curr->next;
	}
	return NULL;
}

/**
 * @brief	ݎs TestInfo 擾
*/
static iuTestInfo*	iuUnitTest_GetCurrentTestInfo(void)
{
	return IIUT_C_UNITTEST().current_test_info;
}

/**
 * @private
 * @brief	ݎs TestInfo ̐ݒ
*/
static void	iuUnitTest_SetCurrentTestInfo(struct iuTestInfo_t* curr)
{
	IIUT_C_UNITTEST().current_test_info = curr;
}

/**
 * @brief	ݎs̃eXg TestResult 擾
*/
static iuTestResult*	iuUnitTest_GetCurrentTestResult(void)
{
	return iuUnitTest_GetCurrentTestInfo() == NULL ? &iuUnitTest_GetInstance()->adhoc_testresult : &iuUnitTest_GetCurrentTestInfo()->result;
}

/**
 * @brief	V[h̎擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuUInt32 iuUnitTest_GetCurrentRandomSeed(void)
{
	return iuTestEnve_GetCurrentRandomSeed();
}

/**
 * @brief	eXgP[X̑擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ int iuUnitTest_GetTotalTestCaseCount(const iuUnitTest* unit_test)
{
	int cnt = 0;
	iuTestHelper_CountList(cnt, iuTestCase, unit_test->list);
	return cnt;
}

/**
 * @brief	sΏۂ̃eXgP[X̑擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ int iuUnitTest_GetTestCaseToRunCount(const iuUnitTest* unit_test)
{
	int cnt = 0;
	const iuTestCase* curr = unit_test->list;
	while( curr != NULL )
	{
		if( iuTestCase_HasShouldRunTest(curr) ) ++cnt;
		curr = curr->next;
	}
	return cnt;
}

/**
 * @brief	eXg̑擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ int iuUnitTest_GetTotalTestCount(const iuUnitTest* unit_test)
{
	int cnt = 0;
	const iuTestCase* curr = unit_test->list;
	while( curr != NULL )
	{
		cnt += iuTestCase_GetTotalTestCount(curr);
		curr = curr->next;
	}
	return cnt;
}

/**
 * @brief	sΏۂ̃eXg̑擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ int iuUnitTest_GetTestToRunCount(const iuUnitTest* unit_test)
{
	int cnt = 0;
	const iuTestCase* curr = unit_test->list;
	while( curr != NULL )
	{
		cnt += iuTestCase_GetTestToRunCount(curr);
		curr = curr->next;
	}
	return cnt;
}

/**
 * @brief	eXg̑擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ int iuUnitTest_GetSuccessfulTestCount(const iuUnitTest* unit_test)
{
	int cnt = 0;
	const iuTestCase* curr = unit_test->list;
	while( curr != NULL )
	{
		cnt += iuTestCase_GetSuccessfulTestCount(curr);
		curr = curr->next;
	}
	return cnt;
}

/**
 * @brief	seXg̑擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ int iuUnitTest_GetFailureTestCount(const iuUnitTest* unit_test)
{
	int cnt = 0;
	const iuTestCase* curr = unit_test->list;
	while( curr != NULL )
	{
		cnt += iuTestCase_GetFailureTestCount(curr);
		curr = curr->next;
	}
	return cnt;
}

/**
 * @brief	eXg̑擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ int iuUnitTest_GetDisableTestCount(const iuUnitTest* unit_test)
{
	int cnt = 0;
	const iuTestCase* curr = unit_test->list;
	while( curr != NULL )
	{
		cnt += iuTestCase_GetDisableTestCount(curr);
		curr = curr->next;
	}
	return cnt;
}

/**
 * @brief	XLbveXg̑擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ int iuUnitTest_GetSkippedTestCount(const iuUnitTest* unit_test)
{
	int cnt = 0;
	const iuTestCase* curr = unit_test->list;
	while( curr != NULL )
	{
		cnt += iuTestCase_GetSkippedTestCount(curr);
		curr = curr->next;
	}
	return cnt;
}

/**
 * @brief	eXgʂ̎擾
*/
static iuBOOL iuUnitTest_IsFaild(const iuUnitTest* unit_test)
{
	if( !unit_test->adhoc_testresult.result ) return TRUE;

	{
		const iuTestCase* curr = unit_test->list;
		while( curr != NULL )
		{
			if( iuTestCase_IsFaild(curr) ) return TRUE;
			curr = curr->next;
		}
	}
	return FALSE;
}

/**
 * @brief	eXgʂ̎擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuBOOL iuUnitTest_Passed(const iuUnitTest* unit_test)
{
	return !iuUnitTest_IsFaild(unit_test);
}

/**
 * @brief	V[h̎擾
*/
static IUTEST_ATTRIBUTE_UNUSED_ unsigned int iuUnitTest_GetRandomSeed(void)
{
	return iuTestEnv_GetInstance()->current_seed;
}

/**
 * @brief	eXg̃Xgo
*/
static IUTEST_ATTRIBUTE_UNUSED_ int iuTest_ShowTestList(const iuUnitTest* unit_test)
{
	iuConsole_Output("%d tests from %d testcase\n"
		, iuUnitTest_GetTotalTestCount(unit_test), iuUnitTest_GetTotalTestCaseCount(unit_test) );

	{
		iuTestCase* test_case = unit_test->list;
		while( test_case != NULL )
		{
			iuTestInfo* test_info = test_case->list;
			iuConsole_Output(test_case->name);
			iuConsole_Output("\n");
			while( test_info != NULL )
			{
				iuConsole_Output("  ");
				iuConsole_Output(test_info->name);
				iuConsole_Output("\n");
				test_info = test_info->next;
			}
			test_case = test_case->next;
		}
	}
	return 0;
}

/**
 * @private
 * @biref	O[o SetUp
*/
static void		iuTestRun_EnvironmentSetUp(iuUnitTest *unit_test)
{
	iuTestEnv_ListenerEvent_OnEnvironmentsSetUpStart(unit_test);
	iuTestEnv_GlobalEnvironmentSetUp();
	iuTestEnv_ListenerEvent_OnEnvironmentsSetUpEnd(unit_test);
}

/**
 * @private
 * @biref	O[o TearDown
*/
static void		iuTestRun_EnvironmentTearDown(iuUnitTest *unit_test)
{
	iuTestEnv_ListenerEvent_OnEnvironmentsTearDownStart(unit_test);
	iuTestEnv_GlobalEnvironmentTearDown();
	iuTestEnv_ListenerEvent_OnEnvironmentsTearDownEnd(unit_test);
}

/**
 * @private
 * @biref	eXg̎s
*/
static iuBOOL	iuTestRun_RunOnce(iuUnitTest *unit_test)
{
	iuBOOL ret = TRUE;

	if( iuTestEnv_IsEnableShuffleTests() )
	{
		iuTestHelper_ShuffleList(iuTestCase, iuTestRandom_Gen(&iuTestEnv_GetInstance()->random_context)
			, iuUnitTest_GetTotalTestCaseCount(unit_test), unit_test->list);
	}

	iuTestRun_EnvironmentSetUp(unit_test);

	{
		iuTestCase* curr = unit_test->list;

		iuTestStopWatch watch;
		iuTest_StopWatchStart(&watch);

		while( curr != NULL )
		{
			if( !iuTestCase_Run(curr) ) ret = FALSE;
			curr = curr->next;
		}

		unit_test->elapsedmsec = iuTest_StopWatchStop(&watch);
	}

	iuTestRun_EnvironmentTearDown(unit_test);
	return ret;
}

/**
 * @private
 * @biref	eXg̎s
*/
static iuBOOL		iuTestRun_Iteration(iuUnitTest *unit_test, int iteration)
{
	if( iuUnitTest_GetTestToRunCount(unit_test) != 0 )
	{
		iuBOOL ret = TRUE;
		iuTestEnv_SetUp(iuTestEnv_GetInstance());
		iuTestEnv_ListenerEvent_OnTestIterationStart(unit_test, iteration);

		if( !iuTestRun_RunOnce(unit_test) )
		{
			ret = FALSE;
		}
		iuTestEnv_ListenerEvent_OnTestIterationEnd(unit_test, iteration);
		return ret;
	}
	return iuUnitTest_Passed(unit_test);
}
/**
 * @private
 * @biref	eXg̎s
*/
static int			iuTestRun_Run(iuUnitTest *unit_test)
{
	iuBOOL result = TRUE; 
	int repeat = IUTEST_FLAG(repeat);
	if( repeat == 0 ) return 0;
	iuTestRun_TestProgramStart(unit_test);

	{
		int iteration = 0;
		while( repeat != 0 ) 
		{
			if( !iuTestRun_Iteration(unit_test, iteration) )
			{
				result = FALSE;
			}
			++iteration;
			if( repeat > 0 ) --repeat;
		}
	}

	iuTestRun_TestProgramEnd(unit_test);
	return result ? 0 : 1;
}

/**
 * @private
 * @biref	eXg̊Jn
*/
static void			iuTestRun_TestProgramStart(iuUnitTest *unit_test)
{
	iuTestEnv_ListenerEvent_OnTestProgramStart(unit_test);

	{
		/* tB^O */
		iuTestCase* curr = unit_test->list;
		while( curr != NULL )
		{
			iuTestCase_Clear(curr);
			iuTestCase_Filter(curr);
			curr = curr->next;
		}
	}
}

/**
 * @private
 * @biref	eXg̏I
*/
static void			iuTestRun_TestProgramEnd(iuUnitTest *unit_test)
{
	iuTestEnv_ListenerEvent_OnTestProgramEnd(unit_test);

	/* Еt */
	/*
	iuTestEnv_SubTestListener(iuTestEnv_GetInstance(), &unit_test->def_printer);
	*/
}

/**
 * @biref	eXgP[X̒ǉ
*/
static IUTEST_ATTRIBUTE_UNUSED_ iuTestCase*	iuUnitTest_AddTestCase(const char* testcase_name
									, iuTestSetUpTestCase setup, iuTestTearDownTestCase teardown, iuTest_AllocTestCase pfnAlloc)
{
	iuTestCase* test_case = iuUnitTest_FindTestCase(testcase_name);
	if( test_case == NULL )
	{
		test_case = (*pfnAlloc)();
		iu_memset(test_case, 0, sizeof(iuTestCase));
		test_case->name = testcase_name;
		test_case->setup = setup;
		test_case->teardown = teardown;
		test_case->flag = 0;
		if( iuString_IsDisabledTestName(testcase_name) )
		{
			test_case->flag |= IUTESTCASE_DISABLED;
		}
		iuTestHelper_AddList(iuTestCase, IIUT_C_UNITTEST().list, test_case);
	}
	return test_case;
}

#if IUTEST_C_HAS_MALLOC

static IUTEST_ATTRIBUTE_UNUSED_ iuTestCase* iuUnitTest_AllocTestCase(void)
{
	return (iuTestCase*)iu_malloc(sizeof(iuTestCase));
}

#endif

#endif
