//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_listener.hpp
 * @brief		iris unit test CxgXi[ ` t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_listener_HPP_C94B8142_F8B3_413f_B479_8AA2B78604CE_
#define INCG_IRIS_iutest_listener_HPP_C94B8142_F8B3_413f_B479_8AA2B78604CE_

//======================================================================
// include
#include <vector>
#include <algorithm>

namespace iutest
{

//======================================================================
// declare
class UnitTest;
class TestInfo;
class TestCase;
class TestPartResult;
class TestProperty;

namespace detail
{
	class DefaultGlobalTestPartResultReporter;
}

/**
 * @brief	CxgXi[
*/
class TestEventListener
{
	IUTEST_PP_DISALLOW_COPY_AND_ASSIGN(TestEventListener);
public:
	TestEventListener(void) {}
	virtual ~TestEventListener(void)	{}
public:
	virtual void OnTestProgramStart(const UnitTest& test)			= 0;	//!< eXgvOJnɌĂ΂܂
	virtual void OnTestIterationStart(const UnitTest& test
									, int iteration)				= 0;	//!< P̃eXgJnɖĂ΂܂
	virtual void OnEnvironmentsSetUpStart(const UnitTest& test)		= 0;	//!< O[oݒ SetUp OɌĂ΂܂
	virtual void OnEnvironmentsSetUpEnd(const UnitTest& test)		= 0;	//!< O[oݒ SetUp ɌĂ΂܂
	virtual void OnTestCaseStart(const TestCase& test_case)			= 0;	//!< eXgP[XJnɌĂ΂܂
	virtual void OnTestStart(const TestInfo& test_info)				= 0;	//!< eXgJnɌĂ΂܂
	virtual void OnTestPartResult(const TestPartResult& test_part_result)	= 0;	//!< eXgsɌĂ΂܂
	virtual void OnTestRecordProperty(const TestProperty& /*test_property*/) {}	//!< RecordProperty ɌĂ΂܂
	virtual void OnTestEnd(const TestInfo& test_info)				= 0;	//!< eXgP[XIɂɌĂ΂܂
	virtual void OnTestCaseEnd(const TestCase& test_case)			= 0;	//!< eXgIɂɌĂ΂܂
	virtual void OnEnvironmentsTearDownStart(const UnitTest& test)	= 0;	//!< O[oݒ TearDown OɌĂ΂܂
	virtual void OnEnvironmentsTearDownEnd(const UnitTest& test)	= 0;	//!< O[oݒ TearDown OɌĂ΂܂
	virtual void OnTestIterationEnd(const UnitTest& test
									, int iteration)				= 0;	//!< P̃eXgIɖĂ΂܂
	virtual void OnTestProgramEnd(const UnitTest& test)				= 0;	//!< eXgvOIɌĂ΂܂
};

/**
 * @brief	̃CxgXi[
*/
class EmptyTestEventListener : public TestEventListener
{
public:
	virtual void OnTestProgramStart(const UnitTest& /*test*/)			{}
	virtual void OnTestIterationStart(const UnitTest& /*test*/
									, int /*iteration*/)				{}
	virtual void OnEnvironmentsSetUpStart(const UnitTest& /*test*/)		{}
	virtual void OnEnvironmentsSetUpEnd(const UnitTest& /*test*/)		{}
	virtual void OnTestCaseStart(const TestCase& /*test_case*/)			{}
	virtual void OnTestStart(const TestInfo& /*test_info*/)				{}
	virtual void OnTestPartResult(const TestPartResult& /*test_part_result*/)	{}
	virtual void OnTestRecordProperty(const TestProperty& /*test_propterty*/)	{}
	virtual void OnTestEnd(const TestInfo& /*test_info*/)				{}
	virtual void OnTestCaseEnd(const TestCase& /*test_case*/)			{}
	virtual void OnEnvironmentsTearDownStart(const UnitTest& /*test*/)	{}
	virtual void OnEnvironmentsTearDownEnd(const UnitTest& /*test*/)	{}
	virtual void OnTestIterationEnd(const UnitTest& /*test*/
									, int /*iteration*/)				{}
	virtual void OnTestProgramEnd(const UnitTest& /*test*/)				{}
};

/**
 * @brief	CxgsCxgXi[
*/
class TestEventRepeater : public TestEventListener
{
	typedef ::std::vector<TestEventListener*>	ListenerContainer;
public:
	/**
	 * @brief	Xi[̒ǉ
	*/
	void	Append(TestEventListener* listener)
	{
		m_listeners.push_back(listener);
	};

	/**
	 * @brief	Xi[̉
	*/
	TestEventListener*	Release(TestEventListener* listener);

public:
	// On*End ͌납s
	virtual void OnTestProgramStart(const UnitTest& test);
	virtual void OnTestIterationStart(const UnitTest& test
									, int iteration);
	virtual void OnEnvironmentsSetUpStart(const UnitTest& test);
	virtual void OnEnvironmentsSetUpEnd(const UnitTest& test);
	virtual void OnTestCaseStart(const TestCase& test_case);
	virtual void OnTestStart(const TestInfo& test_info);
	virtual void OnTestPartResult(const TestPartResult& test_part_result);
	virtual void OnTestRecordProperty(const TestProperty& test_property);
	virtual void OnTestEnd(const TestInfo& test_info);
	virtual void OnTestCaseEnd(const TestCase& test_case);
	virtual void OnEnvironmentsTearDownStart(const UnitTest& test);
	virtual void OnEnvironmentsTearDownEnd(const UnitTest& test);
	virtual void OnTestIterationEnd(const UnitTest& test
									, int iteration);
	virtual void OnTestProgramEnd(const UnitTest& test);

private:
	ListenerContainer	m_listeners;
};

/**
 * @brief	CxgXi[̊ǗNX
*/
class TestEventListeners
{
	typedef ::std::vector<TestEventListener*>	ListenerContainer;

public:
	TestEventListeners(void) : m_default_result_printer(NULL), m_default_xml_generator(NULL) {}

public:
	/**
	 * @brief	Xi[̒ǉ
	*/
	void	Append(TestEventListener* listener)	{ m_repeater.Append(listener); };

	/**
	 * @brief	Xi[̉
	*/
	TestEventListener*	Release(TestEventListener* listener) { return m_repeater.Release(listener); }

public:
	/**
	 * @brief	ftHgo̓Xi[̎擾
	*/
	TestEventListener*	default_result_printer(void)	const	{ return m_default_result_printer; }
	/**
	 * @brief	ftHgxmlo̓Xi[擾
	*/
	TestEventListener*	default_xml_generator(void)		const	{ return m_default_xml_generator; }

private:
	TestEventListener*	repeater(void) { return &m_repeater; }

	void OnTestProgramStart(const UnitTest& test)					{ m_repeater.OnTestProgramStart(test); }
	void OnTestIterationStart(const UnitTest& test, int iteration)	{ m_repeater.OnTestIterationStart(test, iteration); }
	void OnEnvironmentsSetUpStart(const UnitTest& test)				{ m_repeater.OnEnvironmentsSetUpStart(test); }
	void OnEnvironmentsSetUpEnd(const UnitTest& test)				{ m_repeater.OnEnvironmentsSetUpEnd(test); }

	void OnTestCaseStart(const TestCase& test_case)					{ m_repeater.OnTestCaseStart(test_case); }
	void OnTestStart(const TestInfo& test_info)						{ m_repeater.OnTestStart(test_info); }
	void OnTestPartResult(const TestPartResult& test_part_result)	{ m_repeater.OnTestPartResult(test_part_result); }
	void OnTestRecordProperty(const TestProperty& test_property)	{ m_repeater.OnTestRecordProperty(test_property); }
	void OnTestEnd(const TestInfo& test_info)						{ m_repeater.OnTestEnd(test_info); }
	void OnTestCaseEnd(const TestCase& test_case)					{ m_repeater.OnTestCaseEnd(test_case); }

	void OnEnvironmentsTearDownStart(const UnitTest& test)			{ m_repeater.OnEnvironmentsTearDownStart(test); }
	void OnEnvironmentsTearDownEnd(const UnitTest& test)			{ m_repeater.OnEnvironmentsTearDownEnd(test); }
	void OnTestIterationEnd(const UnitTest& test, int iteration)	{ m_repeater.OnTestIterationEnd(test, iteration); }
	void OnTestProgramEnd(const UnitTest& test)						{ m_repeater.OnTestProgramEnd(test); }

private:
	void	set_default_result_printer(TestEventListener* listener);
	void	set_default_xml_generator(TestEventListener* listener);

private:
	friend class UnitTestSource;
	friend class UnitTest;
	friend class TestInfo;
	friend class TestCase;
	friend class Test;

	friend class detail::DefaultGlobalTestPartResultReporter;
	friend class DefaultXmlGeneratorListener;
	friend class DefalutResultPrintListener;

	TestEventRepeater	m_repeater;
	TestEventListener*	m_default_result_printer;
	TestEventListener*	m_default_xml_generator;
};


inline TestEventListener*	TestEventRepeater::Release(TestEventListener* listener)
{
	ListenerContainer::iterator it = ::std::find(m_listeners.begin(), m_listeners.end(), listener);
	if( it == m_listeners.end() ) return NULL;
	m_listeners.erase(it);
	return listener;
}

inline void TestEventRepeater::OnTestProgramStart(const UnitTest& test)
{
	for( ListenerContainer::iterator it=m_listeners.begin(), end=m_listeners.end(); it != end; ++it )
	{
		(*it)->OnTestProgramStart(test);
	}
}
inline void TestEventRepeater::OnTestIterationStart(const UnitTest& test, int iteration)
{
	for( ListenerContainer::iterator it=m_listeners.begin(), end=m_listeners.end(); it != end; ++it )
	{
		(*it)->OnTestIterationStart(test, iteration);
	}
}
inline void TestEventRepeater::OnEnvironmentsSetUpStart(const UnitTest& test)
{
	for( ListenerContainer::iterator it=m_listeners.begin(), end=m_listeners.end(); it != end; ++it )
	{
		(*it)->OnEnvironmentsSetUpStart(test);
	}
}
inline void TestEventRepeater::OnEnvironmentsSetUpEnd(const UnitTest& test)
{
	for( ListenerContainer::reverse_iterator it=m_listeners.rbegin(), end=m_listeners.rend(); it != end; ++it )
	{
		(*it)->OnEnvironmentsSetUpEnd(test);
	}
}

inline void TestEventRepeater::OnTestCaseStart(const TestCase& test_case)
{
	for( ListenerContainer::iterator it=m_listeners.begin(), end=m_listeners.end(); it != end; ++it )
	{
		(*it)->OnTestCaseStart(test_case);
	}
}
inline void TestEventRepeater::OnTestStart(const TestInfo& test_info)
{
	for( ListenerContainer::iterator it=m_listeners.begin(), end=m_listeners.end(); it != end; ++it )
	{
		(*it)->OnTestStart(test_info);
	}
}
inline void TestEventRepeater::OnTestPartResult(const TestPartResult& test_part_result)
{
	for( ListenerContainer::iterator it=m_listeners.begin(), end=m_listeners.end(); it != end; ++it )
	{
		(*it)->OnTestPartResult(test_part_result);
	}
}
inline void TestEventRepeater::OnTestRecordProperty(const TestProperty& test_property)
{
	for( ListenerContainer::iterator it=m_listeners.begin(), end=m_listeners.end(); it != end; ++it )
	{
		(*it)->OnTestRecordProperty(test_property);
	}
}
inline void TestEventRepeater::OnTestEnd(const TestInfo& test_info)
{
	for( ListenerContainer::reverse_iterator it=m_listeners.rbegin(), end=m_listeners.rend(); it != end; ++it )
	{
		(*it)->OnTestEnd(test_info);
	}
}
inline void TestEventRepeater::OnTestCaseEnd(const TestCase& test_case)
{
	for( ListenerContainer::reverse_iterator it=m_listeners.rbegin(), end=m_listeners.rend(); it != end; ++it )
	{
		(*it)->OnTestCaseEnd(test_case);
	}
}

inline void TestEventRepeater::OnEnvironmentsTearDownStart(const UnitTest& test)
{
	for( ListenerContainer::iterator it=m_listeners.begin(), end=m_listeners.end(); it != end; ++it )
	{
		(*it)->OnEnvironmentsTearDownStart(test);
	}
}
inline void TestEventRepeater::OnEnvironmentsTearDownEnd(const UnitTest& test)
{
	for( ListenerContainer::reverse_iterator it=m_listeners.rbegin(), end=m_listeners.rend(); it != end; ++it )
	{
		(*it)->OnEnvironmentsTearDownEnd(test);
	}
}
inline void TestEventRepeater::OnTestIterationEnd(const UnitTest& test, int iteration)
{
	for( ListenerContainer::reverse_iterator it=m_listeners.rbegin(), end=m_listeners.rend(); it != end; ++it )
	{
		(*it)->OnTestIterationEnd(test, iteration);
	}
}
inline void TestEventRepeater::OnTestProgramEnd(const UnitTest& test)
{
	for( ListenerContainer::reverse_iterator it=m_listeners.rbegin(), end=m_listeners.rend(); it != end; ++it )
	{
		(*it)->OnTestProgramEnd(test);
	}
}

inline void	TestEventListeners::set_default_result_printer(TestEventListener* listener)
{
	Release(m_default_result_printer);
	if( listener != NULL )
	{
		Append(listener);
	}
	m_default_result_printer = listener;
}
inline void	TestEventListeners::set_default_xml_generator(TestEventListener* listener)
{
	Release(m_default_xml_generator);
	if( listener != NULL )
	{
		Append(listener);
	}
	m_default_xml_generator = listener;
}

}	// end of namespace iutest

#endif
