//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_env.hpp
 * @brief		iris unit test  t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_env_HPP_F4017EAB_6CA3_4e6e_8983_059393DADD04_
#define INCG_IRIS_iutest_env_HPP_F4017EAB_6CA3_4e6e_8983_059393DADD04_

//======================================================================
// include
#include "internal/iutest_charcode.hpp"
#include "internal/iutest_random.hpp"
#include "internal/iutest_regex.hpp"
#include "iutest_listener.hpp"

//======================================================================
// define
/**
 * @ingroup	IUTEST_UTIL
 * @brief	tOZbg
 * @details	w\ȃtO\n
 *			shuffle (bool)\n
 *			also_run_disabled_tests (bool)\n
 *			break_on_failure (bool)\n
 *			throw_on_failure (bool)\n
 *			catch_exceptions (bool)\n
 *			catch_exceptions_each   (bool)\n
 *			catch_exceptions_global (bool)\n
 *			random_seed (unsigned int)\n
 *			print_time (bool)\n
 *          color (string)\n
 *          filter (string)\n
 *          repeat (int)\n
 *			list_tests (bool)\n
 *			file_location_style_msvc (bool)\n
*/
#define IUTEST_FLAG(name)	IIUT_FLAG(name)

/**
 * @private
 * @{
*/
#define IIUT_FLAG(name)		TestEnv::name()

/**
 * @}
*/

namespace iutest
{

//======================================================================
// function
/**
 * @brief	ϐ̎擾
*/
inline ::std::string EnvironmentString(const char* name) { ::std::string var; detail::GetEnvironmentVariable(name, var); return var; }

//======================================================================
// class
/**
 * @brief	ZbgNX
*/
class Environment
{
public:
	virtual ~Environment(void)	{}
	virtual void SetUp(void)	{}	//!< O
	virtual void TearDown(void)	{}	//!< ㏈
};

/**
 * @brief	eXgtO
*/
class TestFlag
{
public:
	/**
	 * @brief	eXgtOۑ/NX
	*/
	class ScopedGuard
	{
		IUTEST_PP_DISALLOW_COPY_AND_ASSIGN(ScopedGuard);

		int m_test_flags;
	public:
		ScopedGuard(void) 
		{
			m_test_flags = TestFlag::GetInstance().m_test_flags;
		}
		~ScopedGuard(void) 
		{
			TestFlag::GetInstance().m_test_flags = m_test_flags;
		}
	};
public:
	/** 
	 * @brief	tO
	*/
	enum Kind
	{
		SHUFFLE_TESTS			= 0x00000001,	//!< VbteXg
		RUN_DISABLED_TESTS		= 0x00000002,	//!< DISABLED eXgs
		FILTERING_TESTS			= 0x00000004,	//!< eXg̃tB^O
		BREAK_ON_FAILURE		= 0x00000010,	//!< eXgsɃu[N
		THROW_ON_FAILURE		= 0x00000040,	//!< vIȎs throw 
		CONSOLE_COLOR_ON		= 0x00000100,	//!< FoON
		CONSOLE_COLOR_OFF		= 0x00000200,	//!< FoOFF
		CONSOLE_COLOR_ANSI		= 0x00000400,	//!< GXP[vV[PXŏo
		PRINT_TIME				= 0x00001000,	//!< oߎԂ̏o
		FILELOCATION_STYLE_MSVC	= 0x00002000,	//!< t@C/so̓X^C Visual Studio X^Cɂ
		CATCH_EXCEPTION_EACH	= 0x00010000,	//!< O catch (TestInfo)
		CATCH_EXCEPTION_GLOBAL	= 0x00020000,	//!< O catch (UnitTest)
		CATCH_EXCEPTION			= 0x00030000,	//!< O catch 
		OUTPUT_XML_REPORT		= 0x01000000,	//!< xml o
		SHOW_HELP				= 0x10000000,	//!< wv\
		SHOW_VERSION			= 0x20000000,	//!< o[W\
		SHOW_TESTS_LIST			= 0x40000000,	//!< eXg̃Xg\
		SHOW_FEATURE			= 0x80000000,	//!< @\̏o
		MASK					= 0xFFFFFFFF,	//!< }XN

		//! ftHg
#if defined(_MSC_VER)
		DEFAULT = CATCH_EXCEPTION|PRINT_TIME|FILELOCATION_STYLE_MSVC
#else
		DEFAULT = CATCH_EXCEPTION|PRINT_TIME
#endif
	};

private:
	TestFlag(void)
		: m_test_flags(DEFAULT) {}

public:
	/** @private */
	static TestFlag&	GetInstance(void)	{ static TestFlag flag; return flag; }
public:
	/**
	 * @brief	tÕrbg
	 * @details	flag = (flag | enable) & mask;
	 * @param [in]	enable	= _a
	 * @param [in]	mask	= }XNl
	*/
	static void		SetFlag(int enable, int mask=-1)	{ GetInstance().m_test_flags |= enable; GetInstance().m_test_flags &= mask; }
	/**
	 * @brief	tOĂ邩ǂ
	 * @param [in]	flag	= ΏۃtO
	 * @return	^Ul
	*/
	static bool		IsEnableFlag(int flag)				{ return GetInstance().m_test_flags & flag ? true : false; }

private:
	template<int KIND>
	class Fragment
	{
		typedef Fragment<KIND>	_Myt;
	public:
		Fragment(void) {}
		Fragment(bool f)	{ SetFlag(KIND, f ? -1 : ~KIND); }
		_Myt&	operator = (bool f)	{ SetFlag(KIND, f ? -1 : ~KIND); return *this; }
		IUTEST_CXX_EXPLICIT_CONVERSION operator bool (void) const { return IsEnableFlag(KIND); }
	};

private:
	friend	class TestEnv;

	int m_test_flags;
};

// declare
class TestPartResultReporterInterface;

/**
 * @brief	eXg
*/
class TestEnv
{
	typedef ::std::vector<Environment*>	iuEnvironmentList;
private:
	class OptionString
	{
	protected:
		::std::string	m_option;
	public:
		bool operator == (const char* c_str_)		{ return m_option == c_str_; }
		bool operator == (const ::std::string& str)	{ return m_option == str; }
		bool operator != (const char* c_str_)		{ return m_option != c_str_; }
		bool operator != (const ::std::string& str)	{ return m_option != str; }

		operator ::std::string (void) const	{ return m_option; }
	public:
		bool empty(void) const			{ return m_option.empty(); }
		const char* c_str(void) const	{ return m_option.c_str(); }
		size_t	length(void) const		{ return m_option.length(); }
	};

public:

	/**
	 * @private
	 * @{
	*/
	typedef TestFlag::Fragment<TestFlag::SHUFFLE_TESTS>			shuffle;
	typedef TestFlag::Fragment<TestFlag::RUN_DISABLED_TESTS>	also_run_disabled_tests;
	typedef TestFlag::Fragment<TestFlag::BREAK_ON_FAILURE>		break_on_failure;
	typedef TestFlag::Fragment<TestFlag::CATCH_EXCEPTION>		catch_exceptions;
	typedef TestFlag::Fragment<TestFlag::THROW_ON_FAILURE>		throw_on_failure;
	typedef TestFlag::Fragment<TestFlag::PRINT_TIME>			print_time;
	typedef TestFlag::Fragment<TestFlag::SHOW_TESTS_LIST>		list_tests;

	typedef TestFlag::Fragment<TestFlag::CATCH_EXCEPTION_EACH>		catch_exceptions_each;
	typedef TestFlag::Fragment<TestFlag::CATCH_EXCEPTION_GLOBAL>	catch_exceptions_global;

	typedef TestFlag::Fragment<TestFlag::FILELOCATION_STYLE_MSVC>	file_location_style_msvc;

	/**
	 * @}
	*/

	/**
	 * @private
	 * @brief	V[hݒpIuWFNg
	*/
	typedef class RandomSeedSet
	{
	public:
		RandomSeedSet(void) {}
		RandomSeedSet(unsigned int seed) { init_random(seed); } 
		RandomSeedSet&	operator = (unsigned int seed)	{ init_random(seed); return *this; }
		operator unsigned int (void) const { return get_random_seed(); }
	} random_seed;

	/**
	 * @private
	 * @brief	s[g񐔐ݒpIuWFNg
	*/
	typedef class RepeatCountSet
	{
	public:
		RepeatCountSet(void) {}
		RepeatCountSet(int count) { set_repeat_count(count); } 
		RepeatCountSet&	operator = (int count)	{ set_repeat_count(count); return *this; }
		operator int (void) const { return get_repeat_count(); }
	} repeat;

	/**
	 * @private
	 * @brief	Fto̓IvVݒpIuWFNg
	*/
	typedef class ColorOptionSet : public OptionString
	{
	public:
		ColorOptionSet(void)
		{
			if( TestFlag::IsEnableFlag(TestFlag::CONSOLE_COLOR_OFF) ) m_option = "no";
			else if( TestFlag::IsEnableFlag(TestFlag::CONSOLE_COLOR_ON) ) m_option = "yes";
			else if( TestFlag::IsEnableFlag(TestFlag::CONSOLE_COLOR_ANSI) ) m_option = "ansi";
			else m_option = "auto";
		}
		const ColorOptionSet& operator = (const char* c_str_)
		{
			m_option = c_str_;
			ParseOutputOption(c_str_);
			return *this;
		}
		const ColorOptionSet& operator = (const ::std::string& str)
		{
			m_option = str;
			ParseOutputOption(str.c_str());
			return *this;
		}
	} color;

	/**
	 * @private
	 * @brief	tB^[IvVݒpIuWFNg
	*/
	typedef class FilterOption : public OptionString
	{
	public:
		FilterOption(void)
		{
			m_option = get_vars().m_test_filter;
		}
		const FilterOption& operator = (const char* c_str_)
		{
			m_option = c_str_;
			set_test_filter(c_str_);
			return *this;
		}
		const FilterOption& operator = (const ::std::string& str)
		{
			m_option = str;
			set_test_filter(str.c_str());
			return *this;
		}
	} filter;

private:
	struct Variable
	{
		Variable(void)
			: m_random_seed(0)
			, m_current_random_seed(0)
			, m_repeat_count(1)
			, m_testpartresult_reporter(NULL)
		{}
		unsigned int		m_random_seed;
		unsigned int		m_current_random_seed;
		int					m_repeat_count;
		::std::string		m_report_file;
		::std::string		m_test_filter;
		detail::iuRandom	m_genrand;
		iuEnvironmentList	m_environment_list;
		TestEventListeners	m_event_listeners;
		TestPartResultReporterInterface*	m_testpartresult_reporter;
	};

	static Variable& get_vars(void) { static Variable v; return v; }

public:

	static detail::iuRandom&	genrand(void)				{ return get_vars().m_genrand; }				//!< 
	static unsigned int			get_random_seed(void)		{ return get_vars().m_random_seed; }			//!< V[h
	static unsigned int			current_random_seed(void)	{ return get_vars().m_current_random_seed; }	//!< V[h
	static int					get_repeat_count(void)		{ return get_vars().m_repeat_count; }			//!< JԂ
	static const char*			get_report_filepath(void)	{ return get_vars().m_report_file.c_str(); }	//!< oxmlpX
	static const char*			test_filter(void)			{ return get_vars().m_test_filter.c_str(); }	//!< tB^[

	/** @private */
	static TestEventListeners&	event_listeners(void)	{ return get_vars().m_event_listeners; }
	/** @private */
	static TestPartResultReporterInterface* GetGlobalTestPartResultReporter(void)		{ return get_vars().m_testpartresult_reporter; }
	/** @private */
	static void SetGlobalTestPartResultReporter(TestPartResultReporterInterface* ptr)	{ get_vars().m_testpartresult_reporter = ptr; }

private:
	static iuEnvironmentList&	environments(void)		{ return get_vars().m_environment_list; }

public:
	/**
	 * @brief	O[oZbgNX̒ǉ
	 * @param [in]	env	= ZbgNXAhX
	 * @return	o^ꂽNXAhX
	*/
	static Environment* AddGlobalTestEnvironment(Environment* env)
	{
		if( env == NULL ) return NULL;
		environments().push_back(env);
		return env;
	}

private:
	/**
	 * @brief	ZbgNX̉
	*/
	static void ReleaseGlobalTestEnvironment(void)
	{
		// ׂĉ
		for( iuEnvironmentList::iterator it=environments().begin(); it != environments().end(); )
		{
			Environment* p = *it;
			it = environments().erase(it);
			delete p;
		}
	}

public:
	/**
	 * @private
	 * @brief	R}hC̉
	*/
	template<typename CharType>
	static void	ParseCommandLine(int* pargc, CharType** argv)
	{
		int argc = *pargc;

		for( int i=0; i < argc; )
		{
			if( ParseCommandLineElem(argv[i]) )
			{
				--argc;
				// ꍇAIvV𖖔Ɉړ
				for( int k=i; k < argc; ++k )
				{
					CharType* tmp = argv[k];
					argv[k] = argv[k+1];
					argv[k+1] = tmp;
				}
			}
			else
			{
				++i;
			}
		}
		*pargc = argc;
	}

	/**
	 * @private
	 * @brief	R}hC̉(vector)
	*/
	template<typename CharType>
	static void	ParseCommandLine(::std::vector< ::std::basic_string<CharType> >& argv)
	{
		for( typename ::std::vector< ::std::basic_string<CharType> >::iterator it = argv.begin(); it != argv.end(); )
		{
			if( ParseCommandLineElem(it->c_str()) )
			{
				it = argv.erase(it);
			}
			else
			{
				++it;
			}
		}
	}
private:
	template<typename CharType>
	static bool	ParseCommandLineElem(CharType* argv)
	{
		typedef typename detail::mbs_ptr<CharType>::type formatter;

		formatter argv_format;
		const char* str = argv_format.ptr(argv);
		return ParseCommandLineElemA(str);
	}
	static bool ParseCommandLineElemA(const char* str);

private:
	/**
	 * @brief	ϐݒ\z
	*/
	static void LoadEnviromentVariable(void);

	/**
	 * @brief	ZbgAbv
	*/
	static void	SetUp(void);

private:
	/**
	 * @brief	V[h̐ݒ
	*/
	static void	init_random(unsigned int seed)
	{
		get_vars().m_random_seed = seed;
	}

	/**
	 * @brief	JԂ񐔂̐ݒ
	*/
	static void	set_repeat_count(int count)
	{
		get_vars().m_repeat_count = count;
	}

	/**
	 * @brief	tB^[̐ݒ
	*/
	static void	set_test_filter(const char* str)
	{
		get_vars().m_test_filter = str;
		TestFlag::SetFlag(TestFlag::FILTERING_TESTS);
	}

private:
	/**
	 * @brief	IvV񂩂ݒ蕶̐擪AhX擾
	*/
	static inline const char* ParseOptionSettingStr(const char* opt)
	{
		const char* eq = strchr(opt, '=');
		if( eq == NULL ) return eq;
		return eq+1;
	}
	/**
	 * @brief	IUTEST_COLOR IvV̔
	*/
	static bool	ParseColorOption(const char* option);

	/**
	 * @brief	IUTEST_OUTPUT IvV̔
	*/
	static bool	ParseOutputOption(const char* option);

	/**
	 * @brief	IUTEST_FILE_LOCATION IvV̔
	*/
	static bool	ParseFileLocationOption(const char* option);

	/**
	 * @brief	yes IvV no IvV̔
	 * @param [in]	str		= R}hCi֐ȂŃIvV񕔕擾j
	 * @param [in]	flag	= tO
	 * @param [in]	def		= Ȃ̏ꍇ̃Iy[V
	 * @return	
	*/
	static bool ParseYesNoFlagCommandLine(const char* str, TestFlag::Kind flag, int def);

	/**
	 * @brief	yes IvV no IvV̔
	 * @param [in]	option	= IvV
	 * @retval	< 0	= YȂ
	 * @retval	0	= NO
	 * @retval	> 0 = YES
	*/
	static int ParseYesNoOption(const char* option);

	/**
	 * @brief	yes IvV
	*/
	static bool IsYes(const char* option);
	/**
	 * @brief	no IvV
	*/
	static bool IsNo(const char* option);

private:
	friend class UnitTest;
};

}	// end of namespace iutest

#if !IUTEST_HAS_LIB
#  include "impl/iutest_env.ipp"
#endif

#endif
