//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_message.hpp
 * @brief		iris unit test bZ[W t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_message_HPP_0A05C876_F204_41F5_895F_F8454AB283B1_
#define INCG_IRIS_iutest_message_HPP_0A05C876_F204_41F5_895F_F8454AB283B1_

//======================================================================
// include
#include "../iutest_env.hpp"
#include "iutest_constant.hpp"

namespace iutest {
namespace detail
{

//======================================================================
// declare
/**
 * @brief	t@CƍsԍA𐶐(RpCl)
*/
::std::string FormatFileLocation(const char* file, int line);
/**
 * @brief	t@CƍsԍA𐶐
*/
::std::string FormatCompilerIndependentFileLocation(const char* file, int line);

//======================================================================
// class
/**
 * @brief	bZ[WNX
*/
class iuMessage
{
	::std::string	m_message;	//!< bZ[W
public:
	iuMessage(void) {}
	explicit iuMessage(const char* message) : m_message(message) {}
	iuMessage(const iuMessage& rhs) : m_message(rhs.m_message) {}

	const char*		message(void)	const	{ return m_message.c_str(); }	//!< bZ[W̎擾

public:
	::std::string GetString(void)	const	{ return m_message; }
public:
	template<typename T>
	iuMessage&	operator << (const T& value) 
	{
		detail::iuStringStream::type strm;
		strm << value;
		m_message += strm.str();
		return *this;
	}
#if !defined(IUTEST_NO_ARGUMENT_DEPENDENT_LOOKUP)
	template<typename T>
	iuMessage&	operator << (T* const& value) 
	{
		if( value == NULL ) 
		{
			m_message += "(null)";
		}
		else
		{
			detail::iuStringStream::type strm;
			strm << value;
			m_message += strm.str();
		}
		return *this;
	}
#endif
	iuMessage&	operator << (bool b) 
	{
		m_message += b ? "true" : "false";
		return *this;
	}
	iuMessage&	operator << (char* str)
	{
		append(str);
		return *this;
	}
	iuMessage&	operator << (const char* str)
	{
		append(str);
		return *this;
	}
	iuMessage&	operator << (wchar_t* str)
	{
		m_message += ShowWideCString(str);
		return *this;
	}
	iuMessage&	operator << (const wchar_t* str)
	{
		m_message += ShowWideCString(str);
		return *this;
	}
	iuMessage&	operator << (const iuMessage& message)
	{
		m_message += message.m_message;
		return *this;
	}
public:
	/**
	 * @brief	bZ[W̒ǋL
	*/
	void	add_message(const char* str) { append(str); }
private:
	void	append(const char* str);
};

inline iu_ostream& operator << (iu_ostream& os, const iuMessage& msg)
{
	return os << msg.message();
}

/**
 * @brief	t@C/C/bZ[WNX
*/
class iuCodeMessage : public iuMessage
{
	const char*	m_file;		//!< t@C
	int			m_line;		//!< C
public:
	iuCodeMessage(const char* file, int line, const char* message)
		: iuMessage(message)
		, m_file(file ? file : kStrings::UnkownFile)
		, m_line(line)
	{}
	iuCodeMessage(const char* file, int line, const iuMessage& message)
		: iuMessage(message)
		, m_file(file ? file : kStrings::UnkownFile)
		, m_line(line)
	{}
	iuCodeMessage(const iuCodeMessage& rhs)
		: iuMessage(rhs)
		, m_file(rhs.m_file)
		, m_line(rhs.m_line)
	{}
public:
	template<typename T>
	iuCodeMessage&		operator << (T value)
	{
		iuMessage::operator << (value);
		return *this;
	}
public:
	const char*		file_name(void)		const	{ return m_file; }				//!< t@C̎擾
	int				line_number(void)	const	{ return m_line; }				//!< Cԍ̎擾
public:
	/** @private */
	::std::string	make_message(void) const;
	::std::string	make_newline_message(void) const
	{
		return make_message() + "\n";
	}
};

}	// end of namespace detail
}	// end of namespace iutest

#if !IUTEST_HAS_LIB
#  include "../impl/iutest_message.ipp"
#endif

#endif
