//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_result.hpp
 * @brief		iris unit test result t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_result_HPP_D27B1599_F42F_4e2d_B3EB_FACE24C2B921_
#define INCG_IRIS_iutest_result_HPP_D27B1599_F42F_4e2d_B3EB_FACE24C2B921_

//======================================================================
// include
#include "internal/iutest_message.hpp"
#include "internal/iutest_console.hpp"

namespace iutest
{

//======================================================================
// declare
namespace detail
{
	class DefaultGlobalTestPartResultReporter;
}

//======================================================================
// class
/**
 * @brief	eXgʂ̒ʒmC^[tFCX
*/
class TestPartResultReporterInterface
{
public:
	virtual ~TestPartResultReporterInterface(void) {}
	/**
	 * @brief	eXgʒʒm󂯎֐
	 * @param [in] result	= eXg
	*/
	virtual void ReportTestPartResult(const TestPartResult& result)	= 0;
};

/**
 * @brief	eXgʂNX
*/
class TestPartResult : public detail::iuCodeMessage
{
public:
	/**
	 * @brief	ʂ̃^Cv
	*/
	enum Type
	{
		kWarning = -1,		//!< x
		kSuccess,			//!< 
		kNotFatalFailure,	//!< vIł͂Ȃs
		kFatalFailure		//!< vIȎs
	};
public:
	/**
	 * @brief	RXgN^
	 * @param [in]	file	= t@C
	 * @param [in]	line	= sԍ
	 * @param [in]	message	= bZ[W
	 * @param [in]	type	= ʂ̃^Cv
	*/
	TestPartResult(const char* file, int line, const char* message, Type type)
		: detail::iuCodeMessage(file, line, message), m_type(type) {}
	//! Rs[RXgN^
	TestPartResult(const TestPartResult& rhs) : detail::iuCodeMessage(rhs)
		, m_type(rhs.m_type) {}

public:
	/**
	 * @brief	sǂ
	*/
	bool		failed(void)	const IUTEST_CXX_NOEXCEPT_SPEC { return m_type != kSuccess && m_type != kWarning; }
	/**
	 * @brief	ǂ
	*/
	bool		passed(void)	const IUTEST_CXX_NOEXCEPT_SPEC { return !failed(); }
	/**
	 * @brief	xǂ
	*/
	bool		warning(void)	const IUTEST_CXX_NOEXCEPT_SPEC { return m_type == kWarning; }

	/**
	 * @brief	vIł͂Ȃsǂ
	*/
	bool		nonfatally_failed(void)	const IUTEST_CXX_NOEXCEPT_SPEC { return m_type == kNotFatalFailure; }

	/**
	 * @brief	vIȎsǂ
	*/
	bool		fatally_failed(void)	const IUTEST_CXX_NOEXCEPT_SPEC { return m_type == kFatalFailure; }

	/**
	 * @brief	R
	*/
	const char*	summary(void) const { return message(); }

	/**
	 * @brief	ʂ̃^Cv擾
	*/
	Type		type(void) const IUTEST_CXX_NOEXCEPT_SPEC { return m_type; }

private:
	Type	m_type;
};

//! TestPartResult print o
inline ::std::ostream& operator << (::std::ostream& os, const TestPartResult& result)
{
	return os << result.make_message();
}

/**
 * @brief	eXgvpeB
 * @note	XML 
*/
class TestProperty
{
public:
	/**
	 * @brief	RXgN^
	 * @param [in]	key		= L[
	 * @param [in]	value	= l
	*/
	TestProperty(const ::std::string& key, const ::std::string& value)
		: m_key(key), m_value(value) {}

public:
	/**
	 * @brief	l̐ݒ
	*/
	void SetValue(const ::std::string& value) { m_value = value; }
	const char*	key(void)	const	{ return m_key.c_str(); }	//!< L[̎擾
	const char*	value(void)	const	{ return m_value.c_str(); }	//!< l̎擾

public:
	/**
	 * @brief	LȃL[ǂ`FbN
	 * @retval	true=L
	 * @retval	false=
	*/
	bool Validate(const char** ban_list, size_t size) const
	{
		for( int i=0, n=size; i < n; ++i )
		{
			if( m_key == ban_list[i] )
			{
				return false;
			}
		}
		return true;
	}

private:
	friend class TestResult;
	::std::string m_key;
	::std::string m_value;
};

/**
 * @brief	eXgʂNX
*/
class TestResult
{
	typedef ::std::vector<TestPartResult>	TestPartResults;
	typedef ::std::vector<TestProperty>		TestPropertys;
public:
	TestResult(void)
		: m_elapsedmsec(0) {}

public:
	/**
	 * @brief	ǂ
	 * @return	^Ul
	*/
	bool		Passed(void) const		{ return !Failed(); }
	/**
	 * @brief	sǂ
	 * @return	^Ul
	*/
	bool		Failed(void) const
	{
		for( TestPartResults::const_iterator it=m_test_part_results.begin(), end=m_test_part_results.end(); it != end; ++it )
		{
			if( it->failed() ) return true;
		}
		return false;
	}

	/**
	 * @brief	vIȃG[邩ǂ
	 * @return	^Ul
	*/
	bool		HasFatalFailure(void)	const	{ return HasResult(TestPartResult::kFatalFailure); }

	/**
	 * @brief	vIłȂG[邩ǂ
	 * @return	^Ul
	*/
	bool		HasNonfatalFailure(void)	const	{ return HasResult(TestPartResult::kNotFatalFailure); }

	/**
	 * @brief	eXg̎sԂ̎擾
	 * @return	eXg̎s
	*/
	TimeInMillisec	elapsed_time(void)		const IUTEST_CXX_NOEXCEPT_SPEC { return m_elapsedmsec; }

	/**
	 * @brief	ʂ̐擾
	 * @return	ʂ̐
	*/
	int			total_part_count(void)		const	{ return static_cast<int>(m_test_part_results.size()); }

	/**
	 * @brief	vpeB̎擾
	 * @return	
	*/
	int			test_property_count(void)	const	{ return static_cast<int>(m_test_propertys.size()); }

	/**
	 * @brief	eXgʂ̎擾
	 * @param [in]	index	= CfbNX
	 * @return	eXg
	*/
	const TestPartResult&	GetTestPartResult(int index) const	{ return m_test_part_results[index]; }

	/**
	 * @brief	vpeB̎擾
	 * @param [in]	index	= CfbNX
	 * @return	vpeB
	*/
	const TestProperty&		GetTestProperty(int index) const	{ return m_test_propertys[index]; }

public:
	/**
	 * @brief	s̐擾
	 * @return	s̐
	*/
	int total_error_count(void) const
	{
		int count = 0;
		for( TestPartResults::const_iterator it=m_test_part_results.begin(), end=m_test_part_results.end(); it != end; ++it )
		{
			if( it->failed() ) ++count;
		}
		return count;
	}

private:
	void AddTestPartResult(const TestPartResult& result)	{ m_test_part_results.push_back(result); }
	void set_elapsed_time(TimeInMillisec time) IUTEST_CXX_NOEXCEPT_SPEC { m_elapsedmsec = time; }

private:
	void RecordProperty(const TestProperty& prop)
	{
		for( TestPropertys::iterator it=m_test_propertys.begin(), end=m_test_propertys.end(); it != end; ++it )
		{
			if( detail::IsStringEqual(it->key(), prop.key()) )
			{
				it->m_value = prop.m_value;
				return;
			}
		}
		m_test_propertys.push_back(prop);
	}

	void ClearResult(void)
	{
		m_test_part_results.clear();
	}
	void Clear(void)
	{
		m_test_part_results.clear();
		m_test_propertys.clear();
		m_elapsedmsec = 0;
	}
	bool HasResult(TestPartResult::Type eType) const
	{
		for( TestPartResults::const_iterator it=m_test_part_results.begin(), end=m_test_part_results.end(); it != end; ++it )
		{
			if( it->type() == eType ) return true;
		}
		return false;
	}
private:
	friend class UnitTestImpl;
	friend class TestInfo;
	friend class TestCase;
	friend class detail::DefaultGlobalTestPartResultReporter;

	TestPartResults	m_test_part_results;
	TestPropertys	m_test_propertys;
	TimeInMillisec	m_elapsedmsec;

	IUTEST_PP_DISALLOW_COPY_AND_ASSIGN(TestResult);
};

}	// end of namespace iutest

#endif
