/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_environment_tests.c
 * @brief		Environment ΉeXg
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/

/* include ===========================================================*/
#include "../include/iutest_c.h"
#include <assert.h>

IUTEST_C_WORKSPACE();

static int call_setup = 0;
static int call_teardown = 0;

void GlobalSetUp(void)
{
	++call_setup;
}
	
void GlobalSetUp2(void)
{
	++call_setup;
}

void GlobalTearDown(void)
{
	++call_teardown;
}

void GlobalTearDown2(void)
{
	++call_teardown;
}

IUTEST(Foo, Bar)
{
	IUTEST_EXPECT_EQ(2, call_setup);
	IUTEST_EXPECT_EQ(0, call_teardown);
}

#ifdef UNICODE
int wmain(int argc, wchar_t* argv[])
#else
int main(int argc, char* argv[])
#endif
{
	int ret = 0;
	
	iuUnitTest_AddGlobalEnvironmentSetUp(GlobalSetUp);
	iuUnitTest_AddGlobalEnvironmentSetUp(GlobalSetUp2);
	iuUnitTest_AddGlobalEnvironmentTearDown(GlobalTearDown);
	iuUnitTest_AddGlobalEnvironmentTearDown(GlobalTearDown2);
	
	IUTEST_INIT(&argc, argv);
	assert( call_setup == 0 );
	assert( call_teardown == 0 );
	
	ret = IUTEST_RUN_ALL_TESTS();	// run all

	assert( call_teardown == 2 );

	if( ret == 0 )
	{
		printf("*** Successful ***\n");
	}
	return ret;
}
