/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_internal_c.h
 * @brief		iris unit test info t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012-2013 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_IRIS_iutest_internal_c_H_A3DF31D4_5FC6_4c62_BCF6_EF835E47B10A_
#define INCG_IRIS_iutest_internal_c_H_A3DF31D4_5FC6_4c62_BCF6_EF835E47B10A_

/* include ===========================================================*/
#include "../iutest_pred_c.h"

/* define ============================================================*/
/**
 * @private
 * @{
*/
#define IIUT_C_TEST_BODY_DECL_NAME(testcase_, testname_)	iutest_c_test_body_##testcase_##_##testname_##_
#define IIUT_C_TEST_INFO_DECL_NAME(testcase_, testname_)	s_iutest_c_test_info_##testcase_##_##testname_##_
#define IIUT_C_TEST_INITIALIZATION_SECTION_NAME(testcase_, testname_)	iutest_c_test_register_dummy_##testcase_##_##testname_

/* eXg̒` */
#define IIUT_C_TEST_(testcase_, testname_)							\
	IIUT_C_TEST_ADD_(testcase_, testname_, NULL, NULL, NULL, NULL, NULL)

/* eXgtBNX`̒` */
#define IIUT_C_TEST_F_(testfix_, testname_)							\
	IIUT_C_TEST_ADD_(testfix_, testname_, testfix_.setup_testcase	\
	, testfix_.teardown_testcase, testfix_.setup, testfix_.teardown, testfix_.user)

#if IUTEST_C_HAS_MALLOC

#define IIUT_C_TEST_ADD_(testcase_, testname_, setup_testcase_, teardown_testcase_, setup_, teardown_, user_)	\
	IIUT_C_TEST_ADD_I_(testcase_, testname_, setup_testcase_, teardown_testcase_		\
	, setup_, teardown_, user_, iuUnitTest_AllocTestCase)

#else

#define IIUT_C_TEST_ADD_(testcase_, testname_, setup_testcase_, teardown_testcase_, setup_, teardown_, user_)	\
	static iuTestCase * IUTEST_PP_CAT(iutest_c_alloc_##testcase_##_dummy_, __LINE__)(void) {	\
	static iuTestCase instance; return &instance; }												\
	IIUT_C_TEST_ADD_I_(testcase_, testname_, setup_testcase_, teardown_testcase_				\
	, setup_, teardown_, user_, IUTEST_PP_CAT(iutest_c_alloc_##testcase_##_dummy_, __LINE__))

#endif

#define IIUT_C_TEST_ADD_I_(testcase_, testname_, setup_testcase_, teardown_testcase_, setup_, teardown_, user_, allocator_)	\
	void IIUT_C_TEST_BODY_DECL_NAME(testcase_, testname_)(void);														\
	static iuTestInfo IIUT_C_TEST_INFO_DECL_NAME(testcase_, testname_) = 												\
	iuTestInfo_ctor(#testname_, IIUT_C_TEST_BODY_DECL_NAME(testcase_, testname_) );										\
	IUTEST_C_DECL_INITIALIZATION_SECTION_BEGIN( IIUT_C_TEST_INITIALIZATION_SECTION_NAME(testcase_, testname_) )			\
	iuTestCase_AddTestInfo(iuUnitTest_AddTestCase(#testcase_, setup_testcase_, teardown_testcase_, allocator_),			\
	& IIUT_C_TEST_INFO_DECL_NAME(testcase_, testname_) );																\
	IIUT_C_TEST_INFO_DECL_NAME(testcase_, testname_).test.setup = setup_;												\
	IIUT_C_TEST_INFO_DECL_NAME(testcase_, testname_).test.teardown = teardown_;											\
	IIUT_C_TEST_INFO_DECL_NAME(testcase_, testname_).test.user = user_;											\
	IUTEST_C_DECL_INITIALIZATION_SECTION_END()																			\
	void IIUT_C_TEST_BODY_DECL_NAME(testcase_, testname_)(void)

#if IUTEST_C_HAS_PARAM_METHOD_TEST

/* p^CYeXg̒` */
#define IIUT_C_TEST_PMZ_(testcase_, testname_, method_, ...)		\
	IIUT_C_TEST_PMZ_ADD_(testcase_, testname_, NULL, NULL, NULL, NULL, NULL, method_, __VA_ARGS__)

/* p^CYeXg eXgtBNX`̒` */
#define IIUT_C_TEST_PMZ_F_(testfix_, testname_, method_, ...)			\
	IIUT_C_TEST_PMZ_ADD_(testfix_, testname_, testfix_.setup_testcase	\
	, testfix_.teardown_testcase, testfix_.setup, testfix_.teardown, testfix_.user, method_, __VA_ARGS__)

#if IUTEST_C_HAS_MALLOC

#define IIUT_C_TEST_PMZ_ADD_(testcase_, testname_, setup_testcase_, teardown_testcase_, setup_, teardown_, user_, method_, ...)	\
	IIUT_C_TEST_PMZ_ADD_I_(testcase_, testname_, setup_testcase_, teardown_testcase_		\
	, setup_, teardown_, user_, iuUnitTest_AllocTestCase, method_, __VA_ARGS__)

#else

#define IIUT_C_TEST_PMZ_ADD_(testcase_, testname_, setup_testcase_, teardown_testcase_, setup_, teardown_, user_, method_, ...)	\
	static iuTestCase * IUTEST_PP_CAT(iutest_c_alloc_testcase_dummy_, __LINE__)(void) {		\
	static iuTestCase instance; return &instance; }											\
	IIUT_C_TEST_PMZ_ADD_I_(testcase_, testname_, setup_testcase_, teardown_testcase_		\
	, setup_, teardown_, user_, IUTEST_PP_CAT(iutest_c_alloc_testcase_dummy_, __LINE__), method_, __VA_ARGS__)

#endif

#define IIUTE_C_TEST_PMZ_BODY_DECL_NAME(testcase_, testname_)	IUTEST_PP_CAT(iutest_c_test_body_##testcase_##_##testname_##_, __LINE__)
#define IIUTE_C_TEST_PMZ_INFO_DECL_NAME(testcase_, testname_)	IUTEST_PP_CAT(s_iutest_c_test_info_##testcase_##_##testname_##_, __LINE__)

#define IIUT_C_TEST_PMZ_ADD_I_(testcase_, testname_, setup_testcase_, teardown_testcase_, setup_, teardown_, user_, allocator_, method_, ...)	\
	void IIUTE_C_TEST_PMZ_BODY_DECL_NAME(testcase_, testname_)(void) { method_(__VA_ARGS__); }											\
	static iuTestInfo IIUTE_C_TEST_PMZ_INFO_DECL_NAME(testcase_, testname_) = 															\
	iuTestInfo_ctor(#testname_, IIUTE_C_TEST_PMZ_BODY_DECL_NAME(testcase_, testname_) );												\
	IUTEST_C_DECL_INITIALIZATION_SECTION_BEGIN( IUTEST_PP_CAT(iutest_c_test_register_dummy_##testcase_##_##testname_, __LINE__) )		\
	iuTestCase_AddTestInfo(iuUnitTest_AddTestCase(#testcase_, setup_testcase_, teardown_testcase_, allocator_),							\
	& IIUTE_C_TEST_PMZ_INFO_DECL_NAME(testcase_, testname_) );																			\
	IIUTE_C_TEST_PMZ_INFO_DECL_NAME(testcase_, testname_).test.setup = setup_;															\
	IIUTE_C_TEST_PMZ_INFO_DECL_NAME(testcase_, testname_).test.teardown = teardown_;													\
	IIUTE_C_TEST_PMZ_INFO_DECL_NAME(testcase_, testname_).test.user = user_;													\
	IUTEST_C_DECL_INITIALIZATION_SECTION_END()																							\

#endif

/**
 * @}
*/

/**
 * @internal
 * @brief	ASSERTION bZ[W
*/
#define IUTEST_MESSAGE_AT(file_, line_, msg_, result_type_)	iuAssertionHelper_Report(file_, line_, msg_, result_type_)

/**
 * @internal
 * @brief	ASSERT bZ[W
*/
#define IUTEST_ASSERT_FAILURE(msg)					IUTEST_ASSERT_FAILURE_AT(msg, __FILE__, __LINE__)

#define IUTEST_ASSERT_FAILURE_AT(msg, file, line)	if( IUTEST_MESSAGE_AT(file, line, msg, kTestResultFatalFailure), iuAlwaysTrue()) return

/**
 * @internal
 * @brief	EXPECT bZ[W
*/
#define IUTEST_EXPECT_FAILURE(msg)					IUTEST_EXPECT_FAILURE_AT(msg, __FILE__, __LINE__)

#define IUTEST_EXPECT_FAILURE_AT(msg, file, line)	IUTEST_MESSAGE_AT(file, line, msg, kTestResultNotFatalFailure)

/**
 * @internal
 * @brief	INFORM bZ[W
*/
#define IUTEST_INFORM_FAILURE(msg)					IUTEST_INFORM_FAILURE_AT(msg, __FILE__, __LINE__)

#define IUTEST_INFORM_FAILURE_AT(msg, file, line)	IUTEST_MESSAGE_AT(file, line, msg, kTestResultWarning)


/**
 * @internal
 * @biref	r؃}N
*/
#define IUTEST_TEST_ASSERT_(expression, on_failure)	do {	\
	iuAssertionResult tr; tr = (expression);				\
	if( !tr.result )										\
		on_failure(tr.message);								\
	} while(iuAlwaysZero())

/**
 * @internal
 * @biref	BOOL r؃}N
*/
#define IUTEST_TEST_BOOLEAN_(expression, text, actual, expected, on_failure)	\
	IUTEST_AMBIGUOUS_ELSE_BLOCKER_												\
	if( expression )															\
		;																		\
	else																		\
		on_failure(iuTestAssertion_GetBooleanAssertionFailureMessage(			\
			text, #actual, #expected) )

/**
 * @internal
 * @brief	eXg}N
 * @{
*/
#define	IUTEST_TEST_EQ(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperEQ, v1, v2, on_failure )
#define	IUTEST_TEST_LVALUE_EQ(v1, v2, on_failure)		IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperLValueEQ, v1, v2, on_failure )
#define	IUTEST_TEST_RVALUE_EQ(v1, v2, on_failure)		IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperRValueEQ, v1, v2, on_failure )
#define	IUTEST_TEST_NE(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperNE, v1, v2, on_failure )
#define	IUTEST_TEST_LE(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperLE, v1, v2, on_failure )
#define	IUTEST_TEST_LT(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperLT, v1, v2, on_failure )
#define	IUTEST_TEST_GE(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperGE, v1, v2, on_failure )
#define	IUTEST_TEST_GT(v1, v2, on_failure)				IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperGT, v1, v2, on_failure )

#define IUTEST_TEST_TRUE(v, on_failure)					IUTEST_PRED_FORMAT1_( iuTestAssertion_CompHelperTRUE , v, on_failure)
#define IUTEST_TEST_FALSE(v, on_failure)				IUTEST_PRED_FORMAT1_( iuTestAssertion_CompHelperFALSE, v, on_failure)

#if IUTEST_C_HAS_FLOATINGPOINT

#define IUTEST_TEST_FLOAT_EQ(v1, v2, on_failure)		IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperFloatEQ , v1, v2, on_failure )
#define IUTEST_TEST_DOUBLE_EQ(v1, v2, on_failure)		IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperDoubleEQ, v1, v2, on_failure )

#define IUTEST_TEST_NEAR(v1, v2, abs_v, on_failure)		IUTEST_PRED_FORMAT3_( iuTestAssertion_CompHelperNear, v1, v2, abs_v, on_failure )

#endif

#define	IUTEST_TEST_STREQ(v1, v2, on_failure)			IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperSTREQ, v1, v2, on_failure )
#define	IUTEST_TEST_STRNE(v1, v2, on_failure)			IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperSTRNE, v1, v2, on_failure )
#define	IUTEST_TEST_STRCASEEQ(v1, v2, on_failure)		IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperSTRCASEEQ, v1, v2, on_failure )
#define	IUTEST_TEST_STRCASENE(v1, v2, on_failure)		IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperSTRCASENE, v1, v2, on_failure )

#if defined(IUTEST_OS_WINDOWS)

#define IUTEST_TEST_HRESULT_SUCCEEDED(hr, on_failure)	IUTEST_PRED_FORMAT1_( iuTestAssertion_IsHRESULTSuccess, hr, on_failure )
#define IUTEST_TEST_HRESULT_FAILED(hr, on_failure)		IUTEST_PRED_FORMAT1_( iuTestAssertion_IsHRESULTFailure, hr, on_failure )

#endif

#define IUTEST_TEST_NULL(v, on_failure)					IUTEST_PRED_FORMAT1_( iuTestAssertion_CompHelperNull, v, on_failure )
#define IUTEST_TEST_NOTNULL(v, on_failure)				IUTEST_PRED_FORMAT1_( iuTestAssertion_CompHelperNotNull, v, on_failure )

#define IUTEST_TEST_SAME(v1, v2, on_failure)			IUTEST_PRED_FORMAT2_( iuTestAssertion_CompHelperSame, v1, v2, on_failure )

/**
 * @}
*/

#endif
