/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_config_c.h
 * @brief		iris unit test config t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012-2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_IRIS_iutest_config_c_H_A0485AB5_8AD8_4aa1_ACD1_A8D0F897E5A4_
#define INCG_IRIS_iutest_config_c_H_A0485AB5_8AD8_4aa1_ACD1_A8D0F897E5A4_

/* define ============================================================*/

/**
 * @defgroup	IUTEST_CONFIG	IUTEST_CONFIG
 * @brief		ݒ}N
 * @note		[U[O`邱ƂŕύX\
 * @{
*/

//! Library gǂ
#ifndef IUTEST_C_HAS_LIB
#  if	defined(IUTEST_C_NO_LIB)
#    define IUTEST_C_HAS_LIB		0
#  elif	defined(IUTEST_C_USE_LIB) || defined(IUTEST_C_AUTO_LINK)
#    define IUTEST_C_HAS_LIB		1
#  endif
#endif

#ifndef IUTEST_C_HAS_LIB
#  define IUTEST_C_HAS_LIB			0
#endif

/**
 * @defgroup	IUTEST_CONFIG_C_LANG	C_LANG
 * @brief		@\ CONFIG
 * @{
*/

/*! _gp\ǂ */
#ifndef IUTEST_C_HAS_FLOATINGPOINT
#  ifndef IUTEST_C_NO_FLOATINGPOINT
#    define IUTEST_C_HAS_FLOATINGPOINT	1
#  else
#    define IUTEST_C_HAS_FLOATINGPOINT	0
#  endif
#endif

/*! wchar_t gp\ǂ */
#ifndef IUTEST_C_HAS_WCHAR_T
#  ifndef IUTEST_C_NO_WCHAR_T
#    define IUTEST_C_HAS_WCHAR_T	1
#  else
#    define IUTEST_C_HAS_WCHAR_T	0
#  endif
#endif

/*! stdarg.h gp\ǂ */
#ifndef IUTEST_C_HAS_STDARG
#  ifndef IUTEST_C_NO_STDARG
#    define IUTEST_C_HAS_STDARG		1
#  else
#    define IUTEST_C_HAS_STDARG		0
#  endif
#endif

/*! WCugp\ǂ */
#ifndef IUTEST_C_HAS_LIBC
#  ifndef IUTEST_C_NO_LIBC
#    define IUTEST_C_HAS_LIBC		1
#  else
#    define IUTEST_C_HAS_LIBC		0
#  endif
#endif

/*! stdint.h 邩ǂ */
#ifndef IUTEST_C_HAS_HDR_STDINT
#  if defined(_MSC_VER) && _MSC_VER < 1600
#    define IUTEST_C_HAS_HDR_STDINT	0
#  else
#    define IUTEST_C_HAS_HDR_STDINT	1
#  endif
#endif

/*! malloc ֐gp\ǂ */
#ifndef IUTEST_C_HAS_MALLOC
#  if !defined(IUTEST_C_NO_MALLOC) && IUTEST_C_HAS_LIBC
#    define IUTEST_C_HAS_MALLOC		1
#  else
#    define IUTEST_C_HAS_MALLOC		0
#  endif
#endif

/*! long long gp\ǂ */
#ifndef IUTEST_C_HAS_LONGLONG
#  ifndef IUTEST_C_NO_LONGLONG
#    define IUTEST_C_HAS_LONGLONG	1
#  else
#    define IUTEST_C_HAS_LONGLONG	0
#  endif
#endif

/*! ϒ}Ngp\ǂ */
#ifndef IUTEST_C_HAS_VARIADIC_MACROS
#  ifdef IUTEST_C_NO_VARIADIC_MACROS
#    define IUTEST_C_HAS_VARIADIC_MACROS	0
#  else
#    define IUTEST_C_HAS_VARIADIC_MACROS	1
#  endif
#endif

/**
 * @}
*/

/**
 * @defgroup	IUTEST_CONFIG_OUTPUT	OUTPUT
 * @brief		o͊֌W CONFIG
 * @{
*/

//!< vprintf Ăяo}N
#ifndef IUTEST_VPRINTF
#  if IUTEST_C_HAS_LIBC
#    define IUTEST_VPRINTF(f, a)	vprintf(f, a)
#  else
#    define IUTEST_VPRINTF(f, a)	(void)0
#  endif
#endif

/**
 * @}
*/

/**
 * @defgroup	IUTEST_CONFIG_TEST	TEST
 * @brief		eXg֌W CONFIG
 * @{
*/

/*! p^CY֐R[eXggp\ǂ */
#ifndef IUTEST_C_HAS_PARAM_METHOD_TEST
#  if IUTEST_C_HAS_VARIADIC_MACROS
#    define IUTEST_C_HAS_PARAM_METHOD_TEST	1
#  else
#    define IUTEST_C_HAS_PARAM_METHOD_TEST	0
#  endif
#endif

/*! l̃p[^eXggp\ǂ */
#ifndef IUTEST_C_HAS_PARAM_TEST
#  if IUTEST_C_HAS_VARIADIC_MACROS
#    define IUTEST_C_HAS_PARAM_TEST		1
#  else
#    define IUTEST_C_HAS_PARAM_TEST		0
#  endif
#endif

/*! lp[^eXggp\ǂ */
#ifndef IUTEST_C_HAS_PARAM_TEST
#  define IUTEST_C_HAS_PARAM_TEST		0
#endif

/**
 * @}
*/

/**
 * @defgroup	IUTEST_CONFIG_FILE	FILE
 * @brief		t@C֌W CONFIG
 * @{
*/

/*! FILE IO ֌W̊֐gp\ǂ */
#ifndef IUTEST_C_HAS_FILEAPI
#  if	!defined(IUTEST_C_NO_FILEAPI) && IUTEST_C_HAS_LIBC
#    define IUTEST_C_HAS_FILEAPI	1
#  else
#    define IUTEST_C_HAS_FILEAPI	0
#  endif
#endif

/**
 * @}
*/

/**
 * @defgroup	IUTEST_CONFIG_TIME	TIME
 * @brief		TIME֌W CONFIG
 * @{
*/

/*! time.h 邩ǂ */
#ifndef IUTEST_C_HAS_HDR_TIME
#  if IUTEST_C_HAS_LIBC
#    define IUTEST_C_HAS_HDR_TIME	1
#  else
#    define IUTEST_C_HAS_HDR_TIME	0
#  endif
#endif

/*! time ֐gp\ǂ */
#ifndef IUTEST_C_HAS_CTIME
#  if IUTEST_C_HAS_HDR_TIME
#    define IUTEST_C_HAS_CTIME		1
#  else
#    define IUTEST_C_HAS_CTIME		0
#  endif
#endif

/*! gettimeofday ֐gp\ǂ */
#ifndef IUTEST_C_HAS_GETTIMEOFDAY
#  if IUTEST_HAS_HDR_SYSTIME
#    define IUTEST_C_HAS_GETTIMEOFDAY	1
#  else
#    define IUTEST_C_HAS_GETTIMEOFDAY	0
#  endif
#endif

/*! clock ֐gp\ǂ */
#ifndef IUTEST_C_HAS_CLOCK
#  ifdef CLOCKS_PER_SEC
#    define IUTEST_C_HAS_CLOCK		1
#  else
#    define IUTEST_C_HAS_CLOCK		0
#  endif
#endif

/**
 * @}
*/

/**
 * @defgroup	IUTEST_CONFIG_OTHER	OTHER
 * @brief		̑ CONFIG
 * @{
*/

/**
 * @}
*/

/**
 * @defgroup	IUTEST_CONFIG_POOL	MEMORY_POOL
 * @brief		v[ CONFIG
 * @{
*/

#if !IUTEST_C_HAS_MALLOC || defined(IUTEST_BUILD_DOXYGEN)

/*! malloc gȂꍇ TestResult  Pool  */
#ifndef IUTEST_C_TESTPARTRESULT_POOL_COUNT
#  define IUTEST_C_TESTPARTRESULT_POOL_COUNT	512
#endif

/*! malloc gȂꍇ TestProerty  Pool  */
#ifndef IUTEST_C_TESTPROPERTY_POOL_COUNT
#  define IUTEST_C_TESTPROPERTY_POOL_COUNT		128
#endif

/*! malloc gȂꍇ TestListner  Pool  */
#ifndef IUTEST_C_LISTENER_POOL_COUNT
#  define IUTEST_C_LISTENER_POOL_COUNT			8
#endif

/*! malloc gȂꍇ iuTestGlobalEnvSetUp  Pool  */
#ifndef IUTEST_C_GLOBALENVSETUP_POOL_COUNT
#  define IUTEST_C_GLOBALENVSETUP_POOL_COUNT	8
#endif

/*! malloc gȂꍇ iuTestGlobalEnvTearDown  Pool  */
#ifndef IUTEST_C_GLOBALENVTEARDOWN_POOL_COUNT
#  define IUTEST_C_GLOBALENVTEARDOWN_POOL_COUNT	8
#endif

/*! malloc gȂꍇ eXgbZ[Wobt@  Pool  */
#ifndef IUTEST_C_TESTMSGBUFFER_POOL_COUNT
#  define IUTEST_C_TESTMSGBUFFER_POOL_COUNT		16*1024
#endif

#endif

/**
 * @}
*/


// Doxygen p
#ifdef IUTEST_BUILD_DOXYGEN

#define IUTEST_C_NO_FLOATINGPOINT	/*!< _gȂꍇ͒` */
#define IUTEST_C_NO_WCHAR_T			/*!< wchar_t Ȃꍇ͒` */
#define IUTEST_C_NO_STDARG			/*!< stdarg.h Ȃꍇ͒` */
#define IUTEST_C_NO_LIBC			/*!< libc gȂꍇ͒` */
#define IUTEST_C_NO_MALLOC			/*!< malloc Ȃꍇ͒` */
#define IUTEST_C_NO_LONGLONG		/*!< long long gȂꍇ */
#define IUTEST_C_NO_GETENV			/*!< getenv Ȃꍇ */
#define IUTEST_C_NO_PUTENV			/*!< putenv Ȃꍇ */

#endif

/**
 * @}
*/

/**
 * @private
 * @{
*/

// include only
#ifndef IUTEST_C_INL_INLINE
#  if IUTEST_C_HAS_LIB
#    define IUTEST_C_INL_INLINE
#  else
#    define IUTEST_C_INL_INLINE		static
#  endif
#endif

// auto link
#if IUTEST_C_HAS_LIB && defined(IUTEST_C_AUTO_LINK)

#if defined(_MSC_VER)

#if defined(_MT) || defined(__MT__)
#  if	defined(_DLL)
#    define IUTEST_LIB_THREAD_OPT	"md"
#  else
#    define IUTEST_LIB_THREAD_OPT	"mt"
#  endif
#else
#  define IUTEST_LIB_THREAD_OPT	""
#endif

#if		_MSC_VER == 1400
#  define IUTEST_LIB_TOOLSET	"vc80"
#elif	_MSC_VER == 1500
#  define IUTEST_LIB_TOOLSET	"vc90"
#elif	_MSC_VER == 1600
#  define IUTEST_LIB_TOOLSET	"vc100"
#elif	_MSC_VER == 1700
#  define IUTEST_LIB_TOOLSET	"vc110"
#else
#  error unkown _MSC_VER.
#endif

#if		defined(_DEBUG)
#  define IUTEST_LIB_RT_OPT		"d"
#else
#  define IUTEST_LIB_RT_OPT		""
#endif

#define IUTEST_LIB_NAME(name)	#name "-" IUTEST_LIB_TOOLSET "-" IUTEST_LIB_THREAD_OPT IUTEST_LIB_RT_OPT ".lib"

#pragma comment(lib, IUTEST_LIB_NAME(libiutest_c) )

#endif

#endif

/**
 * @}
*/

#endif
