/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_param_tests_c.h
 * @brief		iris unit test parameter ` t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_IRIS_iutest_param_tests_C_H_3DBBF55E_A076_4207_B49E_34734EE333EE_
#define INCG_IRIS_iutest_param_tests_C_H_3DBBF55E_A076_4207_B49E_34734EE333EE_

/* include ===========================================================*/
#include "iutest_core_c.h"

#if IUTEST_C_HAS_PARAM_TEST

/* define ============================================================*/

/**
 * @ingroup	TESTDEF
 * @def		IUTEST_INSTANTIATE_TEST_CASE_P
 * @brief	p[^eXgCX^X}N
 * @param	type_		= p[^̌^
 * @param	prefix_		= CX^X
 * @param	testcase_	= eXgP[X
 * @param	generator_	= p^[
 * @param	...			= params
*/
#define IUTEST_INSTANTIATE_TEST_CASE_P(type_, prefix_, testcase_, generator_, ...)	\
													IIUT_INSTANTIATE_TEST_CASE_P_(type_, prefix_, testcase_, generator_, __VA_ARGS__)

/**
 * @ingroup TESTDEF
 * @brief	p[^eXgCX^X̖Io^
*/
#define IUTEST_REGISTER_TEST_CASE_P(prefix_, testcase_)	IUTEST_C_CALL_INITIALIZATION_SECTION(IIUT_C_TEST_P_ADD_HOLDER_SECTION_NAME(prefix_, testcase_))

/**
 * @ingroup	TESTDEF
 * @def		IUTEST_P(testcase_, testname_)
 * @brief	p[^[U[weXg֐`}N
 * @param	type_		= p[^̌^
 * @param	testcase_	= eXgP[X
 * @param	testname_	= eXg
 * @note	
 *  IUTEST_P(Type, TestCaseName, TestName) {}\n
 *  IUTEST_INSTANTIATE_TEST_CASE_P(Type, InstantiateName, TestCaseName, ParamGenerator, Params);\n
*/
#define IUTEST_P(type_, testcase_, testname_)	IIUT_TEST_P_(type_, testcase_, testname_)

/**
 * @ingroup	TESTDEF
 * @def		IUTEST_P_F(testcase_, testname_)
 * @brief	p[^[U[weXg֐`}N(tBNX`Ή)
 * @param	type_		= p[^̌^
 * @param	testcase_	= eXgP[X
 * @param	testname_	= eXg
 * @note	
 *  IUTEST_P_F(Type, TestCaseName, TestName) {}\n
 *  IUTEST_INSTANTIATE_TEST_CASE_P(Type, InstantiateName, TestCaseName, ParamGenerator, Params);\n
*/
#define IUTEST_P_F(type_, testcase_, testname_)	IIUT_TEST_PF_(type_, testcase_, testname_)

/**
 * @brief	l̃p[^
*/
#define iuValues(type_, prefix_, testcase_, ...)		IIUT_TEST_P_VALUES(type_, prefix_, testcase_, __VA_ARGS__)

/**
 * @brief	͈̓p[^
*/
#if defined(__GNUC__)
#  define iuRange(type_, prefix_, testcase_, begin, end, ...)	IIUT_TEST_P_RANGE(type_, prefix_, testcase_, begin, end, ##__VA_ARGS__, 1)
#else
#  define iuRange(type_, prefix_, testcase_, begin, end)		IIUT_TEST_P_RANGE(type_, prefix_, testcase_, begin, end, 1)
#endif

/**
 * @brief	͈̓p[^
*/
#define iuStepRange(type_, prefix_, testcase_, begin, end, step)	IIUT_TEST_P_RANGE(type_, prefix_, testcase_, begin, end, step)

/**
 * @private
 * @{
*/

#define IIUT_TEST_P_VALUES(type_, prefix_, testcase_, ...)							\
	static type_ IIUT_C_TEST_P_PARAMS_NAME(prefix_, testcase_)[] = { __VA_ARGS__ };	\
	void IIUT_C_TEST_P_INIT_PARAMS_DECL_NAME(prefix_, testcase_)(void) {}

#define IIUT_TEST_P_RANGE(type_, prefix_, testcase_, begin, end, step, ...)							\
	IUTEST_STATIC_ASSERT((begin <= end) && (step > 0));												\
	static type_ IIUT_C_TEST_P_PARAMS_NAME(prefix_, testcase_)[(end-begin+step-1)/step];			\
	void IIUT_C_TEST_P_INIT_PARAMS_DECL_NAME(prefix_, testcase_)(void) {							\
		type_ n=begin; size_t i=0;																	\
		for( ; i < IIUT_C_TEST_P_PARAMS_COUNT(prefix_, testcase_); n+=step, ++i ) {					\
			IIUT_C_TEST_P_PARAMS_NAME(prefix_, testcase_)[i] = n; }									\
	}

#define IIUT_INSTANTIATE_TEST_CASE_P_(type_, prefix_, testcase_, generator_, ...)					\
	IUTEST_PP_EXPAND( generator_(type_, prefix_, testcase_, __VA_ARGS__) )							\
	static iuTestCase IIUT_C_TEST_P_PARAMS_TESTCASE_ARRAY_NAME(prefix_, testcase_)[					\
								IIUT_C_TEST_P_PARAMS_COUNT(prefix_, testcase_)];					\
	static iuTestParamHolder IIUT_C_TEST_P_PARAMS_HOLDER_NAME(prefix_, testcase_) =					\
		iuTestParamHolder_ctor(testcase_, IIUT_C_TEST_P_PARAMS_TESTCASE_ARRAY_NAME(prefix_, testcase_)	\
		, IIUT_C_TEST_P_PARAMS_NAME(prefix_, testcase_));											\
	static const char** IIUT_C_TEST_P_GET_TESTCASENAMES_DECL_NAME(prefix_, testcase_)(void) {		\
		static const char dummy[] = IUTEST_PP_TOSTRING( prefix_/testcase_/0 );						\
		const size_t dummy_len = IUTEST_PP_COUNTOF(dummy);											\
		static char names[IIUT_C_TEST_P_PARAMS_COUNT(prefix_, testcase_)][IUTEST_PP_COUNTOF(dummy)+32];	\
		static const char* names_ptr[IIUT_C_TEST_P_PARAMS_COUNT(prefix_, testcase_)]; size_t i=0;	\
		for( i=0; i < IIUT_C_TEST_P_PARAMS_COUNT(prefix_, testcase_); ++i ) {						\
			iu_memcpy(names[i], dummy, sizeof(dummy));												\
			iu_itoa(i, &names[i][dummy_len-2], 10);													\
			names_ptr[i] = &names[i][0];															\
		} return &names_ptr[0];																		\
	}																								\
	IUTEST_C_DECL_INITIALIZATION_SECTION_BEGIN( IIUT_C_TEST_P_ADD_HOLDER_SECTION_NAME(prefix_, testcase_) )	\
		IIUT_C_TEST_P_INIT_PARAMS_DECL_NAME(prefix_, testcase_)();									\
		IIUT_C_TEST_P_PARAMS_HOLDER_NAME(prefix_, testcase_).testcase_names =						\
		IIUT_C_TEST_P_GET_TESTCASENAMES_DECL_NAME(prefix_, testcase_)();							\
		iuUnitTest_AddTestParamHolder(&IIUT_C_TEST_P_PARAMS_HOLDER_NAME(prefix_, testcase_));		\
	IUTEST_C_DECL_INITIALIZATION_SECTION_END()

#define IIUT_TEST_P_(type_, testcase_, testname_)	\
		IIUT_C_TEST_P_ADD_(type_, testcase_, testname_, NULL, NULL, NULL, NULL, NULL)

#define IIUT_TEST_PF_(type_, testfix_, testname_)	\
		IIUT_C_TEST_P_ADD_(type_, testfix_, testname_, testfix_.setup_testcase	\
		, testfix_.teardown_testcase, testfix_.setup, testfix_.teardown, testfix_.user)

#if IUTEST_C_HAS_MALLOC

#define IIUT_C_TEST_P_ADD_(type_, testcase_, testname_, setup_testcase_, teardown_testcase_, setup_, teardown_, user_)	\
	IIUT_C_TEST_P_ADD_I_(type_, testcase_, testname_, setup_testcase_, teardown_testcase_		\
	, setup_, teardown_, user_, iuUnitTest_AllocTestCase)

#else

#define IIUT_C_TEST_P_ADD_(type_, testcase_, testname_, setup_testcase_, teardown_testcase_, setup_, teardown_, user_)	\
	static iuTestCase * IUTEST_PP_CAT(iutest_c_alloc_##testcase_##_dummy_, __LINE__)(void) {	\
	static iuTestCase instance; return &instance; }												\
	IIUT_C_TEST_P_ADD_I_(type_, testcase_, testname_, setup_testcase_, teardown_testcase_		\
	, setup_, teardown_, user_, IUTEST_PP_CAT(iutest_c_alloc_##testcase_##_dummy_, __LINE__))

#endif

#define IIUT_C_TEST_P_ADD_I_(type_, testcase_, testname_, setup_testcase_, teardown_testcase_, setup_, teardown_, user_, allocator_)	\
	void IIUT_C_TEST_BODY_DECL_NAME(testcase_, testname_)(void);														\
	static iuTestInfo IIUT_C_TEST_INFO_DECL_NAME(testcase_, testname_) = 												\
	iuTestInfo_ctor(#testname_, IIUT_C_TEST_BODY_DECL_NAME(testcase_, testname_) );										\
	IUTEST_C_DECL_INITIALIZATION_SECTION_BEGIN( IIUT_C_TEST_INITIALIZATION_SECTION_NAME(testcase_, testname_) )			\
	iuTestCase_AddTestInfo(iuUnitTest_AddParameterizedTestCase(#testcase_, setup_testcase_, teardown_testcase_, allocator_),			\
	& IIUT_C_TEST_INFO_DECL_NAME(testcase_, testname_) );																\
	IIUT_C_TEST_INFO_DECL_NAME(testcase_, testname_).test.setup = setup_;												\
	IIUT_C_TEST_INFO_DECL_NAME(testcase_, testname_).test.teardown = teardown_;											\
	IIUT_C_TEST_INFO_DECL_NAME(testcase_, testname_).test.user = user_;													\
	IUTEST_C_DECL_INITIALIZATION_SECTION_END()																			\
	void IIUT_C_TEST_P_BODY_DECL_NAME(testcase_, testname_)(type_ param);												\
	void IIUT_C_TEST_BODY_DECL_NAME(testcase_, testname_)(void) {														\
		iuTestInfo* info = iuUnitTest_GetCurrentTestInfo();																\
		type_ param = *(type_*)(info->param);																			\
		IIUT_C_TEST_P_BODY_DECL_NAME(testcase_, testname_)(param);														\
	}																													\
	void IIUT_C_TEST_P_BODY_DECL_NAME(testcase_, testname_)(type_ param)

#define IIUT_C_TEST_P_SETUP_PARAMS_DECL_NAME(prefix_, testcase_)		iutest_c_test_p_setup_params_##prefix_##_##testcase_##_
#define IIUT_C_TEST_P_INIT_PARAMS_DECL_NAME(prefix_, testcase_)			iutest_c_test_p_init_params_##prefix_##_##testcase_##_
#define IIUT_C_TEST_P_GET_TESTCASENAMES_DECL_NAME(prefix_, testcase_)	iutest_c_test_p_get_testcase_names_##prefix_##_##testcase_##_
#define IIUT_C_TEST_P_ADD_HOLDER_SECTION_NAME(prefix_, testcase_)		iutest_c_test_p_add_holder_dummy_##prefix_##_##testcase_##_
#define IIUT_C_TEST_P_PARAMS_TESTCASE_ARRAY_NAME(prefix_, testcase_)	iutest_c_test_p_params_testcases_##prefix_##_##testcase_##_
#define IIUT_C_TEST_P_PARAMS_HOLDER_NAME(prefix_, testcase_)	iutest_c_test_p_params_holder_##prefix_##_##testcase_##_
#define IIUT_C_TEST_P_PARAMS_NAME(prefix_, testcase_)			iutest_c_test_p_params_##prefix_##_##testcase_##_x_
#define IIUT_C_TEST_P_BODY_DECL_NAME(testcase_, testname_)		iutest_c_test_p_body_##testcase_##_##testname_##_

#define IIUT_C_TEST_P_PARAMS_COUNT(prefix_, testcase_)			IUTEST_PP_COUNTOF(IIUT_C_TEST_P_PARAMS_NAME(prefix_, testcase_))

/**
 * @}
*/

#endif	/* IUTEST_C_HAS_PARAM_TEST */

#endif
